jQuery(document).ready(function ($) {






    $(function () {
        var socket = io("https://aazztech.herokuapp.com/");
        var chatMsg = $('#m');
        $("form").submit(function (e) {
          e.preventDefault();		  
          socket.emit("chat message", chatMsg.val());
          chatMsg.val("");
          return false;
        });
		
        socket.on("chat message", function (msg) {		
          $("#messages").append($("<li>").text(msg));		  
        });		
      });




    /**
     * @package Directorist
     * @type {*|jQuery|HTMLElement}
     * Submit single chat
     */
    var chatInterval = dlc_js_api.reload_interval;
    var chatSubmit = $('#publicChatForm');
    if (chatSubmit.length > 0) {
        $(chatSubmit).on('submit', function (e) {
            e.preventDefault();
            var chatMsg = $('input[name="chatMsg"]');
            var chatListing_id = $('input[name="chatListing_id"]').val();
            var chatAuthor_id = $('input[name="chatAuthor_id"]').val();
            var formData = new FormData();
            formData.append('chatMsg', chatMsg.val());
            formData.append('chatListing_id', chatListing_id);
            formData.append('chatAuthor_id', chatAuthor_id);
            formData.append('action', 'atbdp_live_chat');
            $('#user_message_container').addClass("atbd_load");
            $.ajax({
                url: dlc_js_api.ajaxurl,
                method: 'POST',
                data: formData,
                crossDomain: true,
                processData: false,
                contentType: false,
                success: function (response) {
                    //console.log(response);
                    chatMsg.val('');
                    setInterval(getChats, chatInterval);
                    $('#user_message_container').removeClass("atbd_load");
                },
                error: function (error) {
                    console.log(error);
                }

            });
        });
    }
    var adminChatForm = $('#adminChatForm');
    if (adminChatForm.length > 0) {
        $(adminChatForm).on('submit', function (e) {
            e.preventDefault();
            var chatMsg = $('input[name="chatMsg"]');
            var chatListing_id = $('input[name="chatListing_id"]').val();
            var chatAuthor_id = $('.mas-chat-user-id').val();
            var formData = new FormData();
            formData.append('chatMsg', chatMsg.val());
            formData.append('chatListing_id', chatListing_id);
            formData.append('chatAuthor_id', chatAuthor_id);
            formData.append('action', 'atbdp_live_chat');
            $('#live_chat').addClass("atbd_load");
            $.ajax({
                url: dlc_js_api.ajaxurl,
                method: 'POST',
                data: formData,
                crossDomain: true,
                processData: false,
                contentType: false,
                success: function (response) {
                    chatMsg.val('');
                    getAdminChats(response['listing_id'], response['chat_author_id']);
                    $('#live_chat').removeClass("atbd_load");
                  
                },
                error: function (error) {
                    //console.log(error);
                }

            });
        });
    }

    /**
     * @package Directorist
     * @type {*|jQuery|HTMLElement}
     * @fires load chat automatically
     */

    var chatContainer_user = $('#user_message_container');
    // load chats
    var chatContainer_admin = $('#admin_message_container');
    var adminChatForm = $('#adminChatForm');
    if (adminChatForm) {
        setInterval(function () {
            var listingId = $('input[name^="chatListing_id"]').val();
            var chatAuthor_id = $('.mas-chat-user-id').val();
             getAdminChats(listingId, chatAuthor_id)
        }, chatInterval)
    }

    $('.atbdp-start-chat-btn').on('click', function () {
        if (chatContainer_user.length > 0) {
            setInterval(getChats, chatInterval);
        }

    });


    /**
     * @package Directorist
     * @type {*|jQuery|HTMLElement}
     * @fires load chat when filtered by listing
     */

    if (chatContainer_admin.length > 0) {
        setInterval($('body').on('click', '.chatted-listing', function (e) {
            e.preventDefault();
            var listingID = $(this).attr('data-listing-id');
            var listingTitle = $(this).attr('data-listing-title');
            var listingLink = $(this).attr('data-listing-link');
            var listingImgSrc = $(this).attr('data-listing-image-src');
            var chatAuthorId = $(this).attr('data-chat-user-id');
            var chatAuthorName = $(this).attr('data-chat-user-name');
            var chatAuthorImg = $(this).attr('data-chat-user-img');
            $('input[name^="chatListing_id"]').val(listingID);
            $('.mas-listing-title').empty().append(listingTitle);
            $('.mas-chat-username').empty().append(chatAuthorName);
            $('.mas-chat-user-img').empty().append(chatAuthorImg);
            $('.mas-chat-user-id').val(chatAuthorId);
            $('.mas-listing-image').empty().attr('src', listingImgSrc);
            $('.mas-listing-link').attr('href', listingLink);
            getAdminChats(listingID, chatAuthorId)
        }), chatInterval)
    }

    /**
     * @package Directorist
     * @type {*|jQuery|HTMLElement}
     * @fires load chat when filtered by user
     */
    if (chatContainer_admin.length > 0) {
        setInterval($('body').on('click', '.all-chatted-authors', function (e) {
            $('.all-chatted-authors').removeClass('active');
            e.preventDefault();
            var authorId = $(this).attr('data-chatAuthor');
            var authorNmae = $(this).attr('data-chatAuthorName');
            var authorImg = $(this).attr('data-chatAuthorImg');
            var listingId = $('input[name^="chatListing_id"]').val();
            $('.mas-chat-username').empty().append(authorNmae);
            $('.mas-chat-user-img').empty().append(authorImg);
            $('.mas-chat-user-id').val(authorId);
            getAdminChats(listingId, authorId)
            $(this).addClass('active');
        }), chatInterval)
    }


    /**
     * @package Directorist
     * @type {*|jQuery|HTMLElement}
     *
     */

    /*    $('body').on('click', '.mas-delete-chat', function (e) {
            e.preventDefault();
            var chatListing_id = $('input[name^="chatListing_id"]').val();
            var chatAuthor_id = $('input[name="chatAuthor_id"]').val();
            var formData = new FormData();
            formData.append('chatListing_id', chatListing_id);
            formData.append('chatAuthor_id',  chatAuthor_id);
            formData.append('action', 'atbdp_delete_chat_history');
            $.ajax({
                url: dlc_js_api.ajaxurl,
                method: 'POST',
                data: formData,
                crossDomain: true,
                processData: false,
                contentType: false,
                success: function (response) {
                   console.log(response)
                },
                error: function (error) {
                    console.log(error);
                }

            });
        });*/


            /**
     * @package Directorist
     * @type {*|jQuery|HTMLElement}
     * @fires push elemens to bottom
     */

    function scrollToButtom(){
            //stick scrollbar always at bottom
            if ($('#adminMessages').length > 0) {
                $('#adminMessages').scrollTop($('#adminMessages')[0].scrollHeight);
            }
            if ($('#userMessages').length > 0) {
                $('#userMessages').scrollTop($('#userMessages')[0].scrollHeight);
            }
    }


    /**
     * @package Directorist
     * @type {*|jQuery|HTMLElement}
     * @return HTML as Ajax response for single listing
     */
    function getChats() {

        var chatListing_id = $('input[name="chatListing_id"]').val();
        var chatAuthor_id = $('input[name="chatAuthor_id"]').val();
        var formData = new FormData();
        formData.append('chatListing_id', chatListing_id);
        formData.append('chatAuthor_id', chatAuthor_id);
        formData.append('action', 'atbdp_get_chat_history');

        $.ajax({
            url: dlc_js_api.ajaxurl,
            method: 'POST',
            data: formData,
            crossDomain: true,
            processData: false,
            contentType: false,
            success: function (response) {
                $('#userMessages').empty().append(response);
                scrollToButtom();
            },
            error: function (error) {
                console.log(error);
            }

        });
    }
    

    /**
     * @package Directorist
     * @type {*|jQuery|HTMLElement}
     * @return HTML as Ajax response in user dashboard
     */
    function getAdminChats(listingId, chatAuthorId) {

        var chatListing_id = listingId;
        var chatAuthor_id = $('input[name="chatAuthor_id"]').val();
        var formData = new FormData();
        formData.append('chatListing_id', chatListing_id);
        formData.append('chatAuthor_id', chatAuthorId ? chatAuthorId : chatAuthor_id);
        formData.append('action', 'atbdp_get_admin_chat_history');
        $.ajax({
            url: dlc_js_api.ajaxurl,
            method: 'POST',
            data: formData,
            crossDomain: true,
            processData: false,
            contentType: false,
            success: function (response) {
                $('#adminMessages').empty().append(response);
                scrollToButtom();
            },
            error: function (error) {
                console.log(error);
            }

        });
    }

    $('.atbdp-start-chat-btn').on('click', function (e) {
        e.preventDefault();
        var spText = $(".atbdp-start-chat-btn span");
        $(".atndp-chat-content-area").toggleClass("atbd-show");
        spText.toggleClass("active");
        spText.hasClass("active") ? spText.text(dlc_js_api.hide_chat_button) : spText.text(dlc_js_api.show_chat_button);
        $(this).toggleClass("active");
        $(this).parents(".atbdp-chat-wrapper").toggleClass("active");
    });

    if ($('#adminMessages').length > 0) {
        $('#adminMessages').scrollTop($('#adminMessages')[0].scrollHeight);
    }
    if ($('#userMessages').length > 0) {
        $('#userMessages').scrollTop($('#userMessages')[0].scrollHeight);
    }

    //show login alert
    var dcln = $('.dcl_login_notice');
    dcln.hide();
    $('.dcl_login_alert ').on('click', function (e) {
        e.preventDefault();
        dcln.slideDown();
    });

    /* tab functionality */
    (function () {
        pureScriptTab2 = (selector1) => {
            var selector = document.querySelectorAll(selector1);
            selector.forEach((el, index) => {
                a = el.querySelectorAll('.atbdlc_tn_link');


                a.forEach((element, index) => {

                    element.style.cursor = 'pointer';
                    element.addEventListener('click', (event) => {
                        event.preventDefault();
                        event.stopPropagation();

                        var ul = event.target.closest('.atbdlc_tab_nav'),
                            main = ul.nextElementSibling,
                            item_a = ul.querySelectorAll('.atbdlc_tn_link'),
                            section = main.querySelectorAll('.atbdlc_tab_inner');

                        item_a.forEach((ela, ind) => {
                            ela.classList.remove('lc_tabItemActive');
                        });
                        event.target.classList.add('lc_tabItemActive');


                        section.forEach((element1, index) => {
                            //console.log(element1);
                            element1.classList.remove('lc_tabContentActive');
                        });
                        var target = event.target.target;
                        document.getElementById(target).classList.add('lc_tabContentActive');
                    });
                });
            });
        };
    })();
    pureScriptTab2('.atbd-message-tabs');
});
