<?php
defined('ABSPATH') || die('No direct script access allowed!');
/**
 * @package Directorist
 * @since 1.0.0
 */
if (!function_exists('get_chats')){
    function get_chats($listing_author = null, $chat_author = null, $chatListing_id = null)
    {
        $args = array(
            'post_type' => 'atbdp_chat',
            'order' => 'ASC',
            'posts_per_page' => -1,
        );

        $meta_queries = array();
        $meta_queries[] = array(
            'relation' => 'OR',
            array(
                'key' => '_chat_listing_author',
                'value' => !empty($listing_author) ? $listing_author : get_current_user_id(),
                'compare' => '='
            ),
            array(
                'key' => '_chatAuthor_id',
                'value' => !empty($chat_author) ? $chat_author : get_current_user_id(),
                'compare' => '='
            ),
        );

        if (!empty($chatListing_id)) {
            $meta_queries[] = array(
                'key' => '_chatListing_id',
                'value' => !empty($chatListing_id) ? $chatListing_id : '',
                'compare' => '='
            );
        }

        $count_meta_queries = count($meta_queries);
        if ($count_meta_queries) {
            $args['meta_query'] = ($count_meta_queries > 1) ? array_merge(array('relation' => 'AND'), $meta_queries) : $meta_queries;
        }
        $chats = new WP_Query($args);
        return $chats;
    }
}

if (!function_exists('get_chat_by_user')){
    function get_chat_by_user($listing_author = null, $chat_author = null, $chatListing_id = null)
    {
        $args = array(
            'post_type' => 'atbdp_chat',
            'order' => 'ASC',
            'posts_per_page' => -1,
        );

        $meta_queries = array();
        $meta_queries[] = array(
            'relation' => 'AND',
            array(
                'key' => '_chat_listing_author',
                'value' => !empty($listing_author) ? $listing_author : '',
                'compare' => '='
            ),
            array(
                'key' => '_chatAuthor_id',
                'value' => !empty($chat_author) ? $chat_author : '',
                'compare' => '='
            ),
        );

        if (!empty($chatListing_id)) {
            $meta_queries[] = array(
                'key' => '_chatListing_id',
                'value' => !empty($chatListing_id) ? $chatListing_id : '',
                'compare' => '='
            );
        }

        $count_meta_queries = count($meta_queries);
        if ($count_meta_queries) {
            $args['meta_query'] = ($count_meta_queries > 1) ? array_merge(array('relation' => 'AND'), $meta_queries) : $meta_queries;
        }
        $chats = new WP_Query($args);
        return $chats;
    }
}

if (!function_exists('get_chatted_listings')){
    function get_chatted_listings($listing_author = null, $chat_author = null, $chatListing_id = null){
        $args = array(
            'post_type' => 'atbdp_chat',
            'order' => 'ASC',
            'posts_per_page' => -1,
            'meta_key' =>  '_chat_listing_author',
            'meta_value' => !empty($listing_author) ? $listing_author : get_current_user_id(),
            'compare' => '='
        );
        $chats = new WP_Query($args);
        if ($chats->have_posts()){
            $listing_ids = array();
            foreach ($chats->get_posts() as $post){
                $post_id = $post->ID;
                $listing_id = get_post_meta($post_id, '_chatListing_id', true);
                array_push($listing_ids, $listing_id);
            }
            return array_unique($listing_ids);
        }
    }
}

if(!function_exists('listing_chat_exists_by_user')){
    function listing_chat_exists_by_user($listing_author = null, $chat_author = null, $chatListing_id = null){
        $args = array(
            'post_type' => 'atbdp_chat',
            'order' => 'ASC',
            'posts_per_page' => -1,
            'author' => !empty($chat_author) ? (int)$chat_author : get_current_user_id(),
        );
        $meta_queries = array();
        $meta_queries[] = array(
            'relation' => 'AND',
            array(
                'key' => '_chatAuthor_id',
                'value' =>  !empty($chat_author) ? (int)$chat_author : '',
                'compare' => '='
            ),
            array(
                'key' => '_chatListing_id',
                'value' => !empty($chatListing_id) ? (int)$chatListing_id : get_the_ID(),
                'compare' => '='
            ),
        );
        $count_meta_queries = count($meta_queries);
        if ($count_meta_queries) {
            $args['meta_query'] = ($count_meta_queries > 1) ? array_merge(array('relation' => 'AND'), $meta_queries) : $meta_queries;
        }
        $chats = new WP_Query($args);
        return $chats;
    }
}

if(!function_exists('listing_chat_by_admin')){
    function listing_chat_by_admin( $chat_author = null, $chatListing_id = null){
        $args = array(
            'post_type' => 'atbdp_chat',
            'order' => 'ASC',
            'posts_per_page' => -1,
        );
        $meta_queries = array();
        $meta_queries[] = array(
            'relation' => 'AND',
            array(
                'key' => '_chatAuthor_id',
                'value' =>  !empty($chat_author) ? (int)$chat_author : '',
                'compare' => '='
            ),
            array(
                'key' => '_chatListing_id',
                'value' => !empty($chatListing_id) ? (int)$chatListing_id : '',
                'compare' => '='
            ),
        );
        $count_meta_queries = count($meta_queries);
        if ($count_meta_queries) {
            $args['meta_query'] = ($count_meta_queries > 1) ? array_merge(array('relation' => 'AND'), $meta_queries) : $meta_queries;
        }
        $chats = new WP_Query($args);
        return $chats;
    }
}

if(!function_exists('all_chatted_user_by_listing')){
    function all_chatted_user_by_listing($chatListing_id){
        $args = array(
            'post_type' => 'atbdp_chat',
            'order' => 'ASC',
            'posts_per_page' => -1,
            'meta_key' => '_chatListing_id',
            'meta_value' => !empty($chatListing_id) ? (int)$chatListing_id : '',
            'compare' => '='
        );
        $chats = new WP_Query($args);
        if ($chats->have_posts()){
            $author_ids = array();
            foreach ($chats->get_posts() as $post){
                $author_id =  get_post_field('post_author', $post->ID);
                array_push($author_ids, $author_id);
            }
            return array_unique($author_ids);
        }
    }
}