<?php

/*
 * Class: Business Directory Multiple Image = DWPP
 * */
if (!class_exists('DWPP_Admin_Notices')) :
    class DWPP_Admin_Notices
    {
        public function __construct()
        {
            add_action('init', array($this, 'dwpp_load_classes'), 9);

        }

           /**
     * Instantiate classes when woocommerce is activated
     */
    public function dwpp_load_classes()
    {
        if (!class_exists('WooCommerce')) {
            add_action('admin_notices', array($this, 'need_woocommerce'));
            return;
        }
        if (!class_exists('Directorist_Base')) {
            add_action('admin_notices', array($this, 'need_directorist'));
            return;
        }
        
        // Check if HPOS is disabled and show notice
        if (class_exists('WooCommerce') && $this->is_hpos_disabled()) {
            add_action('admin_notices', array($this, 'hpos_disabled_notice'));
        }
    }
    
    /**
     * Check if High-Performance Order Storage (HPOS) is disabled
     *
     * @return bool True if HPOS is disabled
     */
    private function is_hpos_disabled()
    {
        if (!class_exists('\Automattic\WooCommerce\Utilities\OrderUtil')) {
            return false;
        }
        return !\Automattic\WooCommerce\Utilities\OrderUtil::custom_orders_table_usage_is_enabled();
    }


    
    /**
     * WooCommerce not active notice.
     *
     * @return string Fallack notice.
     */

    public function need_directorist()
    {
        $error = sprintf(__('Directorist - WooCommerce Pricing Plans requires %sDirectorist%s to be installed & activated!', 'directorist-woocommerce-pricing-plans'), '<a target="_blank" href="http://wordpress.org/extend/plugins/directorist/">', '</a>');

        $message = '<div class="error notice is-dismissible"><p>' . $error . '</p></div>';
        //deactivate_plugins(plugin_basename( __FILE__ ));

        echo $message;
    }


    /**
     * WooCommerce not active notice.
     *
     * @return string Fallack notice.
     */

    public function need_woocommerce()
    {
        $error = sprintf(__('Directorist - WooCommerce Pricing Plans requires %sWooCommerce%s to be installed & activated!', 'directorist-woocommerce-pricing-plans'), '<a target="_blank" href="http://wordpress.org/extend/plugins/woocommerce/">', '</a>');

        $message = '<div class="error notice is-dismissible"><p>' . $error . '</p></div>';
        //deactivate_plugins(plugin_basename( __FILE__ ));

        echo $message;
    }

    /**
     * High-Performance Order Storage (HPOS) disabled notice.
     *
     * @return void
     */
    public function hpos_disabled_notice()
    {
        // Only show on relevant admin pages
        $screen = get_current_screen();
        if (!$screen || (!in_array($screen->id, ['dashboard', 'woocommerce_page_wc-settings', 'plugins']) && strpos($screen->id, 'directorist') === false)) {
            return;
        }

        $settings_url = admin_url('admin.php?page=wc-settings&tab=advanced&section=features');
        $learn_more_url = 'https://woocommerce.com/document/high-performance-order-storage/';
        $message = sprintf(
            __('%sDirectorist - WooCommerce Pricing Plans%s recommends enabling %sHigh-Performance Order Storage%s for better performance and compatibility. %sEnable HPOS%s', 'directorist-woocommerce-pricing-plans'),
            '<strong>',
            '</strong>',
            '<strong>',
            '</strong>',
            '<a href="' . esc_url($settings_url) . '" class="button button-primary" style="margin-left: 10px;">',
            '</a>'
        );
        $learn_more_link = sprintf(
            '<a href="%s" target="_blank" rel="noopener noreferrer">%s</a>',
            esc_url($learn_more_url),
            __('Learn more here', 'directorist-woocommerce-pricing-plans')
        );

        echo '<div class="notice notice-warning is-dismissible"><p>' . $message . ' <span style="margin-left: 10px;">(' . $learn_more_link . ')</span></p></div>';
    }

    }
endif;
