<?php
defined( 'ABSPATH' ) || die( 'Direct access is not allowed.' );
/**
 * @since 1.7.4
 * @package Directorist
 */
if ( ! class_exists( 'DWPP_Controller' ) ):

    class DWPP_Controller {

        public $meta         = [];
        public $need_payment = false;

        public function __construct() {
            add_filter( 'atbdp_listing_form_submission_info', [$this, 'atpp_process_the_selected_plans'] );
            add_action( 'atbdp_before_processing_submitted_listing_frontend', [$this, 'validate_submission'] );
            add_action( 'add_meta_boxes', [$this, 'dwpp_admin_metabox'] );
            add_action( 'save_post', [$this, 'dwpp_save_metabox'], 13, 2 );
            add_filter( 'atbdp_add_new_listing_column', [$this, 'dwpp_add_new_listing_column'] );
            add_filter( 'atbdp_add_new_listing_column_content', [$this, 'dwpp_add_new_listing_column_content'], 10, 2 );
            add_action( 'atbdp_before_renewal', [$this, 'dwpp_before_renewal'] );
            add_filter( 'atbdp_sortable_custom_post_type', [$this, 'atbdp_sortable_custom_post_type'] );
            add_filter( 'atbdp_listing_meta_user_submission', [$this, 'listing_meta_user_submission'] );

            add_filter( 'atbdp_order_created', [$this, 'atbdp_order_created'], 10, 2 );

            add_filter( 'directorist_before_featured_expire_metabox', [$this, 'directorist_before_featured_expire_metabox'], 10, 2 );

        }

        /**
         * @return bollean
         * @param $post     Edited post
         */

        public function directorist_before_featured_expire_metabox( $load, $post ) {

            $plan_id = get_post_meta( $post->ID, '_fm_plans', true );

            if ( ! empty( $plan_id ) && is_numeric( $plan_id ) ) {
                $load = false;
            }

            return $load;
        }

        public function atbdp_order_created( $order_id, $listing_id ) {
            update_post_meta( $listing_id, '_plan_order_id', $order_id );
            update_post_meta( $listing_id, '_listing_order_id', $order_id );
        }

        public function listing_meta_user_submission( $meta ) {
            $meta['_listing_type'] = ! empty( $_GET['listing_type'] ) ? sanitize_text_field( $_GET['listing_type'] ) : '';
            return $meta;
        }

        public function atbdp_sortable_custom_post_type( $default ) {

            $default['woocommerce_pricing_plan'] = 'product';

            return $default;
        }

        /**
         * @since 1.3.2
         */

        public function dwpp_before_renewal( $listing_id ) {
            update_post_meta( $listing_id, '_refresh_renewal_token', 1 );
            update_post_meta( $listing_id, '_renew_with_plan', 1 );
            $url = add_query_arg( 'renew_with_plan', $listing_id, ATBDP_Permalink::get_dashboard_page_link() );
            wp_safe_redirect( $url );
            exit;
        }

        public function dwpp_add_new_listing_column_content( $column = null, $listing_id = null ) {
            switch ( $column ) {
            case 'active_plan':
                $user_id              = get_post_field( 'post_author', $listing_id );
                $selected_plan_id     = get_post_meta( $listing_id, '_fm_plans', true );
                $plans_by_admin       = get_post_meta( $listing_id, '_fm_plans_by_admin', true );
                $order_id             = get_post_meta( $listing_id, '_plan_order_id', true );
                $is_active            = subscribed_package_or_PPL_plans( $user_id, 'completed', $selected_plan_id, $listing_id );
                $plan_name            = ! empty( $selected_plan_id ) ? get_the_title( $selected_plan_id ) : __( 'No Plan!', 'directorist-woocommerce-pricing-plans' );
                $active               = '';
                $plan_type            = package_or_PPL( $selected_plan_id );

                if ( package_or_PPL( $selected_plan_id ) == 'package' ) {
                    if ( ! empty( $plans_by_admin ) || ( $is_active ) ) {
                        $plan_type = __( 'Package', 'directorist-woocommerce-pricing-plans' );
                        $active    = 'green';
                    }
                }
                if ( package_or_PPL( $selected_plan_id ) == 'pay_per_listng' ) {
                    $plan_type = __( 'Pay Per Listing', 'directorist-woocommerce-pricing-plans' );
                    if ( $is_active || ! empty( $plans_by_admin ) ) {
                        $active = 'green';
                    }
                }
                ?>
<span
    style='color: <?php echo ! empty( $active ) ? $active : '' ?>;'><?php echo ! empty( $plan_name ) ? $plan_name : ''; ?></span>
<span><?php echo ' - ' . $plan_type ?></span>
<?php
    //subscribed_package_or_PPL_plans($user_id, $order_status, $plan_id);
                break;
            }
        }

        public function dwpp_add_new_listing_column( $column_name ) {
            $column_name['active_plan'] = __( 'Plan Status', 'directorist-woocommerce-pricing-plans' );
            return $column_name;
        }

        private function save_listing_meta( $post_id ) {
            $p          = $_POST;
            $exp_dt     = ! empty( $p['exp_date'] ) ? atbdp_sanitize_array( $p['exp_date'] ) : [];
            $directory  = get_post_meta( $post_id, '_directory_type', true );
            $expiration = get_term_meta( $directory, 'default_expiration', true );

            if ( ! is_empty_v( $exp_dt ) && ! empty( $exp_dt['aa'] ) ) {
                $exp_dt = [
                    'year'  => (int) $exp_dt['aa'],
                    'month' => (int) $exp_dt['mm'],
                    'day'   => (int) $exp_dt['jj'],
                    'hour'  => (int) $exp_dt['hh'],
                    'min'   => (int) $exp_dt['mn'],
                ];
                $exp_dt = get_date_in_mysql_format( $exp_dt );
            } else {
                $exp_dt = calc_listing_expiry_date( '', $expiration ); // get the expiry date in mysql date format using the default expiration date.
            }
            update_post_meta( $post_id, '_expiry_date', $exp_dt );

        }

        /**
         * @since 1.2.0
         */
        public function dwpp_save_metabox( $post_id, $post ) {
            if ( ! isset( $_POST['post_type'] ) ) {
                return $post_id;
            }

            // If this is an autosave, our form has not been submitted, so we don't want to do anything
            if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
                return $post_id;
            }

            // Check the logged in user has permission to edit this post
            if ( ! current_user_can( 'edit_post', $post_id ) ) {
                return $post_id;
            }

            if ( ! is_admin() ) {
                return $post_id;
            }

            if ( 'at_biz_dir' === $_POST['post_type'] ) {

                $plan_id    = get_post_meta( $post_id, '_fm_plans', true );
                $admin_plan = isset( $_POST['admin_plan'] ) ? $_POST['admin_plan'] : '';
                $user_id    = isset( $_POST['post_author_override'] ) ? $_POST['post_author_override'] : '';
                // $sub_plan_id    = get_post_meta($post_id, '_fm_plans', true);
                $order_id = get_post_meta( $post_id, '_plan_order_id', true );

                update_post_meta( $post_id, '_fm_plans_by_admin', 1 );

                if ( 'null' === $admin_plan ) {
                    $this->save_listing_meta( $post_id );
                } else {
                    dwpp_need_listing_to_refresh( $user_id, $post_id, $order_id );
                }

                if ( 'pay_per_listng' === package_or_PPL( $plan_id ) ) {

                    if ( PPL_with_featured( $plan_id ) ) {
                        update_post_meta( $post_id, '_featured', '1' );
                    } else {
                        update_post_meta( $post_id, '_featured', '' );
                    }
                }
            }
        }

        /**
         * @since 1.2.0
         */

        public function dwpp_admin_metabox() {
            if ( ! get_directorist_option( 'woo_pricing_plans_enable', 1 ) ) {
                return;
            }
            // vail if the business hour is not enabled
            add_meta_box(
                '_listing_admin_plan',
                __( 'Belongs to Plan', 'directorist-woocommerce-pricing-plans' ),
                [$this, 'dwpp_admin_plan'],
                ATBDP_POST_TYPE,
                'side',
                'high'
            );
        }

        /**
         * @since 1.2.0
         */
        public function dwpp_admin_plan( $post ) {
            $current_val = get_post_meta( $post->ID, '_fm_plans', true );
            $user_id     = $post->post_author;
            global $product;
            $query_args = [
                'post_type'      => 'product',
                'posts_per_page' => -1,
                'tax_query'      => [
                    [
                        'taxonomy' => 'product_type',
                        'field'    => 'slug',
                        'terms'    => 'listing_pricing_plans',
                    ],
                ],
            ];

            $atbdp_query = new WP_Query( $query_args );

            if ( $atbdp_query->have_posts() ) {
                $plans = $atbdp_query->posts;?>

<div class="directorist-admin-form-plan-container">
    <div class="directorist-admin-form-plan-selection">
        <label for="select_plans"><?php echo __( 'Select Plan', 'directorist-woocommerce-pricing-plans' ); ?></label>
        <div class="directorist-admin-form-plan-selection__content">
            <select name="admin_plan">
                <option value="null"><?php echo __( '- Select -', 'directorist-woocommerce-pricing-plans' ); ?></option>
                <?php
    foreach ( $plans as $key => $value ) {
                    $class       = apply_filters( 'atbdp_admin_plan_select_option_class', 'listing_plan', $value->ID );
                    $active_plan = subscribed_package_or_PPL_plans( $user_id, 'completed', $value->ID );
                    $plan_metas  = get_post_meta( $value->ID );
                    $plan_type   = esc_attr( $plan_metas['plan_type'][0] );
                    $active      = '';
                    if ( 'package' === $plan_type && $active_plan ) {
                        $active = ' <span class="atbd_badge atbd_badge_open">' . __( ' - Active', 'directorist-woocommerce-pricing-plans' ) . '</span>';
                    }
                    ?>
                <option class="<?php echo $class . ' ' . $plan_type ?>" value="<?php echo $value->ID; ?>"
                    <?php echo selected( $value->ID, $current_val ); ?>><?php echo $value->post_title . $active; ?>
                </option>
                <?php
    }

                ?>
            </select>
            <span class="directorist_loader"></span>
        </div>
    </div>

    <div id="directorist-allowances"></div>
    <div id="dcl-claim-submit-notification"></div>
    <div id="dcl-claim-warning-notification"></div>
    <div class="directorist-admin-form-plan-action">
        <a target="_blank" href="<?php echo esc_url( ATBDP_Permalink::get_fee_plan_page_link() ); ?>"
            class="button atpp_plans"><?php echo __( 'Details', 'directorist-woocommerce-pricing-plans' ); ?></a>
        <a href="#" id="confirm_plan"
            class="button"><?php echo __( 'Save', 'directorist-woocommerce-pricing-plans' ); ?></a>
    </div>
</div>
<?php
    }
        }

        public function validate_submission( $info ) {

            $is_editing = ( ! empty( $info['edited_listing'] ) ) ? true : false;
            $error      = [];
            $data       = [];

            if ( ! $is_editing ) {

                $plan_id         = ! empty( $info['plan_id'] ) ? $info['plan_id'] : '';
                $listing_type    = ! empty( $info['listing_type'] ) ? $info['listing_type'] : '';
                $activated_order = ! empty( $info['order_id'] ) ? $info['order_id'] : '';
                $plan_type       = package_or_PPL( $plan_id );

                $plan_purchased = subscribed_package_or_PPL_plans( get_current_user_id(), 'completed', $plan_id );
                // Extract order ID from $plan_purchased which can be an array of order objects or a single order ID
                $order__id = '';
                if ( ! empty( $plan_purchased ) ) {
                    if ( is_array( $plan_purchased ) && ! empty( $plan_purchased[0] ) ) {
                        $order__id = is_object( $plan_purchased[0] ) ? $plan_purchased[0]->get_id() : $plan_purchased[0];
                    } elseif ( is_numeric( $plan_purchased ) ) {
                        $order__id = $plan_purchased;
                    }
                }
                $order_id       = ! empty( $activated_order ) ? $activated_order : $order__id;

                if ( $order_id ) {
                    $remaining = plans_remaining( $plan_id, $order_id );
                    $featured  = ! empty( $remaining['featured'] ) ? $remaining['featured'] : '';
                    $regular   = ! empty( $remaining['regular'] ) ? $remaining['regular'] : '';


                    // wp_send_json([
                    //     'error' => true,
                    //     'order_id' => $order_id
                    // ]);
                    $package_length = directorist_plan_lifetime( $plan_id );
                    $package_length = $package_length ? $package_length : '1';
                    // Current time
                    $start_date   = get_the_date( '', $order_id );
                    $expired_date = '';

                    if ( directorist_validate_date( $start_date ) ) {
                        $date = new DateTime( $start_date );
                        $date->add( new DateInterval( "P{$package_length}D" ) ); // set the interval in days
                        $expired_date = $date->format( 'Y-m-d H:i:s' );
                    }

                    $current_d      = current_time( 'mysql' );
                    $remaining_days = ( $expired_date > $current_d ) ? ( floor( strtotime( $expired_date ) / ( 60 * 60 * 24 ) ) - floor( strtotime( $current_d ) / ( 60 * 60 * 24 ) ) ) : 0; //calculate the number of days remaining in a plan

                    $regular_exit  = ( 'Unlimited' !== $regular ) && empty( $regular ) ? true : false;
                    $featured_exit = ( 'Unlimited' !== $featured ) && empty( $featured ) ? true : false;

                    if (  ( $regular_exit && $featured_exit ) || ( $remaining_days < 0 ) ) {
                        $msg = __( 'You have crossed the limit! Please try again', 'directorist-woocommerce-pricing-plans' );
                        if (  ( 'pay_per_listng' != $plan_type ) ) {
                            update_post_meta( $order_id, '_order_status', 'exit' );
                            $this->need_payment = true;
                        }
                    } else {
                        if (  ( 'regular' === $listing_type ) && ( 'package' === $plan_type ) ) {
                            if ( $regular_exit ) {
                                $msg = __( 'You have already crossed your limit for regular listing, please try again.', 'directorist-woocommerce-pricing-plans' );
                                array_push( $error, $msg );
                            }
                        }

                        if (  ( 'featured' === $listing_type ) && ( 'package' === $plan_type ) ) {
                            if ( $featured_exit ) {
                                $msg = __( 'You have already crossed your limit for featured listing, please try again', 'directorist-woocommerce-pricing-plans' );
                                array_push( $error, $msg );
                            }
                        }
                    }
                    // wp_send_json([
                    //     'boll' =>  $regular_exit && ( $featured_exit )  || ($remaining_days < 0),
                    //     'remaining' => $remaining,
                    //     'featured_exit' => $featured_exit,
                    //     'regular_exit' => $regular_exit,
                    //     'remaining_days' => $remaining_days,
                    //     'error' => true,
                    //     'need_payment' => $this->need_payment,
                    // ]);
                    if ( $error ) {
                        $data['error_msg'] = $error;
                        $data['error']     = true;
                        wp_send_json( $data );
                    }
                }

            }
        }

        public function atpp_process_the_selected_plans( $data ) {
            $info         = $_POST;
            $error        = [];
            $skip_payment = false;
            $listing_id   = ! empty( $data['id'] ) ? $data['id'] : '';
            
            if ( ! get_directorist_option( 'woo_pricing_plans_enable', 1 ) ) {
                return $data;
            }

            $is_editing = ( ! empty( $data['edited_listing'] ) ) ? true : false;

            $user_id         = get_current_user_id();
            $old_plan_id     = get_post_meta( $listing_id, '_fm_plans', true );
            $listing_type    = isset( $info['listing_type'] ) ? $info['listing_type'] : '';
            $plan_id         = isset( $info['plan_id'] ) ? $info['plan_id'] : $old_plan_id;
            $activated_order = ! empty( $info['order_id'] ) ? $info['order_id'] : '';
            $plan_type       = package_or_PPL( $plan_id );

            if ( $activated_order ) {
                $order_id = $activated_order;
            }else{
                $plan_purchased = subscribed_package_or_PPL_plans( $user_id, 'completed', $plan_id );

                // Extract order ID from $plan_purchased which can be an array of order objects or a single order ID
                $order__id = '';
                if ( ! empty( $plan_purchased ) ) {
                    if ( is_array( $plan_purchased ) && ! empty( $plan_purchased[0] ) ) {
                        $order__id = is_object( $plan_purchased[0] ) ? $plan_purchased[0]->get_id() : $plan_purchased[0];
                    } elseif ( is_numeric( $plan_purchased ) ) {
                        $order__id = $plan_purchased;
                    }
                }
                $order_id       = ! empty( $activated_order ) ? $activated_order : $order__id;
            }

            // Get fresh active orders (orders without listings) for pay-per-listing plans
            $fresh_active_order = directorist_active_orders_without_listing( directoirst_wc_plan_auto_renewal( $plan_id ) ? directoirst_wc_plan_auto_renewal( $plan_id ) : $plan_id );
            
            // For pay-per-listing plans, use the first fresh order (without listing) if available
            if ( 'pay_per_listng' === $plan_type && ! empty( $fresh_active_order ) && is_array( $fresh_active_order ) ) {
                $fresh_order_id = ! empty( $fresh_active_order[0] ) ? $fresh_active_order[0] : '';
                if ( $fresh_order_id ) {
                    $order_id = $fresh_order_id;
                }
            }

            $order = ! empty( $order_id ) ? wc_get_order( $order_id ) : '';

            $subscription = $order ? $order->get_meta('_linked_subscription') : get_post_meta( $order_id, '_linked_subscription', true );
            $subscription = $subscription ? $subscription : get_post_meta( $plan_id, '_linked_subscription', true );
            // $subscription = get_post_meta( $plan_id, '_linked_subscription', true );
            $listing__ids = $order ? $order->get_meta('_listing_id') : get_post_meta( $order_id, '_listing_id', true );

            $listing_ids     = ! empty( $listing__ids ) ? $listing__ids : [];
            $listing_ids     = is_array( $listing_ids ) ? $listing_ids : [ $listing_ids ];

            if( ! empty( $listing_id ) ){
                array_push( $listing_ids, $listing_id );
            }


            // wp_send_json([
            //     'error' => true,
            //     'boll' => directorist_direct_purchase() && ( 'package' !== $plan_type ) && $fresh_active_order,
            //     'direct_purchase' => directorist_direct_purchase(),
            //     'plan_type' => $plan_type,
            //     'fresh_order' => $fresh_active_order,
            //     'plan_id' => $plan_id,
            //     'listing_ids' => $listing_ids,
            //     'order' => $order,
            //     'man' => get_post_meta( $order_id ),
            // ]);


            if ( directorist_direct_purchase() && ( 'package' !== $plan_type ) && $fresh_active_order ) {
                $skip_payment = true;
                update_post_meta( $order_id, '_listing_id', $listing_ids );
                if( $order ) {
                    $order->update_meta_data( '_listing_id', $listing_ids );
                    $order->save();
                }
                update_post_meta( $listing_id, '_plan_order_id', $order_id );
                update_post_meta( $listing_id, '_listing_order_id', $order_id );
            }

            

            if (  ( 'package' === $plan_type ) && $order_id ) {
                update_post_meta( $order_id, '_listing_id', $listing_ids );
                if( $order ) {
                    $order->update_meta_data( '_listing_id', $listing_ids );
                    $order->save();
                }                
                update_post_meta( $listing_id, '_plan_order_id', $order_id );
                update_post_meta( $listing_id, '_listing_order_id', $order_id );
            }

            update_post_meta( $listing_id, '_fm_plans', $plan_id );
            
            if ( 'featured' == $listing_type ) {
                update_post_meta( $listing_id, '_featured', '1' );
            }

            if( $subscription && $plan_purchased && ! $this->need_payment ) {
                $listing_from_subscription = get_post_meta( $subscription, '_listing_id', true );
                $ids     = $listing_from_subscription ? $listing_from_subscription : [];
                $ids     = is_array( $ids ) ? $ids : [ $ids ];
                array_push( $ids, $listing_id );
                update_post_meta( $listing_id, '_plan_order_id', $order_id );
                update_post_meta( $subscription, '_listing_id', $ids );
                return $data;
            }

            // Ensure WooCommerce cart and session are initialized
            if ( function_exists( 'WC' ) && WC() ) {
                if ( is_null( WC()->cart ) && method_exists( WC(), 'initialize_cart' ) ) {
                    WC()->initialize_cart();
                }
                if ( is_null( WC()->session ) && method_exists( WC(), 'initialize_session' ) ) {
                    WC()->initialize_session();
                }
            }

            if ( WC() && WC()->cart && WC()->session ) {
                WC()->cart->empty_cart();
                WC()->session->set( 'cart', [] );
                WC()->cart->add_to_cart( directoirst_wc_plan_auto_renewal( $plan_id ) ? directoirst_wc_plan_auto_renewal( $plan_id ) : $plan_id );
            }
            
            $checkout_url = add_query_arg( 'atbdp_listing_id', $listing_id, wc_get_checkout_url() );

            if ( ! $order_id || $this->need_payment ) {
                $data['redirect_url'] = $checkout_url;
                $data['need_payment'] = true;

                wp_update_post( [
                    'ID'          => $listing_id,
                    'post_status' => 'pending',
                ] );
            }

            if ( $is_editing ) {
                return $data;
            }

            $package_length = directorist_plan_lifetime( $plan_id );
            $package_length = $package_length ? $package_length : '1';

            $current_d = current_time( 'mysql' );
            // Calculate new date
            $date = new DateTime( $current_d );
            $date->add( new DateInterval( "P{$package_length}D" ) ); // set the interval in days
            $expired_date      = $date->format( 'Y-m-d H:i:s' );
            $is_never_expaired = get_post_meta( $plan_id, 'fm_length_unl', true );
            if ( $is_never_expaired ) {
                array_push( $this->meta, ['_plan_order_id' => $order_id] );
                update_post_meta( $listing_id, '_never_expire', '1' );
            } else {
                update_post_meta( $listing_id, '_never_expire', 0 );
                update_post_meta( $listing_id, '_expiry_date', $expired_date );
            }

            update_post_meta( $listing_id, '_need_to_refresh', '1' );
            // for dev
            do_action( 'atbdp_plan_assigned', $listing_id );

            // update the claim status
            $fm_claim = get_post_meta( $plan_id, '_fm_claim', true );
            if ( ! empty( $fm_claim ) ) {
                update_post_meta( $listing_id, '_claimed_by_admin', 1 );
            }

            if ( 'pay_per_listng' === package_or_PPL( $plan_id ) ) {

                if ( PPL_with_featured( $plan_id ) ) {
                    update_post_meta( $listing_id, '_featured', '1' );
                }
                // wp_send_json([
                //     'order_id' => $order_id,
                //     'need_payment' => $this->need_payment,
                //     'plan' => $plan_purchased,
                //     'plan_id' => $plan_id,
                // ]);
                if ( ! $fresh_active_order ) {
                    $data['redirect_url'] = $checkout_url;
                    $data['need_payment'] = true;
                    return $data;
                }
            }

            if ( $error ) {
                $data['error_msg'] = $error;
                $data['error']     = true;
            }

            // $payment_status = Directorist\Helper::get_listing_payment_status( $listing_id );
            // $rejectable_payment_status = [ 'failed', 'cancelled', 'refunded' ];
            // $need_payment = ( empty( $payment_status ) || in_array( $payment_status, $rejectable_payment_status ) ) ? true : false;

            // $payment_status = swbd_get_listing_plan_order_status( $order_id );

            // $need_payment = in_array( $payment_status, ['pending', 'on-hold'] );
            // // $need_checkout = ! in_array( $payment_status, [ 'pending', 'processing', 'on-hold', 'completed' ] );

            // if ( $need_payment && ! $skip_payment ) {
            //     $data['redirect_url'] = $checkout_url;
            //     $data['need_payment'] = true;

            //     wp_update_post( [
            //         'ID'          => $listing_id,
            //         'post_status' => 'pending',
            //     ] );
            // }

            // wp_send_json([
            //     'error' => true,
            //     'subscription' => $subscription,
            //     'plan_purchased' => $plan_purchased,
            //     'plan_id' => $plan_id,
            //     'order_id' => $order_id,
            //     'payment' => $this->need_payment,
            //     'is_editing' => $is_editing,
            //     'data' => $data,
            // ]);

            // $order_id = get_post_meta( $listing_id, '_listing_order_id', true );
            // $payment_status = get_post_meta( $order_id );

            return $data;
        }
    }
endif;