<?php
defined('ABSPATH') || die('Direct access is not allowed.');
/**
 * @since 1.7.4
 * @package Directorist
 */
if (!class_exists('DWPP_WC_Controller')) :

    class DWPP_WC_Controller
    {
        public function __construct()
        {
            add_filter('product_type_selector', array($this, 'dwpp_register_product_type'));
            add_filter('woocommerce_product_class', array($this, 'dwpp_woocommerce_product_class'), 10, 2);
            add_action('woocommerce_product_options_general_product_data', array($this, 'dwpp_display_custom_fields'));
            add_action('woocommerce_process_product_meta', array($this, 'dwpp_woocommerce_process_product_meta'), 11, 2);
            add_filter('woocommerce_product_data_tabs', array($this, 'dwpp_woocommerce_product_data_tabs'), 2);
            add_filter('product_type_options', array($this, 'product_type_options') );
            add_action('woocommerce_product_data_panels', array($this, 'dwpp_app_configuration_panel'));
            // add_action('woocommerce_single_product_summary', array($this, 'dwpp_single_product_summary'), 60);
            add_filter('woocommerce_get_price_html', array($this, 'dwpp_change_product_price_display'));
            
            // Add checkout field to multiple hooks for Elementor Pro and Gutenberg compatibility
            add_action('woocommerce_after_checkout_billing_form', array($this, 'checkout_field'));
            add_action('woocommerce_checkout_after_customer_details', array($this, 'checkout_field'));
            add_action('woocommerce_checkout_before_order_review', array($this, 'checkout_field'));
            add_action('woocommerce_checkout_order_review', array($this, 'checkout_field'), 5);
            
            // add_action('template_redirect', array($this, 'debug'));
            add_action('woocommerce_init', array($this, 'custom_checkout_field'));
            add_filter('woocommerce_get_default_value_for_directorist/listing-id', array($this, 'custom_checkout_field_save'), 10, 3 );
            
            // Save checkout field during order processing
            add_action('woocommerce_checkout_create_order', array($this, 'save_checkout_field_to_order'), 10, 2);
            add_action('woocommerce_checkout_process', array($this, 'process_checkout_field'));

            add_action('woocommerce_order_status_completed', array($this, 'dwpp_order_status_completed'));
            add_action('woocommerce_order_status_processing', array($this, 'dwpp_order_status_completed'));
            add_action('woocommerce_order_status_changed', array($this, 'status_changed'), 10, 4);
        }


        public function custom_checkout_field_save( $value, $group, $wc_object ){

            // Get from URL parameter
            if ( isset( $_GET['atbdp_listing_id'] ) ) {
                return absint($_GET['atbdp_listing_id']);
            }
            
            // Get from POST
            if ( isset( $_POST['listing_id'] ) ) {
                return absint($_POST['listing_id']);
            }
            
            // Get from registered checkout field
            if ( isset( $_POST['directorist/listing-id'] ) ) {
                return absint($_POST['directorist/listing-id']);
            }
        
            return $value;
            
        }

        public function custom_checkout_field()

        {
        
            woocommerce_register_additional_checkout_field(
                array(
                    'id'            => 'directorist/listing-id',
                    'label'         => 'Listing ID',
                    'optionalLabel' => 'Listing ID',
                    'location'      => 'order',
                    'required'      => false,
                    'attributes'    => array(
                        'autocomplete'     => 'listing-id',
                        'aria-describedby' => 'some-element',
                        'aria-label'       => 'custom aria label',
                        'title'            => 'Title to show on hover',
                        'data-custom'      => 'custom data',
                    ),
                                           
                ),
            );
        
        }
    
        public function status_changed( $order_id, $old_status, $new_status, $order ) {

            foreach ( $order->get_items() as $key => $item ) {

                $product        = $item->get_data();
                $plan_id     = $product['product_id'];
                $product        = wc_get_product( $plan_id );

                // file_put_contents(dirname(__FILE__) . '/status-changed.json',json_encode( [
                //     'order_id' => $order_id,
                //     'old_status' => $old_status,
                //     'new_status' => $new_status,
                //     'item' => $item,
                //     'product' => $product,
                //     'order_data' => $order->get_data(),
                // ] ), FILE_APPEND);

                // break;

                if ( ( $product->product_type == 'listing_pricing_plans' ) || ( $product->product_type == 'subscription' ) ) {

                    if( directoirst_wc_plan_auto_renewal( $plan_id ) ) {
                        $plan_id = directoirst_wc_plan_auto_renewal( $plan_id );
                    }

                    // Try multiple sources for listing_id
                    $listing_id = '';
                    
                    // From POST
                    if (isset($_POST['listing_id'])) {
                        $listing_id = absint($_POST['listing_id']);
                    }
                    // From registered checkout field
                    elseif ($order->get_meta('_wc_other/directorist/listing-id')) {
                        $listing_id = absint($order->get_meta('_wc_other/directorist/listing-id'));
                    }
                    // From order meta
                    elseif ($order->get_meta('_listing_id')) {
                        $listing_id = $order->get_meta('_listing_id');
                    }
                    // From URL parameter
                    elseif (isset($_GET['atbdp_listing_id'])) {
                        $listing_id = absint($_GET['atbdp_listing_id']);
                    }

                    $order->add_meta_data( '_fm_plan_ordered', $plan_id );
                    if( $listing_id ) {
                        $order->add_meta_data( '_listing_id', $listing_id );
                    }
                    $order->add_meta_data( '_fm_plans', $plan_id );
                    $order->save();

                    // file_put_contents(dirname(__FILE__) . '/status-changed2.json',json_encode( [
                    //     'order_id' => $order_id,
                    //     'old_status' => $old_status,
                    //     'new_status' => $new_status,
                    //     'plan_id' => $plan_id,
                    //     'listing_id' => $listing_id,
                    //     'item' => $item,
                    //     'order' => $order->get_data(),
                    // ] ), FILE_APPEND);

                }
            }
        }

        public function debug() {
            // file_put_contents(dirname(__FILE__) . '/error_log.json',json_encode( [
            //     'order_id' => 342432,
            //     'order' => [],
            //     'items' => [],
            // ] ), FILE_APPEND);

            var_dump([
                'order_id' => 330,
                'order' => wc_get_order( 330 ),
                'post' => $_POST,
                'get' => $_GET,
            ]);
            die;
        }

        /**
         * Add a hidden field (listing_id) in the WooCommerce checkout page.
         * Compatible with both Gutenberg blocks and Elementor Pro checkout widget.
         *
         * @param array|object $checkout WooCommerce checkout page values or checkout object.
         * @since     1.0.0
         * @access    public
         *
         */
        public function checkout_field($checkout = null)
        {
            // Prevent duplicate output
            static $field_output = false;
            if ($field_output) {
                return;
            }
            
            // Get listing_id from URL parameter or checkout value
            $listing_id = '';
            if (isset($_GET['atbdp_listing_id'])) {
                $listing_id = absint($_GET['atbdp_listing_id']);
            } elseif (is_object($checkout) && method_exists($checkout, 'get_value')) {
                $listing_id = $checkout->get_value('listing_id');
            } elseif (isset($_POST['listing_id'])) {
                $listing_id = absint($_POST['listing_id']);
            }
            
            // Set field output flag
            $field_output = true;
            
            echo '<div id="directorist_pp" style="display:none;">';
        
            woocommerce_form_field('listing_id', array(
                'type'          => 'hidden',
                'id'            => 'listing_id',
                'value'         => $listing_id,
                'class'         => array('my-field-class form-row-wide'),
                'label'         => 'Listing ID',
                'required'      => true,
                'placeholder'   => '',
            ), $listing_id);
        
            echo '</div>';
            
            // Also add JavaScript to ensure field value is set for Elementor Pro
            if ($listing_id) {
                ?>
                <script type="text/javascript">
                (function($) {
                    $(document).ready(function() {
                        var listingId = <?php echo absint($listing_id); ?>;
                        if (listingId) {
                            $('#listing_id').val(listingId);
                            // Also set for registered checkout field if exists
                            $('input[name="directorist/listing-id"]').val(listingId);
                        }
                    });
                    // Also handle checkout updates
                    $(document.body).on('updated_checkout', function() {
                        var listingId = <?php echo absint($listing_id); ?>;
                        if (listingId) {
                            $('#listing_id').val(listingId);
                            $('input[name="directorist/listing-id"]').val(listingId);
                        }
                    });
                })(jQuery);
                </script>
                <?php
            }
        }
        
        /**
         * Process checkout field during checkout validation.
         *
         * @since     1.0.0
         * @access    public
         */
        public function process_checkout_field()
        {
            // Ensure listing_id is available in POST if it was in URL
            if (isset($_GET['atbdp_listing_id']) && !isset($_POST['listing_id'])) {
                $_POST['listing_id'] = absint($_GET['atbdp_listing_id']);
            }
        }
        
        /**
         * Save checkout field to order during order creation.
         *
         * @param WC_Order $order Order object.
         * @param array $data Checkout data.
         * @since     1.0.0
         * @access    public
         */
        public function save_checkout_field_to_order($order, $data)
        {
            $listing_id = '';
            
            // Get from POST first (most reliable)
            if (isset($_POST['listing_id'])) {
                $listing_id = absint($_POST['listing_id']);
            }
            // Get from registered checkout field in POST
            elseif (isset($_POST['directorist/listing-id'])) {
                $listing_id = absint($_POST['directorist/listing-id']);
            }
            // Get from checkout data array
            elseif (isset($data['directorist/listing-id'])) {
                $listing_id = absint($data['directorist/listing-id']);
            }
            // Get from URL parameter as fallback
            elseif (isset($_GET['atbdp_listing_id'])) {
                $listing_id = absint($_GET['atbdp_listing_id']);
            }
            // Get from order meta if already set (for registered checkout fields)
            elseif ($order->get_id()) {
                $registered_field = $order->get_meta('_wc_other/directorist/listing-id');
                if ($registered_field) {
                    $listing_id = absint($registered_field);
                }
            }
            
            if ($listing_id) {
                $order->add_meta_data('_listing_id', $listing_id);
                // Don't save here as WooCommerce will save the order after this hook
            }
        }

        public function dwpp_change_product_price_display($price)
        {
            global $product;
            if ($product instanceof WC_Product && $product->is_type('listing_pricing_plans')) {
                $plan_id        = get_the_ID();
                $plan_type      = get_post_meta( $plan_id, 'plan_type', true);
                $recurring      = get_post_meta( $plan_id, '_enable_subscription', true );
                $linked_subscription = get_post_meta( $plan_id, '_linked_subscription', true );
                
                if( $recurring && $linked_subscription ) {
                    $regular_price  = get_post_meta( $linked_subscription, '_subscription_price', true );
                    $sale_price     = get_post_meta( $linked_subscription, '_sale_price', true );
                    $price       = !empty( $sale_price ) ? esc_attr( $sale_price ) : esc_attr( $regular_price );
                }
               
                if ('package' === $plan_type) {
                    $price .= __('/per package', 'directorist-woocommerce-pricing-plans');
                    return $price;
                } else {
                    $price .= __('/per listing', 'directorist-woocommerce-pricing-plans');
                    return $price;
                }
            } else {
                return $price;
            }
        }

        public function dwpp_single_product_summary($product_id)
        {
            global $product;
            if ($product instanceof WC_Product && $product->is_type('listing_pricing_plans')) {

                $plan_id = get_the_ID();
                $plan_metas = get_post_meta($plan_id);
                $unl = __('Unlimited', 'directorist-woocommerce-pricing-plans');
                $fm_length = esc_attr($plan_metas['fm_length'][0]);
                $fm_length_unl = esc_attr($plan_metas['fm_length_unl'][0]);
                $num_regular = esc_attr($plan_metas['num_regular'][0]);
                $num_regular_unl = esc_attr($plan_metas['num_regular_unl'][0]);
                $num_featured = esc_attr($plan_metas['num_featured'][0]);
                $num_featured_unl = esc_attr($plan_metas['num_featured_unl'][0]);
                $price_range = esc_attr($plan_metas['price_range'][0]);
                $price_range_unl = esc_attr($plan_metas['price_range_unl'][0]);
                $num_image = esc_attr($plan_metas['num_image'][0]);
                $num_image_unl = esc_attr($plan_metas['num_image_unl'][0]);
                $num_gallery_image = !empty($plan_metas['num_gallery_image'][0]) ? esc_attr($plan_metas['num_gallery_image'][0]) : '';
                $num_gallery_image_unl = !empty($plan_metas['num_gallery_image_unl'][0]) ? esc_attr($plan_metas['num_gallery_image_unl'][0]) : '';
                $fm_tag_limit = esc_attr($plan_metas['fm_tag_limit'][0]);
                $fm_tag_limit_unl = esc_attr($plan_metas['fm_tag_limit_unl'][0]);
                $business_hrs = esc_attr($plan_metas['business_hrs'][0]);
                $l_video = esc_attr($plan_metas['l_video'][0]);
                $cf_owner = esc_attr($plan_metas['cf_owner'][0]);
                $fm_email = esc_attr($plan_metas['fm_email'][0]);
                $fm_phone = esc_attr($plan_metas['fm_phone'][0]);
                $fm_web_link = esc_attr($plan_metas['fm_web_link'][0]);
                $fm_social_network = esc_attr($plan_metas['fm_social_network'][0]);
                $fm_cs_review = esc_attr($plan_metas['fm_cs_review'][0]);
                $fm_listing_faq = esc_attr($plan_metas['fm_listing_faq'][0]);
                $fm_custom_field = esc_attr($plan_metas['fm_custom_field'][0]);
                $fm_claim = esc_attr($plan_metas['_fm_claim'][0]);
                $fm_allow_price_range = esc_attr($plan_metas['fm_allow_price_range'][0]);
?>
                <div class="atbd_woo_plans_product">
                    <div class="pricing pricing--1 <?php echo !empty($plan_metas['default_pln'][0]) ? 'atbd_pricing_special' : ''; ?>">
                        <?php echo !empty($plan_metas['default_pln'][0]) ? ' <span class="atbd_popular_badge">'. __( 'Recommended', 'directorist-woocommerce-pricing-plans' ) .'</span>' : ''; ?>

                        <div class="pricing__features">
                            <ul>
                                <li><span class="fa fa-<?php if (($fm_length > 0) || $fm_length_unl) {
                                                            echo 'check';
                                                        } else {
                                                            echo 'times';
                                                        } ?>"></span><?php echo $fm_length_unl ? '<span class="atbd_color-success">' . _e('No', 'directorist-woocommerce-pricing-plans') . '</span>' : $fm_length; ?><?php _e(' Days Limit', 'directorist-woocommerce-pricing-plans') ?>
                                </li>
                                <?php if (($plan_metas['plan_type'][0] == 'pay_per_listng') && empty($plan_metas['_dwpp_hide_listing_featured'][0])) { ?>
                                    <li>
                                        <span class="fa fa-<?php echo !empty($plan_metas['is_featured_listing'][0]) ? 'check' : 'times'; ?>"> </span><?php _e('Listing as featured', 'directorist-woocommerce-pricing-plans') ?>
                                    </li>
                                <?php }
                                if ($plan_metas['plan_type'][0] != 'pay_per_listng') { ?>
                                    <?php if (empty($plan_metas['_dwpp_hide_listings'][0])) { ?>
                                        <li><span class="fa fa-<?php if (($num_regular > 0) || $num_regular_unl) {
                                                                    echo 'check';
                                                                } else {
                                                                    echo 'times';
                                                                } ?>"></span><?php echo $num_regular_unl ? '<span class="atbd_color-success">' . $unl . '</span>' . __(' Regular Listings', 'directorist-woocommerce-pricing-plans') . '' : $num_regular . __(' Regular Listings', 'directorist-woocommerce-pricing-plans'); ?>
                                        </li>
                                    <?php }
                                    if (empty($plan_metas['_dwpp_hide_featured'][0])) { ?>
                                        <li><span class="fa fa-<?php if (($num_featured > 0) || $num_featured_unl) {
                                                                    echo 'check';
                                                                } else {
                                                                    echo 'times';
                                                                } ?>"></span><?php echo $num_featured_unl ? '<span class="atbd_color-success">' . $unl . '</span>' : $num_featured . __(' Featured Listings', 'directorist-woocommerce-pricing-plans'); ?>
                                        </li>
                                    <?php }
                                }
                                if (empty($plan_metas['_dwpp_hide_cl_owner'][0])) { ?>
                                    <li>
                                        <span class="fa fa-<?php echo !empty($cf_owner) ? 'check' : 'times'; ?>"> </span><?php _e('Contact Owner', 'directorist-woocommerce-pricing-plans') ?>
                                    </li>
                                <?php }
                                if (empty($plan_metas['_dwpp_hide_customer_review'][0])) { ?>
                                    <li>
                                        <span class="fa fa-<?php echo !empty($fm_cs_review) ? 'check' : 'times'; ?>"> </span><?php _e('Allow Customer Review', 'directorist-woocommerce-pricing-plans') ?>
                                    </li>
                                <?php }
                                if (empty($plan_metas['_dwpp_hide_category'][0])) {
                                    $is_cat = selected_plan_meta($plan_id, 'exclude_cat');
                                ?>
                                    <li><span class="fa fa-<?php if (empty($is_cat)) {
                                                                echo 'check';
                                                            } else {
                                                                echo 'times';
                                                            } ?>"> </span><?php _e('All Categories', 'directorist-woocommerce-pricing-plans') ?>
                                    </li>
                                <?php }
                                if (empty($plan_metas['_dwpp_hide_claim'][0])) { ?>
                                    <li>
                                        <span class="fa fa-<?php echo !empty($fm_claim) ? 'check' : 'times'; ?>"> </span><?php _e('Claim Badge Included', 'directorist-woocommerce-pricing-plans') ?>
                                    </li>
                                <?php } ?>
                                <?php
                                /*
                                 * @since 1.0.0
                                 * Fires in plan compare page
                                 * hook for future dev
                                 */
                                do_action('atfm_fee_plan_after_custom_field');
                                ?>

                            </ul>
                        </div>
                    </div>
                </div>
<?php
            }
        }

        /**
         * @since 1.1.9
         */

        public function dwpp_order_status_completed($order_id)
        {
            $order                = wc_get_order($order_id);
            $items                = $order->get_items();
            $listing_id           = $order->get_meta( '_listing_id', true );
            $directory_type_terms = get_the_terms( $listing_id, ATBDP_DIRECTORY_TYPE );
            $directory_type       = ( is_array( $directory_type_terms ) ) ? $directory_type_terms[0]->term_id : '';
            $new_l_status         = 'pending';

            update_post_meta( $listing_id, '_plan_order_id', $order_id );

            if ( $directory_type ) {
                $new_l_status = get_term_meta( $directory_type, 'new_listing_status', true );
            }

            foreach ($items as $key => $item) {
                $plan_id = $item['product_id'];
                $product = wc_get_product($plan_id);

                if ( $listing_id && ( $product->is_type('listing_pricing_plans') || $product->is_type('subscription') ) ) {
                    $user_id = get_current_user_id();
                
                    if ( ! empty( $listing_id ) ) {
                        if( is_array( $listing_id ) && count( $listing_id ) > 1 ){
                            foreach( $listing_id as $id ){
    
                                $directory_type = get_post_meta( $id, '_directory_type', true );
                                if ( $directory_type ) {
                                    $new_l_status = get_term_meta( $directory_type, 'new_listing_status', true );
                                }
    
                                dwpp_need_listing_to_refresh( $user_id, $id, $order_id );
                                wp_update_post(array(
                                    'ID'    =>  $id,
                                    'post_status'   =>  apply_filters( 'atpp_reviewed_listing_status_controller_argument', $new_l_status ),
                                ));
                            }
                        } else {
                            $directory_type = get_post_meta( $listing_id, '_directory_type', true );
                            if ( $directory_type ) {
                                $new_l_status = get_term_meta( $directory_type, 'new_listing_status', true );
                            }
                            dwpp_need_listing_to_refresh($user_id, $listing_id, $order_id);
                            wp_update_post(array(
                                'ID'    =>  $listing_id,
                                'post_status'   =>  apply_filters( 'atpp_reviewed_listing_status_controller_argument', $new_l_status ),
                            ));
                        }
                    }
                }
            }
        }

        public function product_type_options($options)
        {
            $options['virtual']['wrapper_class'] = 'show_if_simple show_if_listing_pricing_plans';
            return $options;
        }

        public function dwpp_woocommerce_product_data_tabs($tabs)
        {
            $tabs['attribute']['class'][] = 'hide_if_listing_pricing_plans';
            $tabs['shipping']['class'][] = 'hide_if_listing_pricing_plans';
            $tabs['linked_product']['class'][] = 'hide_if_listing_pricing_plans';
            $tabs['advanced']['class'][] = 'hide_if_listing_pricing_plans';
            
            // Add App Configuration tab for listing_pricing_plans product type
            $tabs['dwpp_app_configuration'] = array(
                'label'    => __( 'App Configuration', 'directorist-woocommerce-pricing-plans' ),
                'target'   => 'dwpp_app_configuration_product_data',
                'class'    => array( 'show_if_listing_pricing_plans' ),
                'priority' => 100,
            );
            
            return $tabs;
        }

        /**
         * Display App Configuration panel content.
         *
         * @since 1.0.0
         */
        public function dwpp_app_configuration_panel() {
            global $post;
            ?>
            <div id="dwpp_app_configuration_product_data" class="panel woocommerce_options_panel">
                <?php
                DWPP_Pricing_Plans()->load_template( 'admin-meta-app-configuration-fields', array( 'post' => $post ) );
                ?>
            </div>
            <?php
        }
        /**
         * Save WooCommerce meta data.
         *
         * @param int $post_id Post ID
         * @return    bool       true    If the save was successful or not.
         * @since      1.0.0
         * @access    public
         *
         */
        public function dwpp_woocommerce_process_product_meta($post_id, $post)
        {

            // echo '<pre>';
            // var_dump($_POST);
            // echo '</pre>';
            // die;
            // Directory type
            $assign_to_directory =  !empty( $_POST['assign_to_directory'] ) ? $_POST['assign_to_directory'] : default_directory_type();
            update_post_meta( $post_id, '_assign_to_directory', $assign_to_directory );
            

            //subscription
            
            $linked_subscription    = ! empty ( $_POST[ 'linked_subscription' ] ) ? sanitize_text_field( $_POST[ 'linked_subscription' ] ) : 0;
            $enable_subscription    = ! empty ( $_POST[ 'enable_subscription' ] ) ? 1 : 0;
            $hide_subscription      = ! empty ( $_POST[ 'hide_subscription' ] ) ? 1 : 0;
            update_post_meta($post_id, '_linked_subscription', $linked_subscription);
            update_post_meta($post_id, '_enable_subscription', $enable_subscription);
            update_post_meta($post_id, '_hide_subscription', $hide_subscription);

            if( ! empty ( $linked_subscription ) ) {
                update_post_meta( $linked_subscription, '_linked_pricing_plan', $post_id );
            }

            // Listing type
            $plan_type = isset($_POST['plan_type']) ? $_POST['plan_type'] : 'pay_per_listng';
            update_post_meta($post_id, 'plan_type', $plan_type);

            // Listing duration
            $listing_duration = isset($_POST['fm_length']) ? (int) $_POST['fm_length'] : 0;
            $never_expire = isset($_POST['fm_length_unl']) ? 1 : 0;
            update_post_meta($post_id, 'fm_length', $listing_duration);
            update_post_meta($post_id, 'fm_length_unl', $never_expire);

            // Listings limit
            $listings_limit = isset($_POST['num_regular']) ? (int) $_POST['num_regular'] : 0;
            $unl_listings = isset($_POST['num_regular_unl']) ? 1 : 0;
            $hide_listings = isset($_POST['_dwpp_hide_listings']) ? 1 : 0;
            update_post_meta($post_id, '_dwpp_hide_listings', $hide_listings);
            update_post_meta($post_id, 'num_regular', $listings_limit);
            update_post_meta($post_id, 'num_regular_unl', $unl_listings);

            //Featured Listings limit
            $featured_limit = isset($_POST['num_featured']) ? (int) $_POST['num_featured'] : 0;
            $unl_featured = isset($_POST['num_featured_unl']) ? 1 : 0;
            $hide_featured = isset($_POST['_dwpp_hide_featured']) ? 1 : 0;
            update_post_meta($post_id, 'num_featured', $featured_limit);
            update_post_meta($post_id, 'num_featured_unl', $unl_featured);
            update_post_meta($post_id, '_dwpp_hide_featured', $hide_featured);

            // Featured
            $featured = isset($_POST['is_featured_listing']) ? 1 : 0;
            $hide_featured = isset($_POST['_dwpp_hide_listing_featured']) ? 1 : 0;
            update_post_meta($post_id, '_dwpp_hide_listing_featured', $hide_featured);
            update_post_meta($post_id, 'is_featured_listing', $featured);

            // Contact listing owner
            $cl_owner = isset($_POST['cf_owner']) ? 1 : 0;
            $hide_cl_owner = isset($_POST['_dwpp_hide_cl_owner']) ? 1 : 0;
            update_post_meta($post_id, 'cf_owner', $cl_owner);
            update_post_meta($post_id, '_dwpp_hide_cl_owner', $hide_cl_owner);

            // Review
            $customer_review = isset($_POST['fm_cs_review']) ? 1 : 0;
            $hide_customer_review = isset($_POST['hide_customer_review']) ? 1 : 0;
            update_post_meta($post_id, 'fm_cs_review', $customer_review);
            update_post_meta($post_id, '_dwpp_hide_customer_review', $hide_customer_review);

            // Claim Badge
            $claim = isset($_POST['fm_claim']) ? 1 : 0;
            $hide_claim = isset($_POST['dwpp_hide_claim']) ? 1 : 0;
            update_post_meta($post_id, '_fm_claim', $claim);
            update_post_meta($post_id, '_dwpp_hide_claim', $hide_claim);


            // Categories
            $exclude_categories = isset($_POST['exclude_categories'])?sanitize_text_field($_POST['exclude_categories']):'';
            $categories = ($_POST['exclude_cat'] && $exclude_categories ) ? array_map('esc_attr', $_POST['exclude_cat']) : array();
            update_post_meta($post_id, 'exclude_cat', $categories);
            $hide_category = isset($_POST['dwpp_hide_category']) ? 1 : 0;
            update_post_meta($post_id, '_dwpp_hide_category', $hide_category);

            //Recomannand this plan
            $default_pln = isset($_POST['default_pln']) ? 1 : 0;
            update_post_meta($post_id, 'default_pln', $default_pln);

            //Hide this plan
            $hide_from_plans = isset($_POST['hide_from_plans']) ? 1 : 0;
            update_post_meta($post_id, '_hide_from_plans', $hide_from_plans);

            // Booking
            $booking = isset($_POST['fm_booking']) ? 1 : 0;
            $hide_booking = isset($_POST['dwpp_hide_booking']) ? 1 : 0;
            update_post_meta($post_id, '_fm_booking', $booking);
            update_post_meta($post_id, '_dwpp_hide_booking', $hide_booking);

            // Live Chat
            $live_chat = isset($_POST['fm_live_chat']) ? 1 : 0;
            $hide_live_chat = isset($_POST['dwpp_hide_live_chat']) ? 1 : 0;
            update_post_meta($post_id, '_fm_live_chat', $live_chat);
            update_post_meta($post_id, '_dwpp_hide_live_chat', $hide_live_chat);

            // Mark as Sold
            $mark_as_sold = isset($_POST['fm_mark_as_sold']) ? 1 : 0;
            $hide_mark_as_sold = isset($_POST['dwpp_hide_mark_as_sold']) ? 1 : 0;
            update_post_meta($post_id, '_fm_mark_as_sold', $mark_as_sold);
            update_post_meta($post_id, '_dwpp_hide_mark_as_sold', $hide_mark_as_sold);

            // Save App Configuration Meta Data
            $this->save_app_configurations_meta( $post_id );

            // Form fields
            if( !empty( $_POST['form_fields'] ) ) {
                foreach( $_POST['form_fields'] as $key => $value ) {
                    update_post_meta( $post_id, '_' . $key, $value );
                }
            }
           
        }

        /**
         * Save App Configuration meta data.
         *
         * @param int $post_id Post ID.
         * @since 1.0.0
         */
        public function save_app_configurations_meta( $post_id ) {
            if ( ! empty( $_POST['_dpp_playstore_product_id'] ) ) {
                update_post_meta( $post_id, '_dpp_playstore_product_id', sanitize_text_field( $_POST['_dpp_playstore_product_id'] ) );
            } else {
                delete_post_meta( $post_id, '_dpp_playstore_product_id' );
            }

            if ( ! empty( $_POST['_dpp_playstore_product_price'] ) ) {
                update_post_meta( $post_id, '_dpp_playstore_product_price', sanitize_text_field( $_POST['_dpp_playstore_product_price'] ) );
            } else {
                delete_post_meta( $post_id, '_dpp_playstore_product_price' );
            }

            if ( ! empty( $_POST['_dpp_appstore_product_id'] ) ) {
                update_post_meta( $post_id, '_dpp_appstore_product_id', sanitize_text_field( $_POST['_dpp_appstore_product_id'] ) );
            } else {
                delete_post_meta( $post_id, '_dpp_appstore_product_id' );
            }

            if ( ! empty( $_POST['_dpp_appstore_product_price'] ) ) {
                update_post_meta( $post_id, '_dpp_appstore_product_price', sanitize_text_field( $_POST['_dpp_appstore_product_price'] ) );
            } else {
                delete_post_meta( $post_id, '_dpp_appstore_product_price' );
            }
        }

        public function directory_types() {
            $listing_types = get_terms([
                'taxonomy'   => 'atbdp_listing_types',
                'hide_empty' => false,
                'orderby'    => 'date',
                'order'      => 'DSCE',
              ]);
              return $listing_types;
        }

        /**
         * Display custom woocommerce fields.
         *
         * @since     1.0.0
         * @access    public
         */
        public function dwpp_display_custom_fields()
        {
            global $post;
            $fields_info['post_meta']      = get_post_meta($post->ID);
            $fields_info['post']            = $post;
            // Categories
            $fields_info['dwpp_categories'] = get_terms(ATBDP_CATEGORY, array('hide_empty' => 0, 'parent' => 0));
            $fields_info['current_val']     = !empty(get_post_meta($post->ID, 'exclude_cat', true)) ? get_post_meta($post->ID, 'exclude_cat', true) : array();
            // Directory type
            $listing_types = $this->directory_types();
            $multi_directory = get_directorist_option( 'enable_multi_directory', false );
            $default     	 = default_directory_type();
            $current_type    =  get_post_meta( $post->ID, '_assign_to_directory', true );
            $value 			 = $current_type ? $current_type : $default;  
            if( count( $listing_types ) > 1 ) {
                $fields_info['directory_types'] = $listing_types;
                $fields_info['value']           = $value;
            }
            $data = [
                'post'           => $post,
                'default_type'   => !$multi_directory ? $default : $value,
                'post_meta'      => get_post_meta( $post->ID ),
             ];

             //wc subscription

             if( class_exists( 'WC_Subscriptions' ) ) {
                $wc_sub = new WP_Query( [
                    'post_type'      => 'product',
                    'posts_per_page' => -1,
                    'post_status'    => 'publish',
                    'fields'         => 'ids',
                    'tax_query'      => [
                        [
                            'taxonomy' => 'product_type',
                            'field'    => 'name',
                            'terms'    => 'subscription',
                        ]
                    ] 
                 ]
                );
                if( $wc_sub->have_posts() ) {
                    $fields_info['subscription_products'] = $wc_sub->posts;
                }
             }

            DWPP_Pricing_Plans()->load_template('woo-custom-fields', $fields_info);

            ?>
            <div class="directorist-plan-dynamic-field">
                <?php $this::dynamic_plan_fields( $data ); ?>
            </div>
            <?php
        }

        public function dwpp_woocommerce_product_class($classname, $product_type)
        {
            if ($product_type == 'listing_pricing_plans') { // notice the checking here.
                $classname = 'DWPP_Product_Listings_Package';
            }
            return $classname;
        }

        public static function dynamic_plan_fields( $data ) {
            DWPP_Pricing_Plans()->load_template('admin-meta-form-fields', $data );
        }

        /**
         * @since 1.0.0
         * @access  public
         * register woo product type
         */
        public function dwpp_register_product_type($types)
        {
            $types['listing_pricing_plans'] = __('Listing Pricing Plan', 'directorist-woocommerce-pricing-plans');
            return $types;
        }
    }
endif;
