<?php
defined('ABSPATH') || die('Direct access is not allowed.');
/**
 * @since 1.7.4
 * @package Directorist
 */
if (!class_exists('DWPP_Init')) :

    class DWPP_Init
    {
        public function __construct()
        {
            if (get_option('atbdp_plan_page_create') < 1) {
                add_action('wp_loaded', array($this, 'add_custom_page'));
            }
            add_action('plugins_loaded', array($this, 'load_textdomain'));
            add_action( 'before_woocommerce_init', [ $this, 'declare_woocommerce_feature_compatibility' ] );
        }

       public function declare_woocommerce_feature_compatibility() {
           if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
               \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', DWPP_FILE, true );
               \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'cart_checkout_blocks', DWPP_FILE, false );
           }
       }

        public function add_custom_page()
        {
            $create_permission = apply_filters('atbdp_create_required_pages', true);
            if ($create_permission) {
                dwpp_create_required_pages();
            }
        }

        /**
         * It register the text domain to the WordPress
         */
        public function load_textdomain()
        {
            // Determine the current locale
            $locale = determine_locale();
            // Allow filters to modify the locale
            $locale = apply_filters( 'plugin_locale', $locale, 'directorist-woocommerce-pricing-plans' );
            load_textdomain( 'directorist-woocommerce-pricing-plans', WP_LANG_DIR . '/plugins/directorist-woocommerce-pricing-plans-' . $locale . '.mo' );
            load_plugin_textdomain('directorist-woocommerce-pricing-plans', false, DWPP_LANG_DIR);
        }
    }
endif;
