/*-------------------------------------
Template name:  	dLawyers
Version:        	1.0
Author Name:        wpWax
---------------------------------------
JS INDEX
=======================================

#. Preloadeer
#. Swiper Slider
#. Counter Up
#. Range Slider
#. Contact Button
#. Sidebar Collapse
#. Search Categories
#. Search Home
#. Mobile Menu
#. Search Field Action
#. Tooltip
#. Accordion
#. Rating
#. Free Consultation

---------------------------------------*/

"use strict";

(function ($) {

    var theme = {

        /* Preloader  */
        preloader: function () {
            if ($('#theme-preloader') !== null) {
                $('#theme-preloader').fadeOut('slow', function () {
                    $(this).remove();
                });
            }

        },

        /* Search Popup */
        searchPopup: function () {
            const searchTrigger = document.querySelector('.theme-header-action__search--trigger');
            const seachPopup = document.querySelector('#theme-search-popup');
            const btnClose = document.querySelector('.theme-popup-close');
            const shade = document.querySelector('.theme-shade');

            function triggerSearchPopup(e) {
                e.preventDefault();
                seachPopup.classList.add("theme-popup-open");
                shade.classList.add("theme-show");
            }

            function closeSearchPopup(e) {
                e.preventDefault();
                seachPopup.classList.remove("theme-popup-open");
                shade.classList.remove("theme-show");
            }
            if (searchTrigger) {
                searchTrigger.addEventListener('click', triggerSearchPopup);
                btnClose.addEventListener('click', closeSearchPopup);
                shade.addEventListener('click', closeSearchPopup);
            }

            $(window).scroll(function () {
                if ($(window).scrollTop() >= 110) {
                    $('body').addClass('menu-area-scroll');

                } else {
                    $('body').removeClass('menu-area-scroll');
                }
            });

            if ('.theme-search-popup') {
                $('body').addClass('menu-area-scroll');

            } else {
                $('body').removeClass('menu-area-scroll');
            }
        },

        /* Swiper Slider */
        swiperSlider: function () {

            /* Check Slider Data */
            let checkData = function (data, value) {
                return typeof data === 'undefined' ? value : data;
            };

            /* Swiper Slider */
            let swiperCarousel = document.querySelectorAll('.theme-swiper');
            let swiperCarouselNested = document.querySelectorAll('.theme-swiper-nested');
            swiperCarousel.forEach(function (el, i) {
                let hasPagination = false;
                let hasNav = false;
                const alllistingSlider = el.closest('.theme-swiper-slider');
                el.classList.add(`theme-swiper-${i}`);

                if (alllistingSlider) {
                    alllistingSlider.querySelector('.theme-swiper-slider__top').childNodes.forEach(elm => {
                        if (elm.className === "theme-swiper-button-nav-wrap") {
                            hasNav = true;
                        }
                    });
                } else if (el.querySelector('.theme-swiper-button-nav-wrap')) {
                    hasNav = true;
                }

                let navBtnPrev = el.querySelectorAll('.theme-swiper-button-prev');
                let navBtnNext = el.querySelectorAll('.theme-swiper-button-next');
                if (alllistingSlider) {
                    navBtnPrev = alllistingSlider.querySelectorAll('.theme-swiper-button-prev');
                    navBtnNext = alllistingSlider.querySelectorAll('.theme-swiper-button-next');
                }

                el.childNodes.forEach(elc => {
                    if (elc.className === "theme-swiper-pagination") {
                        hasPagination = true;
                    }
                    if (elc.className === "theme-swiper-navigation") {

                        hasNav = true;
                    }
                });

                const paginationElement = document.querySelectorAll(".theme-swiper-pagination");
                hasNav && navBtnPrev.forEach((el) => {
                    el.classList.add(`theme-swiper-button-prev-${i}`);
                });
                hasNav && navBtnNext.forEach((el) => {
                    el.classList.add(`theme-swiper-button-next-${i}`);
                });

                hasPagination && paginationElement.forEach((el) => el.classList.add(`theme-swiper-pagination-${i}`));
                let swiper1 = new Swiper(`.theme-swiper-${i}`, {
                    slidesPerView: parseInt(checkData(el.dataset.swItems, 4)),
                    spaceBetween: parseInt(checkData(el.dataset.swMargin, 30)),
                    loop: checkData(el.dataset.swLoop, true),
                    slidesPerGroup: parseInt(checkData(el.dataset.swPerslide, 2)),
                    speed: parseInt(checkData(el.dataset.swSpeed, 3000)),
                    autoplay: checkData(el.dataset.swAutoplay, {}),
                    freeMode: checkData(el.dataset.swFreemode, false),
                    watchSlidesProgress: checkData(el.dataset.swWatchprogress, false),
                    slideToClickedSlide: checkData(el.dataset.swslidetoclickedside, false),
                    navigation: {
                        nextEl: `.theme-swiper-button-next-${i}`,
                        prevEl: `.theme-swiper-button-prev-${i}`,
                    },
                    pagination: {
                        el: `.theme-swiper-pagination-${i}`,
                        type: 'bullets',
                        clickable: true,
                    },
                    breakpoints: checkData(el.dataset.swResponsive ? JSON.parse(el.dataset.swResponsive) : undefined, {})
                });

                var swiper2 = new Swiper(".product-gallery-main", {
                    spaceBetween: 10,
                    loop: true,
                    thumbs: {
                        swiper: swiper1,
                    },
                    pagination: {
                        el: ".swiper-pagination",
                        type: "fraction",
                    },
                });
            });

            swiperCarouselNested.forEach(function (el, i) {

                let navBtnPrevNested = document.querySelectorAll('.theme-swiper-button-prev-nested');
                let navBtnNextNested = document.querySelectorAll('.theme-swiper-button-next-nested');

                navBtnPrevNested.forEach((el, i) => {
                    el.classList.add(`theme-swiper-button-prev-nested-${i}`);
                });
                navBtnNextNested.forEach((el, i) => {
                    el.classList.add(`theme-swiper-button-next-nested-${i}`);
                });
                el.classList.add(`theme-swiper-nested-${i}`);
                let swiper = new Swiper(`.theme-swiper-nested-${i}`, {
                    slidesPerView: checkData(parseInt(el.dataset.swItems), 4),
                    spaceBetween: checkData(parseInt(el.dataset.swMargin), 30),
                    loop: checkData(el.dataset.swLoop, true),
                    slidesPerGroup: checkData(parseInt(el.dataset.swPerslide), 1),
                    speed: checkData(parseInt(el.dataset.swSpeed), 3000),
                    autoplay: checkData(el.dataset.swAutoplay, {}),
                    observer: true,
                    observeParents: true,
                    navigation: {
                        nextEl: `.theme-swiper-button-next-nested`,
                        prevEl: `.theme-swiper-button-prev-nested`,
                    },
                    pagination: {
                        el: `.theme-swiper-pagination-nested`,
                        type: 'bullets',
                        clickable: true,
                    },
                    breakpoints: checkData(el.dataset.swResponsive ? JSON.parse(el.dataset.swResponsive) : undefined, {})
                });
            });
        },

        /* Counter up */
        counterUpPlugin: function () {
            if ($('.theme-counter__counter') !== null) {
                $(".theme-counter__counter").each(function () {
                    var options = $(this).data('options');
                    $(this).counterUp(options);
                });
            }
        },

        /* Range Slider  */
        sliderRange: function () {
            let slider_ranges = document.querySelector('.slider-range');
            if (slider_ranges) {
                var slider_range = $(".slider-range");
                var priceRangeMin = Number($('.pricing-range__values').attr('data-min-price'));
                var priceRangeMax = Number($('.pricing-range__values').attr('data-max-price'));
                var priceCurrency = $('.pricing-range__values').attr('data-currency-symbol');

                slider_range.each(function () {
                    $(this).slider({
                        range: true,
                        min: priceRangeMin === "" ? 0 : priceRangeMin,
                        max: priceRangeMax,
                        values: [priceRangeMin, priceRangeMax],
                        slide: function (event, ui) {
                            $(".amount").text(priceCurrency + ui.values[0] + " - " + priceCurrency + ui.values[1]);
                            $(".price-range__input-values__min").val(ui.values[0]);
                            $(".price-range__input-values__max").val(ui.values[1]);
                        }
                    });
                });

                $(".amount").text(priceCurrency + slider_range.slider("values", 0) + " - " + priceCurrency + slider_range.slider("values", 1));
                $(".price-range__input-values__min").val(slider_range.slider("values", 0));
                $(".price-range__input-values__max").val(slider_range.slider("values", 1));

                var reset_slider = function (slider_selector) {

                    $(slider_selector).each(function () {
                        var options = $(this).slider("option");
                        $(this).slider("values", [priceRangeMin, priceRangeMax]);
                        $(this).next().find('.theme-min-amount').html(`$${priceRangeMin}`);
                        $(this).next().find('.theme-max-amount').html(`$${priceRangeMax}`);
                    });
                };

                $(".directorist-btn-reset-js").on("click", () => {
                    reset_slider(".slider-range");
                });
            }
        },

        /* Search Dropdown */
        searchDropDown: function () {
            
            $("body").on("click",".directorist-filter-btn", function () {
                $(this).closest(".directorist-filter-btn").toggleClass("active");
            });

            $("body").on("click",".theme-search-dropdown .theme-search-dropdown__label", function () {
                $(this).closest(".theme-search-dropdown").toggleClass("active");
            });

            $(".sticky-top").closest("body").addClass("sticky-top-enable");

            $('body').on('click', function (e) {
                if (!$(e.target).closest('.theme-search-dropdown').length) {
                    $(".theme-search-dropdown").removeClass("active");
                }
            });
            if($('.elementor-widget-wpwax-search-listing').length !== 0){
                const filterBtn = document.querySelector('.directorist-filter-btn');
                const searchBtn = document.querySelector('.directorist-btn-search');

                if ( filterBtn !== null ) {
                    if(filterBtn.textContent.trim() == '' || searchBtn.textContent.trim() == ''){
                        document.querySelector('.directorist-filter-btn').closest('.directorist-search-form-action').classList.add('directorist-search-form-action-only-icon');
                    }
                }
            }
            var authorDrop = ".theme-header-action__author-info"
            $("body").on("click",authorDrop, function () {
                $(this).closest(authorDrop).toggleClass("active");
            });
    
            $('body').on('click', function (e) {
                if (!$(e.target).closest(authorDrop).length) {
                    $(authorDrop).removeClass("active");
                }
            });

        },

        /* Contact Button  */
        contactButton: function () {
            if ($('.dlawyers-grid-cont-btn') !== null) {
                $('.dlawyers-grid-cont-btn').on('click', function () {
                    const listingID = $(this).attr('data-listing_id');
                    const listing_email = $(this).attr('data-listing_email');
                    if (listingID || listing_email) {
                        $('[name=dlawyers-post-id]').val(listingID);
                        $('#atbdp-listing-email').val(listing_email);
                    }
                });
            }

            if ($('#dlawyers-contact-owner-form') !== null) {
                $('body').on('submit', '#dlawyers-contact-owner-form', function (e) {
                    e.preventDefault();

                    $('#directorist-contact-message-display').append('<div class="atbdp-spinner"></div>');

                    // Post via AJAX
                    const data = {
                        action: 'atbdp_public_send_contact_email',
                        'atbdp-post-id': $('#dlawyers-post-id').val(),
                        'atbdp-contact-name': $('#atbdp-contact-name').val(),
                        'atbdp-contact-email': $('#atbdp-contact-email').val(),
                        'atbdp-listing-email': $('#atbdp-listing-email').val(),
                        'atbdp-contact-message': $('#atbdp-contact-message').val(),
                        directorist_nonce: directorist.directorist_nonce,
                    };

                    $.post(
                        dlawyers_localize_data.ajaxurl,
                        data,
                        function (response) {
                            if (response.error == 1) {
                                $('#directorist-contact-message-display')
                                    .addClass('text-danger')
                                    .html(response.message);
                            } else {
                                $('#atbdp-contact-message').val('');
                                $('#directorist-contact-message-display')
                                    .addClass('text-success')
                                    .html(response.message);
                            }
                        },
                        'json'
                    );
                });
            }

        },
        loginAlert:function (){
            function showMessage() {
                const themeLoginModal = document.getElementById('theme-login-modal');
                if (themeLoginModal) {
                    const directoristAlertElement = themeLoginModal.querySelector('.directorist-alert');
                    if (directoristAlertElement) {
                        $("#theme-login-modal").modal('show');
                    }
                }
            }
            setTimeout(showMessage, 500);
        },

        /* Sidebar Collapse  */
        sidebarCollapse: function () {

            $('.directorist-search-category select').select2({
                placeholder: directorist.i18n_text.category_selection,
                allowClear: true,
                templateResult: function (data) {
                    // We only really care if there is an element to pull classes from
                    if (!data.element) {
                        return data.text;
                    }

                    var $element = $(data.element);

                    var $wrapper = $('<span></span>');
                    $wrapper.addClass($element[0].className);

                    $wrapper.text(data.text);

                    return $wrapper;
                },
            });

            var myVariable = ".direcorist-search-field-review .filter-checklist__label,.direcorist-search-field-dlawyers_age label:first-child,.direcorist-search-field-tag label:first-child,.direcorist-search-field-radio label:first-child,.direcorist-search-field-dlawyers_gender label:first-child";
            if ($(myVariable !== null) && $(".sidebar-icon").length < 1 ) {
                $(myVariable).append("<span class='sidebar-icon'></span>");
                const toggles = document.querySelectorAll(myVariable);
                toggles.forEach((toggle) => {
                    toggle.addEventListener("click", () => {
                        toggle.parentNode.classList.toggle("active");
                    });
                    toggle.parentNode.classList.add("active");
                });
            }
        },

        /* Responsive Menu Trigger */
        responsiveMenuTrigger: function () {

            const menuArea = document.querySelector('.theme-header-area');
            const navCollapse = dlawyers_localize_data.resmenuWidth;
            const windowWidth = window.innerWidth;

            if (navCollapse >= windowWidth) {
                document.querySelector('html').classList.add('trigger-res-nav');
                menuArea && menuArea.classList.add('theme-responsive-menu');

            } else {
                document.querySelector('html').classList.remove('trigger-res-nav');
                menuArea && menuArea.classList.remove('theme-responsive-menu');
            }

        },

        /* Search Categories */
        searchCategories: function () {
            $('#search-icon').on("click", function (event) {
                event.preventDefault();
                $("#search-menu").addClass("open");
                $('#search-menu > form > input').focus()
            });
            $("#search-menu button.close,#search-menu").on("click keyup", function (event) {
                if (event.target == this || event.target.className == "close" || event.keyCode == 27) {
                    $(".search-menu").removeClass("open")
                }
            });

        },

        /* Search Home  */
        searchHome: function () {
            $('.directorist-search-form-top label:contains("Gender")').parent().addClass('directorist-search-field--gender');
            $('.directorist-search-form .directorist-search-tags').closest('.directorist-search-field').addClass('directorist-search-tags-wrapper');
        },

        /* Mobile Menu  */
        mobileMenu: function (dropDownTrigger, dropDown) {

            $(document).ready(function () {
                // Hide submenus of menu items on page load
                $('.trigger-res-nav .menu-item-has-children .sub-menu').hide();
            });
        
            // Create the toggle icon element
            var toggleIcon = document.createElement('span');
            toggleIcon.classList.add('toggle-icon'); // Add any desired class for styling
        
            // Append the toggle icon element to the <a> element
            var linkElement = document.querySelectorAll('.menu-item-has-children'); // Replace with your appropriate selector
            linkElement.forEach(function (link) {
                link.appendChild(toggleIcon.cloneNode(true));
            });
        
            $('body').on('click', '.theme-responsive-menu .toggle-icon', function (e) {
                if ($(this).parent().hasClass('menu-item-has-children')) {
                    e.preventDefault();
                }
                if ($(this).closest('.trigger-res-nav').length > 0) {
                    var $parentMenuItem = $(this).parent();
                    var $submenu = $(this).siblings(dropDown);
        
                    if ($parentMenuItem.hasClass('theme-submenu-open')) {
                        // Submenu is already open, so collapse it
                        $submenu.slideUp();
                        $parentMenuItem.removeClass('theme-submenu-open');
                    } else {
                        // Submenu is closed, so open it and close other open submenus
                        $parentMenuItem.siblings('.theme-submenu-open').removeClass('theme-submenu-open')
                            .children(dropDown).slideUp();
                        $parentMenuItem.addClass('theme-submenu-open');
                        $submenu.slideDown();
                    }
                }
            });
        
            $('.menu-area .mainmenu__menu ul li.multi-column-menu > ul.sub-menu > li ul li.current-menu-item').closest('.menu-area .mainmenu__menu ul li.multi-column-menu').addClass('current-menu-parent');

            $('.admin-bar .search-menu').each(function () {
                $(this).css({
                    'top': $('#wpadminbar').outerHeight() + 'px'
                });
            });
            $('.theme-dir-dashboard .content-area').each(function () {
                $(this).css({
                    'margin-top': $('.theme-header-area').outerHeight() + 'px'
                });
            });

            if ($('#theme-nav-close') !== null) {
                $('.theme-nav-close').on('click', function () {
                    $('.trigger-res-nav #dlawyers-navbar-collapse').removeClass('show');
                });
            }

            $(window).on("resize, load", function (event) {
                $(window).scroll(function (e) {
                    e.preventDefault();
                    var scroll = $(window).scrollTop();
                    if ($(window).width() < 601 && scroll > 46) {
                        $(".menu-area.sticky-top,.menu-area.fixed-top").addClass("admin-top-remove");
                    } else {
                        $(".menu-area.sticky-top,.menu-area.fixed-top").removeClass("admin-top-remove");
                    }
                });
            });


        },

        /* Search Field Action  */
        searchFieldsAction: function () {

            $(document).on("click", function () {
                $(".search_module,.navbar-nav").removeClass("active");
            });
            $('.directorist-search-form .directorist-price-ranges').closest('.directorist-search-field').addClass('directorist-price-ranges-wrapper');
            $('.directorist-pricing.directorist-pricing--1 .directorist-pricing__features ul li span.fa-times').closest('.directorist-pricing.directorist-pricing--1 .directorist-pricing__features ul li').addClass('inactive');
        },

        /* Toolip  */
        toolTip: function () {
            $('[data-toggle="tooltip"]').tooltip();
        },

        /* Accordion  */
        accordion: function () {
            if ($('.theme-accordion__wrapper') !== null) {
                $('.theme-accordion__wrapper > h6 > a').on('click', function () {
                    const $this = $(this);
                    $this.parent()
                        .parents('.theme-accordion__wrapper')
                        .toggleClass('selected');
                    $this.parent()
                        .parents('.theme-accordion__wrapper')
                        .siblings('.theme-accordion__wrapper')
                        .removeClass('selected');
                });
            }

        },

        /* Rating */
        rating: function () {
            const ratingWrapper = document.querySelectorAll('.ratings');
            ratingWrapper.forEach((elm, ind) => {
                const dataRating = elm.getAttribute('data-rating');
                const dataRatingFloat = parseFloat(dataRating);
                switch (dataRatingFloat) {
                    case 1:
                        elm.classList.add('one');
                        break;
                    case 2:
                        elm.classList.add('two');
                        break;
                    case 3:
                        elm.classList.add('three');
                        break;
                    case 4:
                        elm.classList.add('four');
                        break;
                    case 5:
                        elm.classList.add('five');
                        break;
                    default:
                        elm.classList.add('none');
                }

                function fractionClass(v1, v2, classOne, classTwo) {
                    if (dataRatingFloat > v1 && dataRatingFloat < v2) {
                        elm.classList.add(classOne, classTwo);
                    }
                }

                fractionClass(1, 2, 'one', 'one-n-half');
                fractionClass(2, 3, 'two', 'two-n-half');
                fractionClass(3, 4, 'three', 'three-n-half');
                fractionClass(4, 5, 'four', 'four-n-half');
            });
        },

        /* Free Consultation */
        freeConsultation: function () {

            if ($('#dlawyers_free_consultation') !== null) {
                const checkbox = $('#enable_free_consultation');
                const freeCon = $('#dlawyers_free_consultation');
                var checkboxVal = $('#enable_free_consultation').val();
            
                // Initial state setup
                if (checkbox.prop('checked')) {
                    freeCon.show();
                } else {
                    freeCon.hide();
                }
            
                // Checkbox change event handler
                checkbox.change(function() {
                    if (checkbox.prop('checked')) {
                        freeCon.show();
                    } else {
                        freeCon.hide();
                        checkbox.removeAttr('checked');
                        checkbox.removeAttr('value');
                        checkboxVal = '';
                    }
                });
            
                // Form submission event handler
                $('body').on('submit', '#directorist-add-listing-form', function(event) {
                    event.preventDefault();
            
                    var mixValue = checkbox.prop('checked') + '___' + freeCon.val();
                    freeCon.val(mixValue);
                });
            }
        },

        directoristListingType: function () {

            if ($('#search-menu .directorist-listing-type-selection') !== null) {
                $('body').on('click', '#search-menu .directorist-listing-type-selection a', function (e) {
                    var single_item_data = $(this).data('listing_type');
                    $('#search-menu input[name="directory_type"]').val(single_item_data);
                    $('#search-menu .directorist-listing-type-selection').removeClass('directorist-listing-type-selection__link--current');
                    $(this).addClass('directorist-listing-type-selection__link--current');


                });
            }

            if ($('.header-search-wrapper') !== null) {
                $('body').on('click', '.header-search-wrapper .directorist-listing-type-selection a', function (e) {
                    var single_item_data_2 = $(this).data('listing_type');
                    $('.header-search-wrapper input[name="directory_type"]').val(single_item_data_2);
                });

            }
        },

    };

    theme.responsiveMenuTrigger();

    $(window).resize(function () {
        theme.responsiveMenuTrigger();
    });


    window.addEventListener('directorist-reload-listings-map-archive', function () {
        theme.sliderRange();
        theme.rating();
        theme.sidebarCollapse();
    });

    window.addEventListener('directorist-search-form-nav-tab-reloaded', function () {
        theme.sliderRange();
    });

    function content_ready_scripts() {
        theme.searchPopup();
        theme.counterUpPlugin();
        theme.contactButton();
        theme.sidebarCollapse();
        theme.searchCategories();
        theme.searchHome();
        theme.searchFieldsAction();
        theme.toolTip();
        theme.accordion();
        theme.rating();
        theme.freeConsultation();
        theme.directoristListingType();
        theme.loginAlert();
    }

    function content_load_scripts() {
        theme.swiperSlider();
        theme.sliderRange();
        theme.searchDropDown();
        theme.responsiveMenuTrigger();
        theme.sidebarCollapse();
    }

    $(document).ready(function () {
        content_ready_scripts();
        theme.mobileMenu('.menu-item a', '.sub-menu');
        updateRadioInputIdAttrs();
        theme.searchDropDown();
        
    });

    function updateRadioInputIdAttrs() {
        $('.directorist-dlawyers-radio-circle').each(function (index, element) {
            let radio = $(element).find('input[type="radio"]');
            let label = $(element).find('label');

            radio.prop('id', radio.attr('id') + index);
            label.prop('for', radio.attr('id'));
        });
    }


    $(window).on('load', initSetup);
    $(window).on('directorist-search-form-nav-tab-reloaded', initSetup);

    function initSetup() {
        theme.preloader();
        theme.searchDropDown();
        content_load_scripts();
        updateRadioInputIdAttrs();
    }

    /* Elementor Edit Mode */
    $(window).on('elementor/frontend/init', function () {
        setTimeout(() => {
            if (elementorFrontend.isEditMode()) {
                //elementorFrontend.hooks.addAction('frontend/element_ready/widget', function() {
                content_ready_scripts()
                content_load_scripts();
                theme.swiperSlider();
                //});
            }
        }, 6000);
    });


})(jQuery);