<?php
/*
Plugin Name: dLawyers Core
Plugin URI: https://directorist.com/
Description: Core Plugin for dLawyers Theme
Author: wpWax
Author URI: https://wpwax.com
Domain Path: /languages
Text Domain: dlawyers-core
Version: 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class dLawyers_Core {

	protected static $instance;
	public static $base_dir;
	public static $base_url;
	public $plugin = 'dlawyers';
	public $prefix = 'dlawyers';

	public function __construct() {
		self::$base_dir = get_template_directory() . '/core/';
		self::$base_url = get_template_directory_uri() . '/core/';

		// echo self::$base_dir;

		add_action( 'plugins_loaded', array( $this, 'load_textdomain' ), 20 );
		add_action( 'dlawyers_theme_init_before', array( $this, 'dlawyers_theme_init_before' ) );
		add_action( 'dlawyers_theme_init_after', array( $this, 'dlawyers_theme_init_after' ) );
		add_action( 'dlawyers_social_share', array( $this, 'dlawyers_social_share' ) );
	}

	public static function instance() {
		if ( null == self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function load_textdomain() {
		load_plugin_textdomain( $this->plugin, false, self::$base_dir . 'languages' );
	}

	public function dlawyers_theme_init_before() {

		require_once self::$base_dir . 'inc/helper.php';

		if ( ! class_exists( 'CSF' ) ) {
			require_once self::$base_dir . 'lib/codestar-framework/codestar-framework.php'; // Codestar Framework
		}

		require_once self::$base_dir . 'lib/wpwaxtheme-svg/init.php';
	}

	public function dlawyers_theme_init_after() {
		require_once self::$base_dir . 'inc/demo-importer.php';
		require_once self::$base_dir . 'widgets/init.php'; // Widgets

		if ( did_action( 'elementor/loaded' ) ) {
			require_once self::$base_dir . 'elementor-support/init.php'; // Elementor
		}
	}

	public function dlawyers_social_share() {
		include self::$base_dir . 'inc/social-share.php';
	}

}

dLawyers_Core::instance();