<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\Theme\Elementor;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Accordion extends Custom_Widget_Base {

	public function __construct( $data = array(), $args = null ) {
		$this->wpwax_name = esc_html__( 'Accordion', 'dlawyers' );
		$this->wpwax_base = 'wpwaxtheme-accordion';
		parent::__construct( $data, $args );
	}

	private function get_repeater() {
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'list_title', array(
				'label'       => esc_html__( 'Title', 'dlawyers' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => esc_html__( 'List Title', 'dlawyers' ),
				'label_block' => true,
			)
		);

		$repeater->add_control(
			'list_content', array(
				'label'      => esc_html__( 'Content', 'dlawyers' ),
				'type'       => \Elementor\Controls_Manager::WYSIWYG,
				'default'    => esc_html__( 'List Content', 'dlawyers' ),
				'show_label' => false,
			)
		);

		return $repeater;
	}

	public function wpwax_fields() {
		$fields = array(

			// General Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_general',
				'label' => esc_html__( 'General', 'dlawyers' ),
			),
			array(
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'items',
				'label'   => esc_html__( 'Add as many items as you want', 'dlawyers' ),
				'fields'  => $this->get_repeater()->get_controls(),
				'default' => array(
					array(
						'list_title'   => __( 'Title #1', 'dlawyers' ),
						'list_content' => __( 'Item content. Click the edit button to change this text.', 'dlawyers' ),
					),
					array(
						'list_title'   => __( 'Title #2', 'dlawyers' ),
						'list_content' => __( 'Item content. Click the edit button to change this text.', 'dlawyers' ),
					),
				),
			),
			array(
				'mode' => 'section_end',
			),

			// Color Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_color',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Color', 'dlawyers' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'title_color',
				'label'     => esc_html__( 'Title', 'dlawyers' ),
				'selectors' => array( '{{WRAPPER}} .theme-accordion__title a' => 'color: {{VALUE}} !important' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'content_color',
				'label'     => esc_html__( 'Content', 'dlawyers' ),
				'selectors' => array( '{{WRAPPER}} .theme-accordion__content' => 'color: {{VALUE}}' ),
			),
			array(
				'mode' => 'section_end',
			),

			// Typography Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_style',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Typography', 'dlawyers' ),
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'title_typo',
				'label'    => esc_html__( 'Title', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .theme-accordion__title a',
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'content_typo',
				'label'    => esc_html__( 'Content', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .theme-accordion__content',
			),
			array(
				'mode' => 'section_end',
			),
		);

		return $fields;
	}

	protected function render() {

		$data = $this->get_settings();

		$template = 'view';

		return $this->wpwax_template( $template, $data );
	}
}