<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

$items = $data['items'];
?>
<div id="accordion" class="theme-accordion">

	<?php if ( $items ): ?>

		<?php foreach ( $items as $id => $item ): ?>

			<div class="theme-accordion__wrapper <?php echo 0 == $id ? 'selected' : ''; ?>" id="heading-<?php echo $id; ?>">
				
				<h6 class="mb-0 theme-accordion__title">

					<a role="button" data-toggle="collapse" href="#collapse-<?php echo esc_attr( $id ); ?>" aria-expanded="<?php echo 0 == $id ? 'true' : 'false'; ?>" aria-controls="collapse-<?php echo esc_attr( $id ); ?>"><?php echo esc_html( isset( $item['list_title'] ) ? $item['list_title'] : '' ); ?></a>
				
				</h6>

				<div id="collapse-<?php echo $id; ?>" class="theme-accordion__body collapse<?php echo 0 === $id ? ' show' : ''; ?> " data-parent="#accordion" aria-labelledby="heading-<?php echo $id; ?>">
					
					<div class="theme-accordion__content"><?php echo wp_kses_post( isset( $item['list_content'] ) ? $item['list_content'] : '' ); ?></div>
				
				</div>
				
			</div>

		<?php endforeach;?>

	<?php endif;?>

</div>