<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\Theme\Elementor;

use Directorist\Helper;
use Elementor\Controls_Manager;
use wpWax\dLawyers\Directorist_Support;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class All_Categories extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->wpwax_name = esc_html__( 'Listing Categories', 'dlawyers' );
		$this->wpwax_base = 'wpwaxtheme-all-categories';
		parent::__construct( $data, $args );

	}

	private function wpwax_listing_categories() {
		$result     = [];
		$categories = get_terms( ATBDP_CATEGORY );
		foreach ( $categories as $category ) {
			$result[$category->slug] = $category->name;
		}

		return $result;
	}

	private function wpwax_listing_types() {
		$listing_types = [];
		$all_types     = get_terms( ['taxonomy' => ATBDP_TYPE, 'hide_empty' => false] );

		foreach ( $all_types as $type ) {
			$listing_types[$type->slug] = $type->name;
		}

		return $listing_types;
	}

	public function wpwax_fields() {
		$fields = [
			[
				'mode'  => 'section_start',
				'id'    => 'sec_general',
				'label' => esc_html__( 'General', 'dlawyers' ),
			],
			[
				'type'      => Controls_Manager::SELECT2,
				'id'        => 'type',
				'label'     => esc_html__( 'Directory Types', 'dlawyers' ),
				'multiple'  => true,
				'options'   => $this->wpwax_listing_types(),
				'condition' => Helper::multi_directory_enabled() ? '' : ['nocondition' => true],
			],
			[
				'type'      => Controls_Manager::SELECT2,
				'id'        => 'default_type',
				'label'     => esc_html__( 'Default Directory Types', 'dlawyers' ),
				'options'   => $this->wpwax_listing_types(),
				'condition' => Helper::multi_directory_enabled() ? '' : ['nocondition' => true],
			],
			[
				'type'    => Controls_Manager::SELECT,
				'id'      => 'view',
				'label'   => esc_html__( 'View As', 'dlawyers' ),
				'options' => [
					'grid' => esc_html__( 'Grid View', 'dlawyers' ),
					'list' => esc_html__( 'List View', 'dlawyers' ),
				],
				'default' => 'grid',
			],
			[
				'type'      => Controls_Manager::SELECT,
				'id'        => 'style',
				'label'     => esc_html__( 'Design', 'dlawyers' ),
				'options'   => [
					'style-1' => esc_html__( 'Style 1', 'dlawyers' ),
					'style-2' => esc_html__( 'Style 2', 'dlawyers' ),
				],
				'default'   => 'style-2',
				'condition' => ['view' => ['grid']],
			],
			[
				'type'      => Controls_Manager::SELECT,
				'id'        => 'columns',
				'label'     => esc_html__( 'Number of columns', 'dlawyers' ),
				'options'   => [
					'2' => esc_html__( '2', 'dlawyers' ),
					'3' => esc_html__( '3', 'dlawyers' ),
					'4' => esc_html__( '4', 'dlawyers' ),
					'5' => esc_html__( '5', 'dlawyers' ),
					'6' => esc_html__( '6', 'dlawyers' ),
				],
				'default'   => '3',
				'condition' => ['view' => ['grid']],
			],
			[
				'type'     => Controls_Manager::SELECT2,
				'id'       => 'slug',
				'label'    => esc_html__( 'Specify Categories', 'dlawyers' ),
				'multiple' => true,
				'options'  => $this->wpwax_listing_categories(),
			],
			[
				'type'      => Controls_Manager::NUMBER,
				'id'        => 'cat_per_page',
				'label'     => __( 'Number of Categories', 'dlawyers' ),
				'min'       => 1,
				'max'       => 16,
				'step'      => 1,
				'default'   => 8,
			],
			[
				'type'    => Controls_Manager::SELECT,
				'id'      => 'order_list',
				'label'   => esc_html__( 'Categories Order', 'dlawyers' ),
				'options' => [
					'asc'  => esc_html__( ' ASC', 'dlawyers' ),
					'desc' => esc_html__( ' DESC', 'dlawyers' ),
				],
				'default' => 'desc',
			],
			[
				'type'      => Controls_Manager::SWITCHER,
				'id'        => 'hide_subcategories',
				'label'     => esc_html__( 'Hide Subcategories?', 'dlawyers' ),
				'default'   => 'no',
				'condition' => [
					'style' => ['style-2'],
					'view'  => ['grid'],
				],
			],
			[
				'type'      => Controls_Manager::CHOOSE,
				'id'        => 'content_alginment',
				'label'     => esc_html__( 'Alignment', 'dlawyers' ),
				'options'   => [
					'left'   => [
						'title' => esc_html__( 'Left', 'dlawyers' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dlawyers' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right'  => [
						'title' => esc_html__( 'Right', 'dlawyers' ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'   => 'center',
				'toggle'    => true,
				'selectors' => [
					'{{WRAPPER}} .theme-cat-box__header' => 'justify-content: {{VALUE}}',
					'{{WRAPPER}} .theme-cat-box'         => 'text-align: {{VALUE}}',
					'{{WRAPPER}} .theme-sub-cats'        => 'text-align: {{VALUE}}',
				],
				'condition' => [
					'style' => ['style-2'],
					'view'  => ['grid'],
				],
			],
			[
				'mode' => 'section_end',
			],

			// Color Section
			[
				'mode'      => 'section_start',
				'id'        => 'sec_style',
				'tab'       => Controls_Manager::TAB_STYLE,
				'label'     => esc_html__( 'Color', 'dlawyers' ),
				'condition' => [
					'style' => ['style-2'],
					'view'  => ['grid'],
				],
			],
			[
				'type'      => Controls_Manager::COLOR,
				'id'        => 'box_bg_color',
				'label'     => esc_html__( 'Box Background', 'dlawyers' ),
				'selectors' => [
					'{{WRAPPER}} .theme-cat-box'                                   => 'background-color: {{color}};',
					'{{WRAPPER}} .theme-cat-box .theme-cat-box__header-icon span'  => 'color: {{color}};',
					'{{WRAPPER}} .theme-cat-box:hover .theme-cat-box__header-icon' => 'background-color: {{color}};',
				],
			],
			[
				'type'      => Controls_Manager::COLOR,
				'id'        => 'box_bg_color_hover',
				'label'     => esc_html__( 'Box Background Hover', 'dlawyers' ),
				'selectors' => [
					'{{WRAPPER}} .theme-cat-box:hover'                                  => 'background-color: {{color}};',
					'{{WRAPPER}} .theme-cat-box .theme-cat-box__header-icon'            => 'background-color: {{color}};',
					'{{WRAPPER}} .theme-cat-box:hover .theme-cat-box__header-icon span' => 'color: {{color}};',
				],
			],
			[
				'type'      => Controls_Manager::COLOR,
				'id'        => 'title_color',
				'label'     => esc_html__( 'Category Title', 'dlawyers' ),
				'selectors' => [
					'{{WRAPPER}} .theme-cat-box__title' => 'color: {{color}};',
				],
			],
			[
				'type'      => Controls_Manager::COLOR,
				'id'        => 'title_color_hover',
				'label'     => esc_html__( 'Category Title Hover', 'dlawyers' ),
				'selectors' => [
					'{{WRAPPER}} .theme-cat-box:hover .theme-cat-box__title' => 'color: {{color}};',
				],
			],
			[
				'type'      => Controls_Manager::COLOR,
				'id'        => 'sub_cats_color',
				'label'     => esc_html__( 'Sub Categories', 'dlawyers' ),
				'selectors' => [
					'{{WRAPPER}} .theme-cat-box__child-category a' => 'color: {{color}};',
				],
			],
			[
				'type'      => Controls_Manager::COLOR,
				'id'        => 'sub_cats_color_hover',
				'label'     => esc_html__( 'Sub Categories Hover', 'dlawyers' ),
				'selectors' => [
					'{{WRAPPER}} .theme-cat-box:hover .theme-cat-box__child-category a' => 'color: {{color}};',
				],
			],
			[
				'type'      => Controls_Manager::COLOR,
				'id'        => 'sub_cats_count_color',
				'label'     => esc_html__( 'Sub Categories Count', 'dlawyers' ),
				'selectors' => [
					'{{WRAPPER}} .theme-cat-box .theme-cat-box__sub-cats .card-link' => 'color: {{color}};',
				],
			],
			[
				'type'      => Controls_Manager::COLOR,
				'id'        => 'sub_cats_count_color_hover',
				'label'     => esc_html__( 'Sub Categories Count Hover', 'dlawyers' ),
				'selectors' => [
					'{{WRAPPER}} .theme-cat-box:hover .theme-cat-box__sub-cats .card-link' => 'color: {{color}};',
				],
			],
			[
				'mode' => 'section_end',
			],

			// Typography Section
			[
				'mode'  => 'section_start',
				'id'    => 'sec_typography',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Typography', 'dlawyers' ),
			],
			[
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'title_typo',
				'label'    => esc_html__( 'Category Title', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .theme-cat-box__title, {{WRAPPER}} #directorist.atbd_wrapper .cat-name, .theme-category-wrapper__title',
			],
			[
				'mode'      => 'group',
				'type'      => \Elementor\Group_Control_Typography::get_type(),
				'id'        => 'subcats_typo',
				'label'     => esc_html__( 'Sub Categories Title', 'dlawyers' ),
				'selector'  => '{{WRAPPER}} .theme-category-wrapper__lists li a',
				'condition' => [
					'view' => ['list'],
				],
			],
			[
				'mode' => 'section_end',
			],
		];

		return $fields;
	}

	public function directorist_category_subterms_html( $html ) {
		return;
	}

	public function dlawyers_directorist_grid_count_html( $count_html ) {
		$count_html = str_replace( ['(', ')'], [''], $count_html );

		return $count_html;

	}

	protected function render() {

		$data = $this->get_settings_for_display();

		$atts = [
			'view'         => $data['view'],
			'columns'      => $data['columns'],
			'slug'         => $data['slug'] ? implode( ',', $data['slug'] ) : '',
			'order'        => $data['order_list'],
			'cat_per_page' => $data['cat_per_page'],
		];

		if ( 'yes' === $data['hide_subcategories'] ) {
			add_filter( 'directorist_category_subterms_html', [$this, 'directorist_category_subterms_html'] );
		}

		if ( 'style-1' === $data['style'] ) {
			add_filter( 'dlawyers_directorist_grid_count_html', [$this, 'dlawyers_directorist_grid_count_html'] );
		}

		if ( Helper::multi_directory_enabled() ) {

			if ( $data['type'] ) {
				$atts['directory_type'] = implode( ',', $data['type'] );
			}

			if ( $data['default_type'] ) {
				$atts['default_directory_type'] = $data['default_type'];
			}

		}

		if ( 'style-2' === $data['style'] && 'grid' === $data['view'] ) {
			$data = Directorist_Support::get_taxonomy_data( $atts );

			return $this->wpwax_template( 'view', $data );
		} else {
			$this->wpwax_run_shortcode( 'directorist_all_categories', $atts );
		}
	}
}