<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

use \Directorist\Helper;
use wpWax\dLawyers\Directorist_Support;

if( is_array( $data ) ){
	extract( $data );
}

$columns = floor( 12 / $columns );
?>
<div class="atbd_wrapper directorist-w-100">

	<div class="<?php Helper::directorist_container_fluid(); ?>">

		<div class="theme-all-categories atbdp-no-margin">

			<div class="<?php Helper::directorist_row(); ?>">
			
				<?php 
				if( $categories ) :
					foreach ($categories as $category) :
						
						$cat_class = !$category['img'] ? ' atbd_category_no_image' : ''; ?>

						<div class="<?php Helper::directorist_column( $columns ); ?>">

							<div class="cat-box-grid">
							
								<div class="theme-cat-box">

									<div class="theme-cat-box__header">
										<?php if ( $category['has_icon'] ) : ?>
											<div class="theme-cat-box__header-icon rounded-circle"><?php directorist_icon( $category['icon_class'] ); ?></div>
																		
										<?php elseif ( $category['img'] ) : ?>
											
											<?php 	
											$img = \wpWax\Theme\Lib\SVG\WP_SVG::get_attachment_image( get_term_meta( $category['term']->term_id, 'image', true) );
											echo wp_kses_post( $img ); 
											?>

										<?php endif; ?>
									</div>
									
									<div class="theme-cat-box__info">
										<a class="stretched-link theme-cat-box__title-area  category_single<?php echo esc_attr( $cat_class ); ?>" href="<?php echo esc_url($category['permalink']); ?>">
											<h5 class="theme-cat-box__title"><?php echo esc_html($category['name']); ?></h5>
										</a>
										
										<?php 
											$term_html = Directorist_Support::get_subterms_html( $taxonomy, $category['term'] );

											if ( $term_html ){
												printf( '<div class="theme-cat-box__sub-cats">%s</div>', $term_html );
											}
											?>
									</div>
									
								</div>
								
							</div>

						</div>
					<?php
					endforeach;
				else:
					_e('<p>No Results found!</p>', 'dlawyers');
				endif;
				?>
			</div>
		</div>
	</div>

</div>