<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\Theme\Elementor;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Browse_Attorneys extends Custom_Widget_Base {

	public function __construct( $data = array(), $args = null ) {
		$this->wpwax_name = esc_html__( 'Browse Attorneys', 'dlawyers' );
		$this->wpwax_base = 'wpwax-browse-attorneys';
		parent::__construct( $data, $args );
	}

	private function wpwax_query( $data ) {
		$args = array(
			'taxonomy'     => 'at_biz_dir-location',
			'hierarchical' => false,
		);

		return new \WP_Term_Query( $args );
	}

	public function wpwax_fields() {

		$categories        = get_categories();
		$category_dropdown = array( '0' => esc_html__( 'All Categories', 'dlawyers' ) );

		foreach ( $categories as $category ) {
			$category_dropdown[$category->term_id] = $category->name;
		}

		$fields = array(

			// General Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_general',
				'label' => esc_html__( 'General', 'dlawyers' ),
			),
			array(
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'id'        => 'show_category',
				'label'     => esc_html__( 'Show Category', 'dlawyers' ),
				'label_on'  => esc_html__( 'Show', 'dlawyers' ),
				'label_off' => esc_html__( 'Hide', 'dlawyers' ),
				'default'   => 'yes',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'nested_levels',
				'label'   => esc_html__( 'Locations', 'dlawyers' ),
				'options' => array(
					'1' => esc_html__( '1 Level', 'dlawyers' ),
					'2' => esc_html__( '2 Levels', 'dlawyers' ),
					'3' => esc_html__( '3 Levels', 'dlawyers' ),

				),
				'default' => 3,

			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'cat_title',
				'label'   => esc_html__( 'Category Title', 'dlawyers' ),
				'default' => esc_html__( 'By Practice Area', 'dlawyers' ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'first_level_title',
				'label'   => esc_html__( 'First Level Title', 'dlawyers' ),
				'default' => esc_html__( 'By State', 'dlawyers' ),
			),
			array(
				'type'      => Controls_Manager::TEXT,
				'id'        => 'second_level_title',
				'label'     => esc_html__( 'Second Level Title', 'dlawyers' ),
				'default'   => esc_html__( 'By County', 'dlawyers' ),
				'condition' => array( 'nested_levels' => array( '2', '3' ) ),
			),
			array(
				'type'      => Controls_Manager::TEXT,
				'id'        => 'third_level_title',
				'label'     => esc_html__( 'Third Level Title', 'dlawyers' ),
				'default'   => esc_html__( 'By City', 'dlawyers' ),
				'condition' => array( 'nested_levels' => array( '3' ) ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'number_of_columns',
				'label'   => esc_html__( 'Number of columns', 'dlawyers' ),
				'options' => array(
					'2' => esc_html__( '6 Columns', 'dlawyers' ),
					'3' => esc_html__( '4 Columns', 'dlawyers' ),
					'4' => esc_html__( '3 Columns', 'dlawyers' ),
					'6' => esc_html__( '2 Columns', 'dlawyers' ),
				),
				'default' => 4,
			),
			array(
				'mode' => 'section_end',
			),

			// Color Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_color',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Color', 'dlawyers' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'title_color',
				'label'     => esc_html__( 'Title', 'dlawyers' ),
				'default'   => '#666d92',
				'selectors' => array( '{{WRAPPER}} .nav-link' => 'color: {{VALUE}}' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'title_hover_color',
				'label'     => esc_html__( 'Title Hover/Active', 'dlawyers' ),
				'default'   => '#fff',
				'selectors' => array(
					'{{WRAPPER}} .nav-link:hover'  => 'color: {{VALUE}}',
					'{{WRAPPER}} .nav-link.active' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'title_bg_color',
				'label'     => esc_html__( 'Title Background', 'dlawyers' ),
				'default'   => '#fff',
				'selectors' => array( '{{WRAPPER}} .nav-tabs' => 'background-color: {{VALUE}}' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'title_bg_hover_color',
				'label'     => esc_html__( 'Title Hover/Active Background', 'dlawyers' ),
				'default'   => '#ef3072',
				'selectors' => array(
					'{{WRAPPER}} .nav-link:hover'  => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .nav-link.active' => 'background-color: {{VALUE}}',
				),
			),
			array(
				'mode' => 'section_end',
			),

			// Typography Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_typo',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Typography', 'dlawyers' ),
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'title_typo',
				'label'    => esc_html__( 'Title', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .nav-link',
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'link_typo',
				'label'    => esc_html__( 'Link', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .h_tabs .tab-content a',
			),
			array(
				'mode' => 'section_end',
			),

		);

		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		$data['wp_term_query'] = $this->wpwax_query( $data );

		$template = 'view';

		return $this->wpwax_template( $template, $data );
	}
}