<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

$wp_term_query      = $data['wp_term_query'];
$nested_levels      = isset( $data['nested_levels'] ) ? $data['nested_levels'] : '1';
$cat_title			= isset( $data['cat_title'] ) ? $data['cat_title'] : '';
$first_level_title  = isset( $data['first_level_title'] ) ? $data['first_level_title'] : '';
$second_level_title = isset( $data['second_level_title'] ) ? $data['second_level_title'] : '';
$third_level_title  = isset( $data['third_level_title'] ) ? $data['third_level_title'] : '';
$show_category      = isset( $data['show_category'] ) ? $data['show_category'] : '';
$number_of_columns  = isset( $data['number_of_columns'] ) ? $data['number_of_columns'] : '';

if( $wp_term_query->terms ) {
	$first_level_locations  = array();
	$second_level_locations = array();
	$third_level_locations  = array();

	foreach ( $wp_term_query->terms as $key => $term ) {

		if ( 0 === $term->parent ) {
			array_push( $first_level_locations, $term->term_id );
		}

	}

	foreach ( $wp_term_query->terms as $key => $term ) {

		if ( in_array( $term->parent, $first_level_locations ) ) {
			array_push( $second_level_locations, $term->term_id );
		}

	}

	foreach ( $wp_term_query->terms as $key => $term ) {

		if ( in_array( $term->parent, $second_level_locations ) ) {
			array_push( $third_level_locations, $term->term_id );
		}

	}
}
?>

<div class="h_tabs">

	<nav id="tabs" class="responsive_tab">

		<div class="nav nav-tabs nav-fill" id="nav-tab" role="tablist">
			
			<?php if( 'yes' === $data['show_category'] ) : ?>
				<a class="nav-item nav-link active" id="nav-category" data-toggle="tab" href="#nav-cats" role="tab" aria-controls="nav-cats" aria-selected="true"><?php echo esc_html( $cat_title ); ?></a>
			<?php endif; ?>
			
			<?php if( $wp_term_query->terms ) : ?>
				
				<?php if( $data['nested_levels'] ) : ?>
					<a class="nav-item nav-link<?php echo esc_attr( ! $data['show_category'] ? ' active' : '' ); ?>" id="nav-level-1" data-toggle="tab" href="#nav-level1" role="tab" aria-controls="nav-level1" aria-selected="<?php echo esc_attr( ! $data['show_category'] ? 'true' : 'false' ); ?>"><?php echo esc_html( $first_level_title ); ?></a>
				<?php endif; ?>
			
				<?php if( '2' === $data['nested_levels'] || '3' === $data['nested_levels'] ) : ?>
					<a class="nav-item nav-link" id="nav-level-2" data-toggle="tab" href="#nav-level2" role="tab" aria-controls="nav-level2" aria-selected="false"><?php echo esc_html( $second_level_title ); ?></a>
				<?php endif; ?>
				
				<?php if( '3' === $data['nested_levels'] ) : ?>
					<a class="nav-item nav-link" id="nav-level-3" data-toggle="tab" href="#nav-level3" role="tab" aria-controls="nav-level3" aria-selected="false"><?php echo esc_html( $third_level_title ); ?></a>
				<?php endif; ?>

			<?php endif; ?>
			

		</div>

	</nav>

	<div class="tab-content" id="nav-tabContent">

		<?php if( 'yes' === $data['show_category'] ) : ?>

			<div class="tab-pane fade show active" id="nav-cats" role="tabpanel" aria-labelledby="nav-category">
				
				<div class="container">

					<div class="row">

						<?php 
						$category_obj = get_terms( array(
							'taxonomy' => 'at_biz_dir-category'
						) );

						foreach ( $category_obj as $single_cat ) :
							printf( '<div class="col-md-4 col-sm-6 col-lg-%s">', $number_of_columns );
							printf( '<a href="%s">%s</a>', get_term_link( $single_cat->term_id ), $single_cat->name );
							echo '</div>';
						endforeach;
						?>

					</div>

				</div>

			</div>

		<?php endif; ?>

		<?php if( $wp_term_query->terms ) : ?>
			
			<?php if( $data['nested_levels'] ) : ?>

				<div class="tab-pane fade<?php echo esc_attr( ! $data['show_category'] ? ' show active' : '' ); ?>" id="nav-level1" role="tabpanel" aria-labelledby="nav-level-1">

					<div class="container">

						<div class="row">

							<?php 
							foreach ( $first_level_locations as $location_id ) :
								$term_obj = get_term( $location_id );
								printf( '<div class="col-md-%s">', $number_of_columns );
								printf( '<a href="%s">%s</a>', get_term_link( $term_obj->term_id ), $term_obj->name );
								echo '</div>';
							endforeach;
							?>

						</div>

					</div>

				</div>

			<?php endif; ?>

			<?php if( '2' === $data['nested_levels'] || '3' === $data['nested_levels'] ) : ?>

				<div class="tab-pane fade" id="nav-level2" role="tabpanel" aria-labelledby="nav-level-2">

					<div class="container">

						<div class="row">

							<?php 
							foreach ( $second_level_locations as $location_id ) :
								$term_obj = get_term( $location_id );
								printf( '<div class="col-md-%s">', $number_of_columns );
								printf( '<a href="%s">%s</a>', get_term_link( $term_obj->term_id ), $term_obj->name );
								echo '</div>';
							endforeach;
							?>

						</div>

					</div>

				</div>

			<?php endif; ?>

			<?php if( '3' === $data['nested_levels'] ) : ?>

				<div class="tab-pane fade" id="nav-level3" role="tabpanel" aria-labelledby="nav-level-3">

					<div class="container">

						<div class="row">

							<?php 
							foreach ( $third_level_locations as $location_id ) :
								$term_obj = get_term( $location_id );
								printf( '<div class="col-md-%s">', $number_of_columns );
								printf( '<a href="%s">%s</a>', get_term_link( $term_obj->term_id ), $term_obj->name );
								echo '</div>';
							endforeach;
							?>

						</div>

					</div>

				</div>

			<?php endif; ?>

		<?php endif; ?>

	</div>
	
</div>