<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\Theme\Elementor;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Contact_Info extends Custom_Widget_Base {

	public function __construct( $data = array(), $args = null ) {
		$this->wpwax_name = esc_html__( 'Contact Info', 'dlawyers' );
		$this->wpwax_base = 'wpwaxtheme-contact-info';
		parent::__construct( $data, $args );
	}

	public function wpwax_fields() {
		$fields = array(

			// General Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_general',
				'label' => esc_html__( 'General', 'dlawyers' ),
			),
			array(
				'label' => esc_html__( 'Address', 'dlawyers' ),
				'type'  => \Elementor\Controls_Manager::HEADING,
				'id'    => 'address_heading',
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'address_title',
				'label'   => esc_html__( 'Title', 'dlawyers' ),
				'default' => esc_html__( 'Address', 'dlawyers' ),
			),
			array(
				'type'        => Controls_Manager::TEXTAREA,
				'id'          => 'address_desc',
				'label'       => esc_html__( 'Address', 'dlawyers' ),
				'placeholder' => esc_html__( '87 Grand St Croton on Hudson New York, NY 10510', 'dlawyers' ),

			),

			array(
				'label' => esc_html__( 'Email', 'dlawyers' ),
				'type'  => \Elementor\Controls_Manager::HEADING,
				'id'    => 'email_heading',
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'email_title',
				'label'   => esc_html__( 'Title', 'dlawyers' ),
				'default' => esc_html__( 'Email', 'dlawyers' ),
			),
			array(
				'type'        => Controls_Manager::URL,
				'id'          => 'email_desc',
				'label'       => esc_html__( 'Email', 'dlawyers' ),
				'placeholder' => esc_html__( 'support@aazztech.com', 'dlawyers' ),

			),

			array(
				'label' => esc_html__( 'Website', 'dlawyers' ),
				'type'  => \Elementor\Controls_Manager::HEADING,
				'id'    => 'website_heading',
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'website_title',
				'label'   => esc_html__( 'Title', 'dlawyers' ),
				'default' => esc_html__( 'Website', 'dlawyers' ),
			),
			array(
				'type'        => Controls_Manager::URL,
				'id'          => 'website_desc',
				'label'       => esc_html__( 'URL', 'dlawyers' ),
				'placeholder' => 'https://your-link.com',
			),
			array(
				'mode' => 'section_end',
			),

			// Style Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_color',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Color', 'dlawyers' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'title_color',
				'label'     => esc_html__( 'Title', 'dlawyers' ),
				'selectors' => array( '{{WRAPPER}} .theme-contact-info__title' => 'color: {{VALUE}}' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'content_color',
				'label'     => esc_html__( 'Content', 'dlawyers' ),
				'selectors' => array( '{{WRAPPER}} .theme-contact-info__content' => 'color: {{VALUE}}' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'content_hover_color',
				'label'     => esc_html__( 'Content Link Hover', 'dlawyers' ),
				'selectors' => array( '{{WRAPPER}} a.theme-contact-info__content:hover' => 'color: {{VALUE}}' ),
			),
			array(
				'mode' => 'section_end',
			),

			// Typography Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_typo',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Typography', 'dlawyers' ),
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'title_typo',
				'label'    => esc_html__( 'Title Typography', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .theme-contact-info__title',
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'content_typo',
				'label'    => esc_html__( 'Content Typography', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .theme-contact-info__content',
			),
			array(
				'mode' => 'section_end',
			),
		);

		return $fields;
	}

	protected function render() {

		$data = $this->get_settings();

		$template = 'view';

		return $this->wpwax_template( $template, $data );
	}
}