<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

?>
<div class="theme-contact-info">

	<div class="theme-contact-info__list">

		<ul>

			<?php if ( ( isset( $data['address_title'] ) || isset( $data['address_desc'] ) ) && ( ! empty( $data['address_title'] ) || !empty( $data['address_desc'] ) ) ): ?>

				<li>

					<div class="theme-contact-info">
						<p class="theme-contact-info__title"><?php echo esc_html( isset( $data['address_title'] ) ? $data['address_title'] : '' ); ?></p>
						<p class="theme-contact-info__content"><?php echo esc_html( isset( $data['address_desc'] ) ? $data['address_desc'] : '' ); ?></p>
					</div>

				</li>

			<?php endif;?>

			<?php if ( ( ( isset( $data['email_title'] ) || isset( $data['email_desc']['url'] ) ) ) && ( ! empty( $data['email_title'] ) || ! empty( $data['email_desc']['url'] ) ) ): ?>

				<li>

					<div class="theme-contact-info">
						<p class="theme-contact-info__title"><?php echo esc_html( isset( $data['email_title'] ) ? $data['email_title'] : '' ); ?></p>
						
						<?php printf( '<a href="%s" class="theme-contact-info__content"%s%s>%s</a>', 
							esc_url( isset( $data['email_desc']['url'] ) ? 'mailto:'. $data['email_desc']['url'] : '#' ), 
							wp_kses_post( $data['email_desc']['is_external'] === 'on' ? $data['email_desc']['is_external'] : ' target="_blank"' ),
							wp_kses_post( $data['email_desc']['nofollow'] === 'on' ? $data['email_desc']['nofollow'] : ' rel="nofollow"' ),							
							esc_url( $data['email_desc']['url'] ) ? $data['email_desc']['url'] : '' ); ?>
					</div>

				</li>

			<?php endif;?>

			<?php if ( ( isset( $data['website_title'] ) || isset( $data['website_desc']['url'] ) ) && ( ! empty( $data['website_title'] ) || ! empty( $data['website_desc']['url'] ) ) ): ?>

				<li>

					<div class="theme-contact-info">
						<p class="theme-contact-info__title"><?php echo esc_html( isset( $data['website_title'] ) ? $data['website_title'] : '' ); ?></p>
						
						<?php printf( '<a href="%s" class="theme-contact-info__content"%s%s>%s</a>', 
							esc_url( isset( $data['website_desc']['url'] ) ? $data['website_desc']['url'] : '#' ), 
							wp_kses_post( $data['website_desc']['is_external'] === 'on' ? $data['website_desc']['is_external'] : ' target="_blank"' ),
							wp_kses_post( $data['website_desc']['nofollow'] === 'on' ? $data['website_desc']['nofollow'] : ' rel="nofollow"' ),							
							esc_url( $data['website_desc']['url'] ) ? $data['website_desc']['url'] : '' ); ?>

					</div>

				</li>

			<?php endif;?>

		</ul>

	</div>

</div>