<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\Theme\Elementor;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Counter extends Custom_Widget_Base {

	public function __construct( $data = array(), $args = null ) {
		$this->wpwax_name = esc_html__( 'Counter', 'dlawyers' );
		$this->wpwax_base = 'wpwax-counter';
		parent::__construct( $data, $args );
	}

	private function wpwax_load_scripts() {
		wp_enqueue_script( 'counter-up' );
		wp_enqueue_script( 'waypoints' );
	}

	public function wpwax_fields() {
		$fields = array(

			// General Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_general',
				'label' => esc_html__( 'General', 'dlawyers' ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'number',
				'label'   => esc_html__( 'Number', 'dlawyers' ),
				'default' => esc_html__( '55', 'dlawyers' ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'title',
				'label'   => esc_html__( 'Title', 'dlawyers' ),
				'default' => esc_html__( 'Lorem Number', 'dlawyers' ),
			),
			array(
				'type'        => Controls_Manager::TEXT,
				'id'          => 'number_prefix',
				'label'       => esc_html__( 'Number Prefix', 'dlawyers' ),
				'placeholder' => '$',
			),
			array(
				'type'        => Controls_Manager::TEXT,
				'id'          => 'number_suffix',
				'label'       => esc_html__( 'Number Suffix', 'dlawyers' ),
				'placeholder' => 'Plus',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'wpwax_animation_duration',
				'label'   => esc_html__( 'Animation Duration', 'dlawyers' ),
				'default' => '2000',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'delay',
				'label'   => esc_html__( 'Delay', 'dlawyers' ),
				'default' => '10',
			),
			array(
				'mode'      => 'responsive',
				'type'      => Controls_Manager::CHOOSE,
				'id'        => 'content_alginment',
				'label'     => esc_html__( 'Alignment', 'dlawyers' ),
				'options'   => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'dlawyers' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'dlawyers' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'dlawyers' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'default'   => 'left',
				'toggle'    => true,
				'selectors' => array( '{{WRAPPER}} .theme-counter__title-area' => 'text-align: {{VALUE}}' ),
			),
			array(
				'mode' => 'section_end',
			),

			// Color Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_style',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Color', 'dlawyers' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'number_color',
				'label'     => esc_html__( 'Number', 'dlawyers' ),
				'default'   => '#111111',
				'selectors' => array(
					'{{WRAPPER}} .theme-counter__number' => 'color: {{color}};',
				),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'tilte_color',
				'label'     => esc_html__( 'Title', 'dlawyers' ),
				'default'   => '#111111',
				'selectors' => array(
					'{{WRAPPER}} .theme-counter__title' => 'color: {{color}};',
				),
			),
			array(
				'mode' => 'section_end',
			),

			// Typography Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_typography',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Typography', 'dlawyers' ),
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'number_typo',
				'label'    => esc_html__( 'Number', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .theme-counter__number',
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'title_typo',
				'label'    => esc_html__( 'Title', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .theme-counter__title',
			),
			array(
				'mode' => 'section_end',
			),
		);

		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		$counter_data = array(
			'time'  => $data['wpwax_animation_duration'],
			'delay' => $data['delay'],
		);

		$data['counter_data'] = json_encode( $counter_data );

		$this->wpwax_load_scripts();
		$template = 'view';

		return $this->wpwax_template( $template, $data );
	}
}