<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\Theme\Elementor;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class CTA extends Custom_Widget_Base {

	public function __construct( $data = array(), $args = null ) {
		$this->wpwax_name = esc_html__( 'Call to Action', 'dlawyers' );
		$this->wpwax_base = 'wpwax-cta';
		parent::__construct( $data, $args );
	}

	public function wpwax_fields() {
		$fields = array(

			// General Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_general',
				'label' => esc_html__( 'General', 'dlawyers' ),
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'title',
				'label'   => esc_html__( 'Title', 'dlawyers' ),
				'default' => esc_html__( 'Lorem Ipsum', 'dlawyers' ),
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'content',
				'label'   => esc_html__( 'Content', 'dlawyers' ),
				'default' => esc_html__( 'Lorem Ipsum has been standard daand scrambled. Rimply dummy text of the printing and typesetting industry', 'dlawyers' ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'buttontext',
				'label'   => esc_html__( 'Button Text', 'dlawyers' ),
				'default' => esc_html__( 'Lorem Ipsum', 'dlawyers' ),
			),
			array(
				'type'        => Controls_Manager::URL,
				'id'          => 'buttonurl',
				'label'       => esc_html__( 'Button URL', 'dlawyers' ),
				'placeholder' => 'https://your-link.com',
			),
			array(
				'type'      => Controls_Manager::CHOOSE,
				'id'        => 'content_alginment',
				'label'     => esc_html__( 'Alignment', 'dlawyers' ),
				'options'   => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'dlawyers' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'dlawyers' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'dlawyers' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'default'   => 'center',
				'toggle'    => true,
				'selectors' => array(
					'{{WRAPPER}}' => 'text-align: {{VALUE}}',
				),
			),
			array(
				'mode' => 'section_end',
			),

			// Color Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_style',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Color', 'dlawyers' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'title_color',
				'label'     => esc_html__( 'Title', 'dlawyers' ),
				'selectors' => array(
					'{{WRAPPER}} .theme-cta__title' => 'color: {{VALUE}}',
				),
				'default'   => '#CBCBCB',
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'content_color',
				'label'     => esc_html__( 'Content', 'dlawyers' ),
				'selectors' => array(
					'{{WRAPPER}} .theme-cta__content' => 'color: {{VALUE}}',
				),
				'default'   => '#222222',
			),
			array(
				'label' => esc_html__( 'Button', 'dlawyers' ),
				'type'  => \Elementor\Controls_Manager::HEADING,
				'id'    => 'button_heading',
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'button_text_color',
				'label'     => esc_html__( 'Button Text', 'dlawyers' ),
				'selectors' => array(
					'{{WRAPPER}} .theme-cta__button a' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'button_text_color_hover',
				'label'     => esc_html__( 'Button Hover Text', 'dlawyers' ),
				'selectors' => array(
					'{{WRAPPER}} .theme-cta__button a:hover' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'button_background_color',
				'label'     => esc_html__( 'Button Background', 'dlawyers' ),
				'selectors' => array(
					'{{WRAPPER}} .theme-cta__button a' => 'background-color: {{VALUE}}',
				),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'button_background_color_hover',
				'label'     => esc_html__( 'Button Hover Background', 'dlawyers' ),
				'selectors' => array(
					'{{WRAPPER}} .theme-cta__button a:hover' => 'background-color: {{VALUE}}',
				),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'button_border_color',
				'label'     => esc_html__( 'Button Border', 'dlawyers' ),
				'selectors' => array(
					'{{WRAPPER}} .theme-cta__button a' => 'border-color: {{VALUE}}',
				),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'button_border_color_hover',
				'label'     => esc_html__( 'Button Hover Border', 'dlawyers' ),
				'selectors' => array(
					'{{WRAPPER}} .theme-cta__button a:hover' => 'border-color: {{VALUE}}',
				),
			),
			array(
				'mode' => 'section_end',
			),

			// Typography Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_style_type',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Typography', 'dlawyers' ),
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'title_typo',
				'label'    => esc_html__( 'Title', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .theme-cta__title',
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'content_typo',
				'label'    => esc_html__( 'Content', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .theme-cta__content',
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'btn_typo',
				'label'    => esc_html__( 'Button', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .theme-cta__button a',
			),
			array(
				'mode' => 'section_end',
			),
		);

		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		$template = 'view';

		return $this->wpwax_template( $template, $data );
	}
}