<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\Theme\Elementor;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Info_Box extends Custom_Widget_Base {

	public function __construct( $data = array(), $args = null ) {
		$this->wpwax_name = esc_html__( 'Info Box', 'dlawyers' );
		$this->wpwax_base = 'wpwax-info-box';
		parent::__construct( $data, $args );
	}

	public function wpwax_fields() {
		$fields = array(

			// General Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_general',
				'label' => esc_html__( 'General', 'dlawyers' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'icontype',
				'label'   => esc_html__( 'Icon Type', 'dlawyers' ),
				'options' => array(
					'icon'  => esc_html__( 'Icon', 'dlawyers' ),
					'image' => esc_html__( 'Custom Image', 'dlawyers' ),
				),
				'default' => 'icon',
			),
			array(
				'type'      => Controls_Manager::ICON,
				'id'        => 'icon',
				'label'     => esc_html__( 'Icon', 'dlawyers' ),
				'default'   => 'fa fa-rocket',
				'condition' => array( 'icontype' => array( 'icon' ) ),
			),
			array(
				'type'        => Controls_Manager::MEDIA,
				'id'          => 'image',
				'label'       => esc_html__( 'Image', 'dlawyers' ),
				'condition'   => array( 'icontype' => array( 'image' ) ),
				'description' => __( 'Recommended image size is 100x100 px.<br/>You can upload SVG format as well, to get SVG images click here: <a target="_blank" href="https://www.flaticon.com/">flaticon.com</a>', 'dlawyers' ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'title',
				'label'   => esc_html__( 'Title', 'dlawyers' ),
				'default' => esc_html__( 'Lorem Ipsum', 'dlawyers' ),
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'content',
				'label'   => esc_html__( 'Content', 'dlawyers' ),
				'default' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo ipsum dolor sit amet', 'dlawyers' ),
			),
			array(
				'type'        => Controls_Manager::URL,
				'id'          => 'url',
				'label'       => esc_html__( 'Link (Optional)', 'dlawyers' ),
				'placeholder' => esc_attr( 'https://your-link.com', 'dlawyers' ),
			),
			array(
				'type'      => Controls_Manager::CHOOSE,
				'id'        => 'content_alginment',
				'label'     => esc_html__( 'Alignment', 'dlawyers' ),
				'options'   => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'dlawyers' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'dlawyers' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'dlawyers' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'default'   => 'center',
				'toggle'    => true,
				'selectors' => array( '{{WRAPPER}}' => 'text-align: {{VALUE}}' ),
			),
			array(
				'mode' => 'section_end',
			),

			// Icon Section
			array(
				'mode'      => 'section_start',
				'id'        => 'sec_icon',
				'tab'       => Controls_Manager::TAB_STYLE,
				'label'     => esc_html__( 'Icon', 'dlawyers' ),
				'condition' => array( 'icontype' => array( 'icon' ) ),

			),
			array(
				'mode' => 'section_end',
			),

			// Image Section
			array(
				'mode'      => 'section_start',
				'id'        => 'sec_image',
				'tab'       => Controls_Manager::TAB_STYLE,
				'label'     => esc_html__( 'Image', 'dlawyers' ),
				'condition' => array( 'icontype' => array( 'image' ) ),

			),
			array(
				'id'         => 'image_border_radius',
				'label'      => esc_html__( 'Border Radius', 'dlawyers' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			),
			array(
				'mode' => 'section_end',
			),

			// Color Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_style',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Color', 'dlawyers' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'bgcolor',
				'label'     => esc_html__( 'Background', 'dlawyers' ),
				'selectors' => array( '{{WRAPPER}} .theme-feature-box' => 'background-color: {{VALUE}}' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'content_color',
				'label'     => esc_html__( 'Content', 'dlawyers' ),
				'selectors' => array( '{{WRAPPER}} .theme-feature-box__text' => 'color: {{VALUE}}' ),
			),

			array(
				'label' => esc_html__( 'Title', 'dlawyers' ),
				'type'  => \Elementor\Controls_Manager::HEADING,
				'id'    => 'title_heading',
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'title_color',
				'label'     => esc_html__( 'Title', 'dlawyers' ),
				'selectors' => array( '{{WRAPPER}} .theme-feature-box__title, {{WRAPPER}} .theme-feature-box__title a' => 'color: {{VALUE}}' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'title_hover_color',
				'label'     => esc_html__( 'Title Hover', 'dlawyers' ),
				'selectors' => array( '{{WRAPPER}} .theme-feature-box__title:hover' => 'color: {{VALUE}}' ),
			),

			array(
				'label'     => esc_html__( 'Icon/Image', 'dlawyers' ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'id'        => 'icon_heading',
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'icon_color',
				'label'     => esc_html__( 'Icon', 'dlawyers' ),
				'selectors' => array(
					'{{WRAPPER}} .theme-feature-box__icon i'   => 'color: {{VALUE}}',
					'{{WRAPPER}} .theme-feature-box__icon svg' => 'fill: {{VALUE}}',
				),
				'condition' => array( 'icontype' => array( 'icon' ) ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'icon_color_hover',
				'label'     => esc_html__( 'Icon Hover', 'dlawyers' ),
				'selectors' => array(
					'{{WRAPPER}} .theme-feature-box__icon:hover i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .theme-feature-box__icon svg'     => 'fill: {{VALUE}}',
				),
				'condition' => array( 'icontype' => array( 'icon' ) ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'icon_background_color',
				'label'     => esc_html__( 'Background', 'dlawyers' ),
				'selectors' => array(
					'{{WRAPPER}} .theme-feature-box__icon' => 'background-color: {{VALUE}}',
				),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'icon_background_color_hover',
				'label'     => esc_html__( 'Background Hover', 'dlawyers' ),
				'selectors' => array(
					'{{WRAPPER}} .theme-feature-box__icon:hover' => 'background-color: {{VALUE}}',
				),
			),
			array(
				'mode' => 'section_end',
			),

			// Typography Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_typography',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Typography', 'dlawyers' ),
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'title_typo',
				'label'    => esc_html__( 'Title Typography', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .theme-feature-box__title',
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'content_typo',
				'label'    => esc_html__( 'Content Typography', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .theme-feature-box__text',
			),
			array(
				'mode' => 'section_end',
			),
		);

		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		$template = 'view';

		return $this->wpwax_template( $template, $data );
	}
}