<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

$attr = '';

if ( ! empty( $data['url']['url'] ) ) {
	$attr = 'href="' . $data['url']['url'] . '"';
	$attr .= ! empty( $data['url']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= ! empty( $data['url']['nofollow'] ) ? ' rel="nofollow"' : '';
	$title = '<a ' . $attr . '>' . $data['title'] . '</a>';

	if ( $data['icontype'] == 'image' ) {
		$icon = wp_get_attachment_image( $data['image']['id'], 'full' );
		$icon = '<a ' . $attr . '>' . $icon . '</a>';
	} else {
		$icon = '<i class="' . $data['icon'] . '" aria-hidden="true"></i>';
		$icon = '<a ' . $attr . '>' . $icon . '</a>';
	}

} else {
	$title = $data['title'];

	if ( $data['icontype'] == 'image' ) {
		$icon = \wpWax\Theme\Lib\SVG\WP_SVG::get_attachment_image( $data['image']['id'], 'full' );
	} else {
		$icon = '<i class="' . $data['icon'] . '" aria-hidden="true"></i>';
	}

}
?>
<div class="theme-feature-box">

	<div class="theme-feature-box__icon"><?php echo $icon; ?></div>

	<div class="theme-feature-box-content">

		<h4 class="theme-feature-box__title"><?php echo wp_kses_post( $title ); ?></h4>

		<?php if ( $data['content'] ): ?>

			<p class="theme-feature-box__text"><?php echo wp_kses_post( $data['content'] ); ?></p>

		<?php endif; ?>

	</div>
	
</div>