<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\Theme\Elementor;

use Directorist\Helper;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class All_Locations extends Custom_Widget_Base {

	public function __construct( $data = array(), $args = null ) {
		$this->wpwax_name = esc_html__( 'Listing Locations', 'dlawyers' );
		$this->wpwax_base = 'wpwaxtheme-all-locations';
		parent::__construct( $data, $args );
	}

	private function az_listing_locations() {
		$result    = array();
		$locations = get_terms( ATBDP_LOCATION );
		foreach ( $locations as $location ) {
			$result[$location->slug] = $location->name;
		}

		return $result;
	}

	private function az_listing_types() {
		$listing_types = array();
		$all_types     = get_terms( array( 'taxonomy' => ATBDP_TYPE, 'hide_empty' => false ) );

		foreach ( $all_types as $type ) {
			$listing_types[$type->slug] = $type->name;
		}

		return $listing_types;
	}

	public function wpwax_fields() {
		$fields = array(
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_general',
				'label' => esc_html__( 'General', 'dlawyers' ),
			),
			array(
				'type'      => Controls_Manager::SELECT2,
				'id'        => 'type',
				'label'     => esc_html__( 'Directory Types', 'dlawyers' ),
				'multiple'  => true,
				'options'   => $this->az_listing_types(),
				'condition' => Helper::multi_directory_enabled() ? '' : array( 'nocondition' => true ),
			),
			array(
				'type'      => Controls_Manager::SELECT2,
				'id'        => 'default_type',
				'label'     => esc_html__( 'Default Directory Types', 'dlawyers' ),
				'options'   => $this->az_listing_types(),
				'condition' => Helper::multi_directory_enabled() ? '' : array( 'nocondition' => true ),
			),
			array(
				'type'    => Controls_Manager::SELECT,
				'id'      => 'view',
				'label'   => esc_html__( 'View As', 'dlawyers' ),
				'options' => array(
					'grid' => esc_html__( 'Grid View', 'dlawyers' ),
					'list' => esc_html__( 'List View', 'dlawyers' ),
				),
				'default' => 'grid',
			),
			array(
				'type'      => Controls_Manager::SELECT,
				'id'        => 'style',
				'label'     => esc_html__( 'Design', 'dlawyers' ),
				'options'   => array(
					'style-1' => esc_html__( 'Style 1', 'dlawyers' ),
					'style-2' => esc_html__( 'Style 2', 'dlawyers' ),
				),
				'default'   => 'style-2',
				'condition' => array( 'view' => array( 'grid' ) ),
			),
			array(
				'type'      => Controls_Manager::SELECT,
				'id'        => 'columns',
				'label'     => esc_html__( 'Locations Per Row', 'dlawyers' ),
				'options'   => array(
					'2' => esc_html__( '2 Items / Row', 'dlawyers' ),
					'3' => esc_html__( '3 Items / Row', 'dlawyers' ),
					'4' => esc_html__( '4 Items / Row', 'dlawyers' ),
					'5' => esc_html__( '5 Items / Row', 'dlawyers' ),
					'6' => esc_html__( '6 Items / Row', 'dlawyers' ),
				),
				'default'   => '3',
				'condition' => array( 'view' => array( 'grid' ), 'style' => array( 'style-1' ) ),
			),

			array(
				'type'    => Controls_Manager::SELECT,
				'id'      => 'order_by',
				'label'   => esc_html__( 'Order by', 'dlawyers' ),
				'options' => array(
					'id'    => esc_html__( 'ID', 'dlawyers' ),
					'count' => esc_html__( 'Count', 'dlawyers' ),
					'name'  => esc_html__( 'Name', 'dlawyers' ),
					'slug'  => esc_html__( 'Slug', 'dlawyers' ),
				),
				'default' => 'slug',
			),
			array(
				'type'      => Controls_Manager::SELECT2,
				'id'        => 'slug',
				'label'     => esc_html__( 'Specify Locations', 'dlawyers' ),
				'multiple'  => true,
				'options'   => $this->az_listing_locations(),
				'condition' => array( 'order_by' => array( 'slug' ) ),
			),
			array(
				'type'    => Controls_Manager::SELECT,
				'id'      => 'order_list',
				'label'   => esc_html__( 'Listings Order', 'dlawyers' ),
				'options' => array(
					'asc'  => esc_html__( ' ASC', 'dlawyers' ),
					'desc' => esc_html__( ' DESC', 'dlawyers' ),
				),
				'default' => 'desc',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number_loc',
				'label'   => esc_html__( 'Number of Locations to Show', 'dlawyers' ),
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
				'default' => 6,
			),
			array(
				'mode' => 'section_end',
			),
		);

		return $fields;
	}

	public function dlawyers_directorist_column_key( $col_key_array ) {

		$col_md_6 = in_array( $col_key_array['key'], array( 0, 5, 6, 11, 12, 17, 18, 23, 24, 29, 30, 35, 36, 41, 42, 47, 48, 53 ) );

		if ( $col_md_6 ) {
			$col_key_array['columns'] = ' col-md-6';
		} else {
			$col_key_array['columns'] = ' col-lg-3 col-md-6';
		}

		return $col_key_array;
	}

	public function dlawyers_directorist_grid_count_html( $count_html ) {
		$text_html  = sprintf( '<span class="count"> %s</span>', esc_html__( 'listings', 'dlawyers' ) );
		$count_html = str_replace( array( '(', ')' ), array( '', $text_html ), $count_html );

		return $count_html;

	}

	protected function render() {
		$data = $this->get_settings_for_display();

		$atts = array(
			'view'         => $data['view'],
			'columns'      => $data['columns'],
			'loc_per_page' => $data['number_loc'],
			'orderby'      => $data['order_by'],
			'order'        => $data['order_list'],
			'slug'         => $data['slug'] ? implode( ',', $data['slug'] ) : '',
		);

		if ( Helper::multi_directory_enabled() ) {

			if ( $data['type'] ) {
				$atts['directory_type'] = implode( ',', $data['type'] );
			}

			if ( $data['default_type'] ) {
				$atts['default_directory_type'] = $data['default_type'];
			}
		}

		add_filter( 'dlawyers_directorist_grid_count_html', array( $this, 'dlawyers_directorist_grid_count_html' ) );

		if ( 'style-2' === $data['style'] ) {
			add_filter( 'dlawyers_directorist_column_key', array( $this, 'dlawyers_directorist_column_key' ) );
		}

		$this->wpwax_run_shortcode( 'directorist_all_locations', $atts );
	}
}