<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\Theme\Elementor;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Post extends Custom_Widget_Base {

	public function __construct( $data = array(), $args = null ) {
		$this->wpwax_name = esc_html__( 'Post', 'dlawyers' );
		$this->wpwax_base = 'wpwax-post';
		parent::__construct( $data, $args );
	}

	private function wpwax_query( $data ) {
		$args = array(
			'cat'                 => (int) $data['cat'],
			'orderby'             => $data['orderby'],
			'posts_per_page'      => $data['number_of_post'],
			'post_status'         => 'publish',
			'suppress_filters'    => false,
			'ignore_sticky_posts' => true,
		);

		switch ( $data['orderby'] ) {
			case 'title':
			case 'menu_order':
				$args['order'] = 'ASC';
				break;
		}

		return new \WP_Query( $args );
	}

	public function wpwax_fields() {

		$categories        = get_categories();
		$category_dropdown = array( '0' => esc_html__( 'All Categories', 'dlawyers' ) );

		foreach ( $categories as $category ) {
			$category_dropdown[$category->term_id] = $category->name;
		}

		$fields = array(

			// General Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_general',
				'label' => esc_html__( 'General', 'dlawyers' ),
			),
			array(
				'type'        => Controls_Manager::NUMBER,
				'id'          => 'number_of_post',
				'label'       => esc_html__( 'Post Limit', 'dlawyers' ),
				'default'     => 3,
				'description' => esc_html__( 'Maximum number of post to display', 'dlawyers' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'number_of_columns',
				'label'   => esc_html__( 'Number of Columns', 'dlawyers' ),
				'options' => array(
					'2' => esc_html__( '6', 'dlawyers' ),
					'3' => esc_html__( '4', 'dlawyers' ),
					'4' => esc_html__( '3', 'dlawyers' ),
					'6' => esc_html__( '2', 'dlawyers' ),
				),
				'default' => 4,

			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'cat',
				'label'   => esc_html__( 'Categories', 'dlawyers' ),
				'options' => $category_dropdown,
				'default' => '0',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'orderby',
				'label'   => esc_html__( 'Order By', 'dlawyers' ),
				'options' => array(
					'date'       => esc_html__( 'Date (Recents comes first)', 'dlawyers' ),
					'title'      => esc_html__( 'Title', 'dlawyers' ),
					'menu_order' => esc_html__( 'Custom Order (Available via Order field inside Page Attributes box)', 'dlawyers' ),
				),
				'default' => 'date',
			),
			array(
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'id'        => 'show_excpert',
				'label'     => esc_html__( 'Show Excpert', 'dlawyers' ),
				'label_on'  => esc_html__( 'Show', 'dlawyers' ),
				'label_off' => esc_html__( 'Hide', 'dlawyers' ),
				'default'   => 'yes',
			),
			array(
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'id'        => 'show_date',
				'label'     => esc_html__( 'Show Date', 'dlawyers' ),
				'label_on'  => esc_html__( 'Show', 'dlawyers' ),
				'label_off' => esc_html__( 'Hide', 'dlawyers' ),
				'default'   => 'yes',
			),
			array(
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'id'        => 'show_category',
				'label'     => esc_html__( 'Show Category', 'dlawyers' ),
				'label_on'  => esc_html__( 'Show', 'dlawyers' ),
				'label_off' => esc_html__( 'Hide', 'dlawyers' ),
				'default'   => 'yes',
			),
			array(
				'mode' => 'section_end',
			),

			// Color Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_color',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Color', 'dlawyers' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'title_color',
				'label'     => esc_html__( 'Title', 'dlawyers' ),
				'default'   => '',
				'selectors' => array( '{{WRAPPER}} .theme-blog-title a' => 'color: {{VALUE}}' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'title_color_hover',
				'label'     => esc_html__( 'Title Hover', 'dlawyers' ),
				'default'   => '',
				'selectors' => array( '{{WRAPPER}} .theme-blog-title:hover a' => 'color: {{VALUE}}' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'excpert_color',
				'label'     => esc_html__( 'Excpert', 'dlawyers' ),
				'default'   => '',
				'selectors' => array( '{{WRAPPER}} .theme-blog-summary p' => 'color: {{VALUE}}' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'blog_meta_color',
				'label'     => esc_html__( 'Blog Meta', 'dlawyers' ),
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .theme-blog-each .theme-blog-content-area .theme-blog-meta .theme-blog-meta-list ul li a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .theme-blog-each .theme-blog-content-area .theme-blog-meta .theme-blog-meta-list ul li a' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'blog_meta_color_hover',
				'label'     => esc_html__( 'Blog Meta Hover', 'dlawyers' ),
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .theme-blog-each .theme-blog-content-area .theme-blog-meta .theme-blog-meta-list ul li a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .theme-blog-each .theme-blog-content-area .theme-blog-meta .theme-blog-meta-list ul li a:hover' => 'color: {{VALUE}}',
				),
			),
			array(
				'mode' => 'section_end',
			),

			// Typography Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_typo',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Typography', 'dlawyers' ),
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'title_typo',
				'label'    => esc_html__( 'Title', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .theme-blog-title a',
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'excpert_typo',
				'label'    => esc_html__( 'Excpert', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .theme-blog-summary p',
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'blog_meta_typo',
				'label'    => esc_html__( 'Blog Meta ', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .theme-blog-each .theme-blog-content-area .theme-blog-meta .theme-blog-meta-list ul li a, {{WRAPPER}} .theme-blog-each .theme-blog-content-area .theme-blog-meta .theme-blog-meta-list ul li span',
			),
			array(
				'mode' => 'section_end',
			),

		);

		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		$data['query'] = $this->wpwax_query( $data );

		$template = 'view';

		return $this->wpwax_template( $template, $data );
	}
}