<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

use wpWax\dLawyers\Helper;

$thumb_size = 'wpwaxtheme-size2';
$query      = $data['query'];
$columns    = $data['number_of_columns'];

if ( $query->have_posts() ): ?>
	
	<div class="row">
		
		<?php 
		while ( $query->have_posts() ): 
			$query->the_post(); 
			$get_cat_ob = get_the_category();
			?>

			<div class="col-md-<?php echo esc_attr( $columns ); ?> col-12">

				<div <?php post_class( 'theme-blog-each' ); ?>>

					<div class="theme-blog-thumbnail">
						<div class="theme-blog-img">
							
							<?php if ( has_post_thumbnail() ): ?>

							<a class="theme-thumb" href="<?php the_permalink(); ?>"><?php the_post_thumbnail( $thumb_size ); ?></a>

							<?php else: ?>

							<a class="theme-thumb" href="<?php the_permalink(); ?>">

								<img alt="<?php echo get_the_title(); ?>" src="<?php echo Helper::get_img( 'nothumb.png' ); ?>">

							</a>

							<?php endif; ?>
						</div>

						<div class="theme-blog-content-area">

							<div class="theme-blog-content">

								<h4 class="theme-blog-title">

									<a href="<?php the_permalink(); ?>" class="entry-title" rel="bookmark"><?php the_title(); ?></a>

								</h4>

								<?php if ( $data['show_excpert'] ): ?>

									<div class="theme-blog-summary entry-summary"><?php the_excerpt(); ?></div>

								<?php endif; ?>

							</div>

							<?php if ( $data['show_date'] || $data['show_category'] ): ?>

								<div class="theme-blog-meta">

									<div class="theme-blog-meta-list">

										<ul>

											<?php if ( $data['show_date'] ): ?>

												<li class="theme-blog-date"><a href="<?php echo get_the_permalink(); ?>"><?php the_time( get_option( 'date_format' ) ); ?></a></li>

											<?php endif;?>

											<?php if ( $data['show_category'] ): ?>

												<li class="theme-blog-category-meta">
													
													<?php if ( ! empty( $get_cat_ob ) ) {

													$term_link	= isset(  $get_cat_ob[0] ) ? get_category_link( $get_cat_ob[0]->cat_ID ) : '';
													$cat_name	= isset( $get_cat_ob[0] ) ? $get_cat_ob[0]->name : '';
													$total_term	= count( $get_cat_ob );
													
													printf('<span class="theme-blog-category-meta-label">%s</span>', esc_html__( 'In', 'dlawyers' ) );
													printf( '<a href="%s">%s</a>', esc_url( $term_link ) , esc_html( $cat_name ) );

													if ( $total_term > 1 ) {
														$total_term = $total_term - 1; 
														?>

														<div class="theme-blog-category-meta__popup">

															<?php printf( '<span class="theme-blog-category-meta__extran-count">%s %s</span>', esc_html( '+', 'dlawyers' ), esc_html( $total_term ) ); ?>
															
															<div class="theme-blog-category-meta__popup__content">
																
																<?php 
																foreach ( array_slice($get_cat_ob, 1) as $cat ) {
																	$term_label = trim( "{$cat->name}" );
																	$term_link  = get_category_link( $cat->cat_ID);;

																	echo "<a href='{$term_link}'>{$term_label}</a>";
																}
																?>

															</div>

														</div>

													<?php }
													}
												?>
												
												</li>
												
											<?php endif; ?>

										</ul>

									</div>

								</div>

							<?php endif; ?>

						</div>

					</div>

				</div>

			</div>

		<?php endwhile; ?>
		
	</div>

<?php else: ?>

	<div><?php esc_html_e( 'Currently there are no posts', 'dlawyers' ); ?></div>

<?php endif; ?>

<?php wp_reset_postdata(); ?>