<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\Theme\Elementor;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Single_Location_Box extends Custom_Widget_Base {

	public function __construct( $data = array(), $args = null ) {
		$this->wpwax_name = esc_html__( 'Single Location Box', 'dlawyers' );
		$this->wpwax_base = 'wpwaxtheme-single-location-box';
		parent::__construct( $data, $args );
	}

	private function wpwax_listing_locations() {
		$result    = array();
		$locations = get_terms( ATBDP_LOCATION );
		foreach ( $locations as $location ) {
			$result[$location->slug] = $location->name;
		}

		return $result;
	}

	public function wpwax_fields() {
		$fields = array(
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_general',
				'label' => esc_html__( 'General', 'dlawyers' ),
			),
			array(
				'type'     => Controls_Manager::SELECT,
				'id'       => 'location',
				'label'    => esc_html__( 'Select Location', 'dlawyers' ),
				'multiple' => true,
				'options'  => $this->wpwax_listing_locations(),
			),

			array(
				'type'      => Controls_Manager::CHOOSE,
				'id'        => 'content_alginment',
				'label'     => esc_html__( 'Alignment', 'dlawyers' ),
				'options'   => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'dlawyers' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'dlawyers' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'dlawyers' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'default'   => 'center',
				'toggle'    => true,
				'selectors' => array(
					'{{WRAPPER}} .theme-cat-box__header' => 'justify-content: {{VALUE}}',
					'{{WRAPPER}} .theme-cat-box'         => 'text-align: {{VALUE}}',
					'{{WRAPPER}} .theme-sub-cats'        => 'text-align: {{VALUE}}',
				),
				'condition' => array(
					'style' => array( 'style-2' ),
					'view'  => array( 'grid' ),
				),
			),

			array(
				'mode' => 'section_end',
			),

			// Color Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_color',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Color', 'dlawyers' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'title_color',
				'label'     => esc_html__( 'Title/Count', 'dlawyers' ),
				'selectors' => array(
					'{{WRAPPER}} .atbd_location_grid_wrap:not(.atbd_location_grid-default) .atbd_location_grid figure figcaption h3' => 'color: {{color}};',
					'{{WRAPPER}} .atbd_location_grid_wrap:not(.atbd_location_grid-default) .atbd_location_grid figure figcaption p'  => 'color: {{color}};',
				),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'title_color_hover',
				'label'     => esc_html__( 'Title/Count Hover', 'dlawyers' ),
				'selectors' => array(
					'{{WRAPPER}} .atbd_location_grid_wrap:not(.atbd_location_grid-default) .atbd_location_grid:hover figure figcaption h3' => 'color: {{color}};',
					'{{WRAPPER}} .atbd_location_grid_wrap:not(.atbd_location_grid-default) .atbd_location_grid:hover figure figcaption p'  => 'color: {{color}};',
				),
			),
			array(
				'mode' => 'section_end',
			),

			// Typography Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_typography',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Typography', 'dlawyers' ),
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'title_typo',
				'label'    => esc_html__( 'location Title', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .atbd_location_grid_wrap:not(.atbd_location_grid-default) .atbd_location_grid figure figcaption h3',
			),
			array(
				'mode' => 'section_end',
			),
		);

		return $fields;
	}

	protected function render() {
		$data                 = $this->get_settings();
		$template             = 'view';
		$location             = get_term_by( 'slug', $data['location'], ATBDP_LOCATION );
		$data['location_obj'] = $location;

		return $this->wpwax_template( $template, $data );
	}
}