<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

if ( ! isset( $data['location_obj'] ) || empty( $data['location_obj'] ) ) {
	return;
}
$location      = $data['location_obj'];
$permalink     = get_term_link( $location->slug, $location->taxonomy );
$image_id      = get_term_meta( $location->term_id, 'image', true );
$image_url     = atbdp_get_image_source( $image_id );
$loc_class     = $image_url ? '' : ' atbd_location_grid-default';
$listing_count = atbdp_listings_count_by_location( $location->term_id );
$count_html	   = '';

if ( $listing_count ) {
	$tax               = ATBDP_LOCATION;
	$expired_listings  = atbdp_get_expired_listings( $tax, $location->term_id );
	$number_of_expired = $expired_listings->post_count;
	$number_of_expired = ! empty( $number_of_expired ) ? $number_of_expired : '0';
	$total             = ( $listing_count ) ? ( $listing_count - $number_of_expired ) : $listing_count;
	$count_html		   = sprintf( '<p>%s %s</p>', $total, ( ( $total > 1 ) || ( $total == 0 ) ) ? esc_html__( 'listings', 'dlawyers' ) : esc_html__( 'listing', 'dlawyers' ) );	
}
?>

<div class="atbd_location_grid_wrap atbdp-no-margin">

	<a class="atbd_location_grid<?php echo esc_attr( $loc_class ); ?>" href="<?php echo esc_url( $permalink ); ?>">

		<figure>

			<?php if ( $image_url ): ?>

				<img src="<?php echo esc_url( $image_url ); ?>" title="<?php echo esc_attr( $location->name ); ?>" alt="<?php echo esc_attr( $location->name ); ?>">

			<?php endif;?>

			<figcaption>

				<h3><?php echo esc_html( $location->name ); ?></h3>

				<?php echo wp_kses_post( apply_filters( 'dlawyers_directorist_grid_count_html', $count_html ) ); ?>

			</figcaption>

		</figure>

	</a>

</div>