<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\Theme\Elementor;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Team_Member extends Custom_Widget_Base {

	public function __construct( $data = array(), $args = null ) {
		$this->wpwax_name = esc_html__( 'Team Member', 'dlawyers' );
		$this->wpwax_base = 'wpwax-team-member';
		parent::__construct( $data, $args );
	}

	public function wpwax_fields() {
		$fields = array(

			// General Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_general',
				'label' => esc_html__( 'General', 'dlawyers' ),
			),

			array(
				'type'        => Controls_Manager::MEDIA,
				'id'          => 'team_image',
				'label'       => esc_html__( 'Image', 'dlawyers' ),
				'description' => __( 'Recommended image size is 100x100 px.<br/>You can upload SVG format as well, to get SVG images click here: <a target="_blank" href="https://www.flaticon.com/">flaticon.com</a>', 'dlawyers' ),
				'default'     => array(
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				),
			),
			array(
				'id'         => 'image_size',
				'label'      => esc_html__( 'Max Width', 'dlawyers' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 1000,
						'step' => 5,
					),
					'%'  => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'default'    => array(
					'unit' => '%',
					'size' => 100,
				),
				'selectors'  => array(
					'{{WRAPPER}} img' => 'max-width: {{SIZE}}{{UNIT}};',
				),
			),
			array(
				'id'         => 'image_border_radius',
				'label'      => esc_html__( 'Border Radius', 'dlawyers' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'name',
				'label'   => esc_html__( 'Name', 'dlawyers' ),
				'default' => __( 'John Doe', 'dlawyers' ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'designation',
				'label'   => esc_html__( 'Designation', 'dlawyers' ),
				'default' => __( 'Founder & CEO', 'dlawyers' ),
			),
			array(
				'type'      => Controls_Manager::CHOOSE,
				'id'        => 'content_alginment',
				'label'     => esc_html__( 'Alignment', 'dlawyers' ),
				'options'   => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'dlawyers' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'dlawyers' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'dlawyers' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'default'   => 'center',
				'toggle'    => true,
				'selectors' => array(
					'{{WRAPPER}} .theme-team-single__img' => 'text-align: {{VALUE}}',
					'{{WRAPPER}} figcaption'              => 'text-align: {{VALUE}}',
				),
			),
			array(
				'mode' => 'section_end',
			),

			// Color Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_style',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Color', 'dlawyers' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'name_color',
				'label'     => esc_html__( 'Name', 'dlawyers' ),
				'selectors' => array(
					'{{WRAPPER}} .theme-team-single__title' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'name_hover_color',
				'label'     => esc_html__( 'Name Hover', 'dlawyers' ),
				'selectors' => array(
					'{{WRAPPER}}:hover .theme-team-single__title' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'designation_color',
				'label'     => esc_html__( 'Designation', 'dlawyers' ),
				'selectors' => array(
					'{{WRAPPER}} .theme-team-single__paragraph' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'designation_color_hover',
				'label'     => esc_html__( 'Designation Hover', 'dlawyers' ),
				'selectors' => array(
					'{{WRAPPER}}:hover .theme-team-single__paragraph' => 'color: {{VALUE}}',
				),
			),
			array(
				'mode' => 'section_end',
			),

			// Typography Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_typography',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Typography', 'dlawyers' ),
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'name_typo',
				'label'    => esc_html__( 'Title', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .theme-team-single__title',
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'designation_typo',
				'label'    => esc_html__( 'Designation', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .theme-team-single__paragraph',
			),
			array(
				'mode' => 'section_end',
			),
		);

		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		$template = 'view';

		return $this->wpwax_template( $template, $data );
	}
}