<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

$attr = '';
$name = $data['name'] ? $data['name'] : '';

if ( $data['team_image']['url'] ) {
	$team_image = sprintf( '<img src="%s">', $data['team_image']['url'] );

} else if( isset( $data['team_image']['id'] ) ) {
	$team_image = \wpWax\Theme\Lib\SVG\WP_SVG::get_attachment_image( $data['team_image']['id'], 'full' );
} else {
	$team_image = '';
}
?>
<div class="theme-team-single">

	<figure>

		<div class="theme-team-single__img">

			<?php echo $team_image; ?>

		</div>

		<figcaption>

			<h6 class="theme-team-single__title"><?php echo wp_kses_post( $name ); ?></h6>

			<?php if ( $data['designation'] ): ?>

				<p class="theme-team-single__paragraph"><?php echo wp_kses_post( $data['designation'] ); ?></p>

			<?php endif;?>

		</figcaption>

	</figure>
	
</div>