<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\Theme\Elementor;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Testimonial extends Custom_Widget_Base {

	public function __construct( $data = array(), $args = null ) {
		$this->wpwax_name = esc_html__( 'Testimonial Carousel', 'dlawyers' );
		$this->wpwax_base = 'wpwaxtheme-testimonial-carousel';
		parent::__construct( $data, $args );
	}

	private function wpwax_load_scripts() {
		wp_enqueue_style( 'tiny-slider' );
		wp_enqueue_script( 'tiny-slider' );
	}

	private function get_repeater() {
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'name', array(
				'label'       => esc_html__( 'Name', 'dlawyers' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => esc_html__( 'John Doe', 'dlawyers' ),
				'label_block' => true,
			)
		);

		$repeater->add_control(
			'location', array(
				'label'      => esc_html__( 'Location', 'dlawyers' ),
				'type'       => \Elementor\Controls_Manager::TEXT,
				'default'    => esc_html__( 'Toronto, Canada', 'dlawyers' ),
				'show_label' => false,
			)
		);

		$repeater->add_control(
			'content', array(
				'label'      => esc_html__( 'Content', 'dlawyers' ),
				'type'       => \Elementor\Controls_Manager::WYSIWYG,
				'default'    => esc_html__( 'Lorem Ipsum has been standard daand scrambled. Rimply dummy text of the printing and typesetting industry', 'dlawyers' ),
				'show_label' => false,
			)
		);

		$repeater->add_control(
			'image', array(
				'label'      => esc_html__( 'Thumbnail', 'dlawyers' ),
				'type'  => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			)
		);

		return $repeater;
	}

	public function wpwax_fields() {
		$fields = array(

			// General Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_general',
				'label' => esc_html__( 'General', 'dlawyers' ),
			),
			array(
				'type'   => Controls_Manager::REPEATER,
				'id'     => 'items',
				'label'  => esc_html__( 'Add as many items as you want', 'dlawyers' ),
				'fields' => $this->get_repeater()->get_controls(),
			),
			array(
				'mode' => 'section_end',
			),

			// Slider Options Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_slider',
				'label' => esc_html__( 'Slider Options', 'dlawyers' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_autoplay',
				'label'       => esc_html__( 'Autoplay', 'dlawyers' ),
				'label_on'    => esc_html__( 'On', 'dlawyers' ),
				'label_off'   => esc_html__( 'Off', 'dlawyers' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Enable or disable autoplay. Default: On', 'dlawyers' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_stop_on_hover',
				'label'       => esc_html__( 'Stop on Hover', 'dlawyers' ),
				'label_on'    => esc_html__( 'On', 'dlawyers' ),
				'label_off'   => esc_html__( 'Off', 'dlawyers' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Stop autoplay on mouse hover. Default: On', 'dlawyers' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'        => Controls_Manager::SELECT2,
				'id'          => 'slider_interval',
				'label'       => esc_html__( 'Autoplay Interval', 'dlawyers' ),
				'options'     => array(
					'5000' => esc_html__( '5 Seconds', 'dlawyers' ),
					'4000' => esc_html__( '4 Seconds', 'dlawyers' ),
					'3000' => esc_html__( '3 Seconds', 'dlawyers' ),
					'2000' => esc_html__( '2 Seconds', 'dlawyers' ),
					'1000' => esc_html__( '1 Second', 'dlawyers' ),
				),
				'default'     => '5000',
				'description' => esc_html__( 'Set any value for example 5 seconds to play it in every 5 seconds. Default: 5 Seconds', 'dlawyers' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'        => Controls_Manager::NUMBER,
				'id'          => 'slider_autoplay_speed',
				'label'       => esc_html__( 'Autoplay Slide Speed', 'dlawyers' ),
				'default'     => 200,
				'description' => esc_html__( 'Slide speed in milliseconds. Default: 200', 'dlawyers' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_loop',
				'label'       => esc_html__( 'Loop', 'dlawyers' ),
				'label_on'    => esc_html__( 'On', 'dlawyers' ),
				'label_off'   => esc_html__( 'Off', 'dlawyers' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Loop to first item. Default: On', 'dlawyers' ),
			),
			array(
				'mode' => 'section_end',
			),

			// Color Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_style',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Color', 'dlawyers' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'name_color',
				'label'     => esc_html__( 'Name', 'dlawyers' ),
				'selectors' => array( '{{WRAPPER}} .theme-testimonial-single__author-info .cite-title' => 'color: {{VALUE}}' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'location_color',
				'label'     => esc_html__( 'Location', 'dlawyers' ),
				'selectors' => array( '{{WRAPPER}} .theme-testimonial-single__author-info .cite-subtitle' => 'color: {{VALUE}}' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'content_color',
				'label'     => esc_html__( 'Content', 'dlawyers' ),
				'selectors' => array( '{{WRAPPER}} .theme-testimonial-single__author-comment' => 'color: {{VALUE}}' ),
			),
			array(
				'mode' => 'section_end',
			),

			// Typography Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_typography',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Typography', 'dlawyers' ),
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'name_typo',
				'label'    => esc_html__( 'Name', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .theme-testimonial-single__author-info .cite-title',
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'location_typo',
				'label'    => esc_html__( 'Location', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .theme-testimonial-single__author-info .cite-subtitle',
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'content_typo',
				'label'    => esc_html__( 'Content', 'dlawyers' ),
				'selector' => '{{WRAPPER}} .theme-testimonial-single__author-comment',
			),
			array(
				'mode' => 'section_end',
			),
		);

		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		$tiny_data = array(
			'nav'                  => false,
			'dots'                 => false,
			'items'                => 1,
			'slideBy'              => 'page',
			'autoplayButtonOutput' => false,
			'mouseDrag'            => true,
			'lazyload'             => true,
			'controlsContainer'    => "#theme-testimonial__nav",
			'navText'              => array( "<i class='themeicon themeicon-angle-left-solid'></i>", "<i class='themeicon themeicon-angle-right-solid'></i>" ),
			'autoplay'             => false,
			'autoplayTimeout'      => $data['slider_interval'],
			'autoplaySpeed'        => $data['slider_autoplay_speed'],
			'autoplayHoverPause'   => $data['slider_stop_on_hover'] == 'yes' ? true : false,
			'loop'                 => $data['slider_loop'] == 'yes' ? true : false,
			'margin'               => 20,
			'responsive'           => array(
				'0' => array( 'items' => 1 ),
			),
		);

		$data['tiny_data'] = json_encode( $tiny_data );
		$this->wpwax_load_scripts();

		$template = 'view';

		return $this->wpwax_template( $template, $data );
	}
}