<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

use wpWax\dLawyers\Helper;

?>
<div class="theme-swiper-slider theme-testimonial-slider">

	<div class="theme-swiper-slider__top">		
		<div class="theme-swiper-button-nav-wrap">
			<div class="theme-swiper-button-nav theme-swiper-button-prev"><?php directorist_icon( 'las la-angle-left' ) ?></div>
			<div class="theme-swiper-button-nav theme-swiper-button-next"><?php directorist_icon( 'las la-angle-right' ) ?></div>
		</div>
	</div>

	<div class="theme-swiper theme-testimonial-slider__sliding" data-sw-items="1" data-sw-margin="24" data-sw-loop="true" data-sw-perslide="1" data-sw-speed="1000" data-sw-autoplay="{}" data-sw-responsive='{}'>
		<div class="swiper-wrapper">
			<?php foreach ( $data['items'] as $item ): ?>

				<div class="swiper-slide item">

					<div class="theme-testimonial-single">

						<?php if ( $item['image'] ): ?>

							<div class="theme-testimonial-single__author-thumb">

								<?php echo wp_get_attachment_image( $item['image']['id'], 'thumbnail' ); ?>

							</div>

						<?php endif;?>

						<div class="theme-testimonial-single__author">

							<p class="theme-testimonial-single__author-comment"><?php echo wp_kses_post( $item['content'] ); ?></p>

							<div class="theme-testimonial-single__author-info">

								<blockquote class="theme-testimonial-blockquote blockquote">

									<footer class="theme-testimonial-blockquote__footer blockquote-footer">

										<cite title="source Title">

											<span class="cite-title"><?php echo esc_html( $item['name'] ); ?></span>
											
											<?php if ( $item['location'] ): ?>

												<span class="cite-subtitle"><?php echo esc_html( $item['location'] ); ?></span>

											<?php endif; ?>

										</cite>

										<span class="theme-testimonial-blockquote__quote">

											<span class="img-svg">

												<img class="svg" src="<?php echo Helper::get_img('quote.svg') ?>" alt="img">	

											</span>

										</span>

									</footer>

								</blockquote>

							</div>

						</div>

					</div>

				</div>

			<?php endforeach; ?>

			</div>
	</div>
	
</div>