<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

use \wpWax\dLawyers\Helper;
use \wpWax\dLawyers\Theme;

if ( empty( Theme::$options['post_share'] ) ) {
	return;
}


$selected = Theme::$options['post_share'];
$url      = urlencode( get_permalink() );
$title    = urlencode( get_the_title() );
$sharers  = array();

$all = array(
	'facebook'  => array(
		'url'   => "//www.facebook.com/sharer.php?u=$url",
		'icon'  => Helper::get_svg_icon( 'facebook' ),
		'label' => __( 'Share', 'dlawyers' ),
		'class' => __( 'facebook', 'dlawyers' ),
	),
	'twitter'   => array(
		'url'   => "//twitter.com/intent/tweet?source=$url&text=$title:$url",
		'icon'  => Helper::get_svg_icon( 'twitter' ),
		'label' => __( 'Tweet', 'dlawyers' ),
		'class' => __( 'twitter', 'dlawyers' ),
	),
	'linkedin'  => array(
		'url'   => "//www.linkedin.com/shareArticle?mini=true&url=$url&title=$title",
		'icon'  => Helper::get_svg_icon( 'linkedin' ),
		'label' => __( 'Share', 'dlawyers' ),
		'class' => __( 'linkedin', 'dlawyers' ),
	),
	'pinterest' => array(
		'url'   => "//pinterest.com/pin/create/button/?url=$url&description=$title",
		'icon'  => Helper::get_svg_icon( 'pinterest' ),
		'label' => __( 'Share', 'dlawyers' ),
		'class' => __( 'pinterest', 'dlawyers' ),
	),
	'tumblr'    => array(
		'url'   => "//www.tumblr.com/share?v=3&u=$url&quote=$title",
		'icon'  => Helper::get_svg_icon( 'tumblr' ),
		'label' => __( 'Share', 'dlawyers' ),
		'class' => __( 'tumblr', 'dlawyers' ),
	),
	'reddit'    => array(
		'url'   => "//www.reddit.com/submit?url=$url&title=$title",
		'icon'  => Helper::get_svg_icon( 'reddit' ),
		'label' => __( 'Share', 'dlawyers' ),
		'class' => __( 'reddit', 'dlawyers' ),
	),
	'vk'        => array(
		'url'   => "//vkontakte.ru/share.php?url=$url",
		'icon'  => Helper::get_svg_icon( 'vk' ),
		'label' => __( 'Share', 'dlawyers' ),
		'class' => __( 'vk', 'dlawyers' ),
	),
	'copy_url'  => array(
		'url'   => "$url",
		'icon'  => Helper::get_svg_icon( 'link-solid' ),
		'label' => __( 'Copy', 'dlawyers' ),
		'class' => __( 'copy', 'dlawyers' ),
	),
);

foreach ( $selected as $value ) {
	$sharers[$value] = $all[$value];
}

$sharers = apply_filters( 'wpwaxtheme_social_sharing_icons', $sharers );
?>
<div class="social-share">

	<span class="m-right-15"><?php esc_html_e( 'Share this article:', 'dlawyers' );?></span>

	<ul class="social-share__list list-unstyled">

		<?php foreach ( $sharers as $key => $sharer ): ?>

			<?php if ( 'copy_url' === $key ): ?>

				<li>
					<input type="hidden" value="<?php echo get_permalink(); ?>" id="copyUrl">

					<div class="toolip_wrapper">
						<a href="#" class="theme-post-social-<?php echo esc_html( $sharer['class'] ); ?>" id="copyBtn" data-bs-toggle="tooltip" data-bs-placement="top" title="Copy to clipboard">
							<?php echo $sharer['icon']; ?>
						</a>
					</div>
				</li>

			<?php else: ?>

				<li>
					<a href="<?php echo esc_url( $sharer['url'] ); ?>" class="theme-post-social-<?php echo esc_html( $sharer['class'] ); ?>" target="_blank"><?php echo $sharer['icon']; ?> </a>
				</li>

			<?php endif;?>

		<?php endforeach;?>

	</ul>
	
</div>