<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\dLawyers;

class About_Widget extends \WP_Widget {

	public function __construct() {
		$id = 'dlawyers_about';
		parent::__construct(
            $id, // Base ID
            esc_html__( 'dLawyers: About', 'dlawyers' ), // Name
            array( 'description' => esc_html__( 'dLawyers: About( Footer )', 'dlawyers' ) ) 
		);
	}

	public function widget( $args, $instance ){
		
		echo wp_kses_post( $args['before_widget'] );
		
		if ( ! empty( $instance['title'] ) ) {
			printf( '%s %s %s', wp_kses_post( $args['before_title'] ) , esc_html( $instance['title'] ), wp_kses_post( $args['after_title'] ) );
		}		
		?>

		<div class="aboutwidget">
			
			<?php
				if ( !empty( $instance['logo'] ) ) {
					$html = '';
					$img  = wp_get_attachment_image_src( $instance['logo'], 'full' );
					$img_url = $img[0];
					$html .= '<div class="theme-img"><img src="' . $img_url . '" alt="' . $img_url . '"></div>';
					echo wp_kses_post( $html );
				} 
			?>

			<p class="theme-des"><?php if( !empty( $instance['description'] ) ) echo wp_kses_post( $instance['description'] ); ?></p>

			<div class="social--small">

				<ul class="d-flex flex-wrap">

					<?php
						if( !empty( $instance['facebook'] ) ){
							?><li class="theme-facebook"><a href="<?php echo esc_url( $instance['facebook'] ); ?>" target="_blank"><i class="themeicon themeicon-facebook-square"></i></a></li><?php
						}
						if( !empty( $instance['twitter'] ) ){
							?><li class="theme-twitter"><a href="<?php echo esc_url( $instance['twitter'] ); ?>" target="_blank"><i class="themeicon themeicon-twitter"></i></a></li><?php
						}
						if( !empty( $instance['linkedin'] ) ){
							?><li class="theme-linkedin"><a href="<?php echo esc_url( $instance['linkedin'] ); ?>" target="_blank"><i class="themeicon themeicon-linkedin-in"></i></a></li><?php
						}
						if( !empty( $instance['pinterest'] ) ){
							?><li class="theme-pinterest"><a href="<?php echo esc_url( $instance['pinterest'] ); ?>" target="_blank"><i class="themeicon themeicon-pinterest"></i></a></li><?php
						}
						if( !empty( $instance['instagram'] ) ){
							?><li class="theme-instagram"><a href="<?php echo esc_url( $instance['instagram'] ); ?>" target="_blank"><i class="themeicon themeicon-instagram"></i></a></li><?php
						}
						if( !empty( $instance['youtube'] ) ){
							?><li class="theme-youtube"><a href="<?php echo esc_url( $instance['youtube'] ); ?>" target="_blank"><i class="themeicon themeicon-youtube"></i></a></li><?php
						}
						if( !empty( $instance['rss'] ) ){
							?><li class="theme-rss"><a href="<?php echo esc_url( $instance['rss'] ); ?>" target="_blank"><i class="themeicon themeicon-rss-solid"></i></a></li><?php
						}
						if( !empty( $instance['vimeo'] ) ){
							?><li class="theme-vimeo"><a href="<?php echo esc_url( $instance['vimeo'] ); ?>" target="_blank"><i class="themeicon themeicon-vimeo"></i></a></li><?php
						}
					?>

				</ul>

			</div>

		</div>

		<?php
		echo wp_kses_post( $args['after_widget'] );
	}

	public function update( $new_instance, $old_instance ){
		$instance                  = array();
		$instance['title']         = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
		$instance['logo']          = ( ! empty( $new_instance['logo'] ) ) ? sanitize_text_field( $new_instance['logo'] ) : '';
		$instance['description']   = ( ! empty( $new_instance['description'] ) ) ? wp_kses_post( $new_instance['description'] ) : '';
		$instance['facebook']      = ( ! empty( $new_instance['facebook'] ) ) ? sanitize_text_field( $new_instance['facebook'] ) : '';
		$instance['twitter']       = ( ! empty( $new_instance['twitter'] ) ) ? sanitize_text_field( $new_instance['twitter'] ) : '';
		$instance['linkedin']      = ( ! empty( $new_instance['linkedin'] ) ) ? sanitize_text_field( $new_instance['linkedin'] ) : '';
		$instance['pinterest']     = ( ! empty( $new_instance['pinterest'] ) ) ? sanitize_text_field( $new_instance['pinterest'] ) : '';
		$instance['instagram']     = ( ! empty( $new_instance['instagram'] ) ) ? sanitize_text_field( $new_instance['instagram'] ) : '';
		$instance['youtube']       = ( ! empty( $new_instance['youtube'] ) ) ? sanitize_text_field( $new_instance['youtube'] ) : '';
		$instance['rss']           = ( ! empty( $new_instance['rss'] ) ) ? sanitize_text_field( $new_instance['rss'] ) : '';
		$instance['vimeo']         = ( ! empty( $new_instance['vimeo'] ) ) ? sanitize_text_field( $new_instance['vimeo'] ) : '';
		return $instance;
	}

	public function form( $instance ){
		$defaults = array(
			'title'       => '',
			'logo'        => '',
			'description' => '',
			'facebook'    => '',
			'twitter'     => '',
			'linkedin'    => '',
			'pinterest'   => '',
			'instagram'   => '',
			'youtube'     => '',
			'rss'         => '',
			'vimeo'         => '',
		);
		$instance = wp_parse_args( (array) $instance, $defaults );

		$fields = array(
			'title'       => array(
				'label'   => esc_html__( 'Title', 'dlawyers' ),
				'type'    => 'text',
			),
			'logo'        => array(
				'label'   => esc_html__( 'Logo', 'dlawyers' ),
				'type'    => 'image',
			),
			'description' => array(
				'label'   => esc_html__( 'Description', 'dlawyers' ),
				'type'    => 'textarea',
			),
			'facebook'    => array(
				'label'   => esc_html__( 'Facebook URL', 'dlawyers' ),
				'type'    => 'url',
			),
			'twitter'     => array(
				'label'   => esc_html__( 'Twitter URL', 'dlawyers' ),
				'type'    => 'url',
			),
			'linkedin'    => array(
				'label'   => esc_html__( 'Linkedin URL', 'dlawyers' ),
				'type'    => 'url',
			),
			'pinterest'   => array(
				'label'   => esc_html__( 'Pinterest URL', 'dlawyers' ),
				'type'    => 'url',
			),
			'instagram'   => array(
				'label'   => esc_html__( 'Instagram URL', 'dlawyers' ),
				'type'    => 'url',
			),
			'youtube'    => array(
				'label'   => esc_html__( 'YouTube URL', 'dlawyers' ),
				'type'    => 'url',
			),
			'rss'         => array(
				'label'   => esc_html__( 'Rss Feed URL', 'dlawyers' ),
				'type'    => 'url',
			),
			'vimeo'         => array(
				'label'   => esc_html__( 'Vimeo URL', 'dlawyers' ),
				'type'    => 'url',
			),
		);

		Widget_Fields::display( $fields, $instance, $this );
	}
}