<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\dLawyers;

class Contact_Info extends \WP_Widget {

	public function __construct() {
		$id = 'dlawyers_contact_info';
		parent::__construct(
			$id, // Base ID
			esc_html__( 'dLawyers: Contact Info', 'dlawyers' ), // Name
			array( 'description' => esc_html__( 'dLawyers: Contact Info', 'dlawyers' ) )
		);
	}

	public function widget( $args, $instance ) {
		$phone_title   = $instance['phone_title'] ? $instance['phone_title'] : __( 'Call Now', 'dlawyers' );
		$website_title = $instance['website_title'] ? $instance['website_title'] : __( 'Visit website', 'dlawyers' );
		$address_title = $instance['address_title'] ? $instance['address_title'] : __( 'Address', 'dlawyers' );
		$message       = $instance['message'] ? $instance['message'] : __( 'Message', 'dlawyers' );
		$listing_id    = get_the_ID();
		$author_id     = get_post_field( 'post_author', $listing_id );

		echo wp_kses_post( $args['before_widget'] );
		?>


		<?php printf( '%s %s %s', wp_kses_post( $args['before_title'] ) , esc_html( $instance['title'] ), wp_kses_post( $args['after_title'] ) ); ?>

		<div class="widget-contact-middle">

			<div class="widget-module-content">

				<ul class="widget-contact-parent">

					<?php
					$address  = esc_attr( get_user_meta( $author_id, 'address', true ) );
					$phone    = esc_attr( get_user_meta( $author_id, 'atbdp_phone', true ) );
					$website  = get_the_author_meta( 'user_url', $author_id );
					$facebook = get_user_meta( $author_id, 'atbdp_facebook', true );
					$twitter  = get_user_meta( $author_id, 'atbdp_twitter', true );
					$linkedIn = get_user_meta( $author_id, 'atbdp_linkedin', true );
					$youtube  = get_user_meta( $author_id, 'atbdp_youtube', true );

					if ( isset( $phone ) && ! is_empty_v( $phone ) ): ?>

						<li class="widget-contact-parent__child">
							
							<?php directorist_icon( 'las la-phone' ); ?>

							<div class="social-content">

								<p class="text"><?php echo esc_html( $phone_title ); ?></p>
								
								<p class="number">
									<a href="tel:<?php echo esc_html( stripslashes( $phone ) ); ?>"><?php echo esc_html( stripslashes( $phone ) ); ?></a>
								</p>
							
							</div>

						</li>

					<?php endif; ?>

					<?php if ( ! empty( $website ) ): ?>
					
						<li class="widget-contact-parent__child">
							
							<?php directorist_icon( 'las la-globe' ); ?>
							
							<div class="social-content">

								<p class="text"><?php echo esc_html( $website_title ); ?></p>

								<p class="link"><?php echo esc_url( $website ); ?></p>

							</div>

						</li>

					<?php endif;?>

					<?php if ( ! empty( $address ) ): ?>

						<li class="widget-contact-parent__child">
							
							<?php directorist_icon( 'las la-map-marker' ); ?>
							
							<div class="social-content">

								<p class="text"><?php echo esc_html( $address_title ); ?></p>

								<p class="address"><?php echo ! empty( $address ) ? esc_html( $address ) : ''; ?></p>

							</div>

						</li>

					<?php endif;?>

				</ul>

			</div>

		</div>

		<div class="widget-contact-bottom">

			<div class="widget-module-content">
				
				<?php if ( ! empty( $facebook || $twitter || $linkedIn || $youtube ) ): ?>
				
					<ul class="widget-social-parent">
					
						<?php
						if ( $facebook ) {
							printf( '<li class="widget-social-parent__child"><a class="link" target="_blank" href="%s">'. directorist_icon( 'lab la-facebook', false ) .'</a></li>', $facebook );
						}
						if ( $twitter ) {
							printf( '<li class="widget-social-parent__child"><a class="link" target="_blank" href="%s">'. directorist_icon( 'lab la-twitter', false ) .'</a></li>', $twitter );
						}
						if ( $linkedIn ) {
							printf( '<li class="widget-social-parent__child"><a class="link" target="_blank" href="%s">'. directorist_icon( 'lab la-linkedin', false ) .'</a></li>', $linkedIn );
						}
						if ( $youtube ) {
							printf( '<li class="widget-social-parent__child"><a class="link" target="_blank" href="%s">'. directorist_icon( 'lab la-youtube', false ) .'</a></li>', $youtube );
						}
						?>

					</ul>

				<?php endif; ?>

				<button type="button" data-target="#contact_modal" class="btn btn-lg btn-block widget-contact-button dlawyers-grid-cont-btn" data-toggle="modal" data-listing_id="<?php esc_attr( $listing_id );?>">
				<?php directorist_icon( 'la la-envelope color-dark' ) ?><?php echo esc_html( $message ); ?></button>
		
			</div>

		</div>

		<?php
		echo wp_kses_post( $args['after_widget'] );
	}

	public function update( $new_instance, $old_instance ) {
		$instance                  = array();
		$instance['title']         = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
		$instance['phone_title']   = ( ! empty( $new_instance['phone_title'] ) ) ? sanitize_text_field( $new_instance['phone_title'] ) : '';
		$instance['website_title'] = ( ! empty( $new_instance['website_title'] ) ) ? sanitize_text_field( $new_instance['website_title'] ) : '';
		$instance['address_title'] = ( ! empty( $new_instance['address_title'] ) ) ? sanitize_text_field( $new_instance['address_title'] ) : '';
		$instance['message']       = ( ! empty( $new_instance['message'] ) ) ? sanitize_text_field( $new_instance['message'] ) : '';

		return $instance;
	}

	public function form( $instance ) {
		$defaults = array(
			'title'         => '',
			'phone_title'   => '',
			'website_title' => '',
			'address_title' => '',
			'message'       => '',
		);
		
		$instance = wp_parse_args( (array) $instance, $defaults );

		$fields = array(
			'title'         => array(
				'label' => esc_html__( 'Title', 'dlawyers' ),
				'type'  => 'text',
			),
			'phone_title'   => array(
				'label' => esc_html__( 'Phone Title', 'dlawyers' ),
				'type'  => 'text',
			),
			'website_title' => array(
				'label' => esc_html__( 'Website Title', 'dlawyers' ),
				'type'  => 'text',
			),
			'address_title' => array(
				'label' => esc_html__( 'Address Title', 'dlawyers' ),
				'type'  => 'text',
			),
			'message'       => array(
				'label' => esc_html__( 'Message Text', 'dlawyers' ),
				'type'  => 'text',
			),
		);

		Widget_Fields::display( $fields, $instance, $this );
	}
}