<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\dLawyers;

class Socials_Widget extends \WP_Widget {

	public function __construct() {
		$id = 'dlawyers_author_info_socials';
		parent::__construct(
            $id, // Base ID
            esc_html__( 'dLawyers: Socials', 'dlawyers' ), // Name
            array( 'description' => esc_html__( 'dLawyers: Socials', 'dlawyers' ) )
		);
	}

	public function widget( $args, $instance ) {

		echo wp_kses_post( $args['before_widget'] );

		if ( ! empty( $instance['title'] ) ) {
			printf( '%s %s %s', wp_kses_post( $args['before_title'] ) , esc_html( $instance['title'] ), wp_kses_post( $args['after_title'] ) );
		}
		?>

		<ul>

			<?php
			if( !empty( $instance['facebook'] ) ){
				?><li><a href="<?php echo esc_url( $instance['facebook'] ); ?>" target="_blank"><i class="themeicon themeicon-facebook"></i></a></li><?php
			}
			if( !empty( $instance['twitter'] ) ){
				?><li><a href="<?php echo esc_url( $instance['twitter'] ); ?>" target="_blank"><i class="themeicon themeicon-twitter"></i></a></li><?php
			}
			if( !empty( $instance['linkedin'] ) ){
				?><li><a href="<?php echo esc_url( $instance['linkedin'] ); ?>" target="_blank"><i class="themeicon themeicon-linkedin-in"></i></a></li><?php
			}
			if( !empty( $instance['pinterest'] ) ){
				?><li><a href="<?php echo esc_url( $instance['pinterest'] ); ?>" target="_blank"><i class="themeicon themeicon-pinterest"></i></a></li><?php
			}
			if( !empty( $instance['instagram'] ) ){
				?><li><a href="<?php echo esc_url( $instance['instagram'] ); ?>" target="_blank"><i class="themeicon themeicon-instagram"></i></a></li><?php
			}
			if( !empty( $instance['github'] ) ){
				?><li><a href="<?php echo esc_url( $instance['github'] ); ?>" target="_blank"><i class="themeicon themeicon-github"></i></a></li><?php
			}
			if( !empty( $instance['youtube'] ) ){
				?><li><a href="<?php echo esc_url( $instance['youtube'] ); ?>" target="_blank"><i class="themeicon themeicon-youtube"></i></a></li><?php
			}
			if( !empty( $instance['rss'] ) ){
				?><li><a href="<?php echo esc_url( $instance['rss'] ); ?>" target="_blank"><i class="themeicon themeicon-rss-solid"></i></a></li><?php
			}
			?>

		</ul>

		<?php
		echo wp_kses_post( $args['after_widget'] );
	}

	public function update( $new_instance, $old_instance ){
		$instance              = array();
		$instance['title']     = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
		$instance['facebook']  = ( ! empty( $new_instance['facebook'] ) ) ? sanitize_text_field( $new_instance['facebook'] ) : '';
		$instance['twitter']   = ( ! empty( $new_instance['twitter'] ) ) ? sanitize_text_field( $new_instance['twitter'] ) : '';
		$instance['linkedin']  = ( ! empty( $new_instance['linkedin'] ) ) ? sanitize_text_field( $new_instance['linkedin'] ) : '';
		$instance['pinterest'] = ( ! empty( $new_instance['pinterest'] ) ) ? sanitize_text_field( $new_instance['pinterest'] ) : '';
		$instance['youtube']   = ( ! empty( $new_instance['youtube'] ) ) ? sanitize_text_field( $new_instance['youtube'] ) : '';
		$instance['rss']       = ( ! empty( $new_instance['rss'] ) ) ? sanitize_text_field( $new_instance['rss'] ) : '';
		$instance['instagram'] = ( ! empty( $new_instance['instagram'] ) ) ? sanitize_text_field( $new_instance['instagram'] ) : '';
		$instance['github']    = ( ! empty( $new_instance['github'] ) ) ? sanitize_text_field( $new_instance['github'] ) : '';
		return $instance;
	}

	public function form( $instance ){
		$defaults = array(
			'title'      => '',
			'facebook'   => '',
			'twitter'    => '',
			'linkedin'   => '',
			'pinterest'  => '',
			'youtube'    => '',
			'github'     => '',
			'rss'        => '', 
			'instagram'  => '',
		);
		
		$instance = wp_parse_args( (array) $instance, $defaults );

		$fields = array(
			'title'       => array(
				'label'   => esc_html__( 'Title', 'dlawyers' ),
				'type'    => 'text',
			),
			'facebook'    => array(
				'label'   => __( 'Facebook URL', 'dlawyers' ),
				'type'    => 'url',
			),
			'twitter'     => array(
				'label'   => __( 'Twitter URL', 'dlawyers' ),
				'type'    => 'url',
			),
			'linkedin'    => array(
				'label'   => __( 'Linkedin URL', 'dlawyers' ),
				'type'    => 'url',
			),
			'pinterest'   => array(
				'label'   => __( 'Pinterest URL', 'dlawyers' ),
				'type'    => 'url',
			),
			'instagram'   => array(
				'label'   => __( 'Instagram URL', 'dlawyers' ),
				'type'    => 'url',
			),
			'github'   => array(
				'label'   => __( 'Github URL', 'dlawyers' ),
				'type'    => 'url',
			),
			'youtube'     => array(
				'label'   => __( 'YouTube URL', 'dlawyers' ),
				'type'    => 'url',
			),
			'rss'         => array(
				'label'   => __( 'Rss Feed URL', 'dlawyers' ),
				'type'    => 'url',
			),
		);

		Widget_Fields::display( $fields, $instance, $this );
	}
}