<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$tags_obj       = get_the_terms( get_the_ID(), 'at_biz_dir-tags' );
$tags_count     = is_array( $tags_obj ) ? count( $tags_obj ) : 0;

if( ! $tags_count ) {
	return;
}

$tags_html      = '';
$tags_max       = apply_filters( 'dlawyers_max_tags_show', 3 );
$tags_left_html = '';
$tags_left      = $tags_count - $tags_max;

if ( $tags_count > $tags_max ) {

	foreach ( $tags_obj as $key => $value ) {

		if ( 3 > $key ) {
			$tags_html .= sprintf( '<li><a href="%s">%s</a></li>', esc_url( get_term_link( $tags_obj[$key]->slug, $tags_obj[$key]->taxonomy ) ), esc_html( $tags_obj[$key]->name ) );
		} else {
			$tags_left_html .= sprintf( '<a href="%s">%s</a>', esc_url( get_term_link( $tags_obj[$key]->slug, $tags_obj[$key]->taxonomy ) ), esc_html( $tags_obj[$key]->name ) );
		}

	}

} else if ( $tags_count > 0 ) {
	foreach ( $tags_obj as $key => $value ) {
		$tags_html .= sprintf( '<li><a href="%s">%s</a></li>', esc_url( get_term_link( $tags_obj[$key]->slug, $tags_obj[$key]->taxonomy ) ), esc_html( $tags_obj[$key]->name ) );
	}
}
?>

<?php if ( $tags_count > 0 ): ?>

	<div class="directorist-listing-tag">

		<?php printf( '<ul class="tag-list">%s</ul>', wp_kses_post( $tags_html ) );?>

		<div class="directorist-listing-category__popup">
			<?php if ( $tags_count > 3 ): ?>

				<?php printf( '<span class="directorist-listing-category__extran-count"><span>%s</span>%s %s</span>', esc_html__( '+', 'dlawyers' ), esc_html( $tags_left ), esc_html__( 'more', 'dlawyers' ) ); ?>

			<?php endif;?>

			<div class="directorist-listing-category__popup__content">

				<?php echo wp_kses_post( $tags_left_html ); ?>

			</div>
		</div>

	</div>

<?php endif;?>