<?php
/**
 * @author  wpWax
 * @since   6.6
 * @version 7.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<?php do_action( 'directorist_before_author_about_section' ); ?>

<section class="author-profile-about">
	<div class="container">
		<div class="row">
			<div class="col-md-4">
				<div class="theme-contact-box theme-contact-box--info">

					<div class="theme-contact-box__top">
						<h4 class="theme-contact-box__title">
							<?php esc_html_e( 'Contact Info', 'dlawyers' ); ?></h4>
					</div>

					<div class="theme-contact-box__info">
						<ul class="theme-contact-box__info__list">

							<?php if ( $phone ): ?>
							<li class="theme-contact-box__item">
								<?php directorist_icon( 'las la-phone' ); ?>
								<a class="theme-contact-box__item-title"
									href="tel:<?php ATBDP_Helper::sanitize_tel_attr( $phone ); ?>"><?php echo esc_html( $phone ); ?></a>
							</li>
							<?php endif; ?>

							<?php if ( $email_endabled && $email ): ?>
							<li class="theme-contact-box__item">
								<?php directorist_icon( 'las la-envelope' ); ?>
								<div class="theme-contact-box__item-title"><?php echo esc_html( $email ); ?></div>
							</li>
							<?php endif; ?>

							<?php if ( $website ): ?>
							<li class="theme-contact-box__item">
								<?php directorist_icon( 'las la-globe' ); ?>
								<a class="theme-contact-box__item-title" target="_blank"
									href="<?php echo esc_url( $website ); ?>"><?php echo esc_html( $website) ; ?></a>
							</li>
							<?php endif; ?>

						</ul>
						<?php if ( $facebook || $twitter || $linkedin || $youtube ): ?>

						<ul class="theme-contact-box__info__social">

							<?php if ( $facebook ): ?>
							<li class="theme-contact-box__social--item"><a class="theme-contact-box__social--link" target="_blank" href="<?php echo esc_url( $facebook ); ?>"><?php directorist_icon( 'lab la-facebook' ); ?></a></li>
							<?php endif; ?>

							<?php if ( $twitter ): ?>
							<li class="theme-contact-box__social--item"><a class="theme-contact-box__social--link" target="_blank" href="<?php echo esc_url( $twitter ); ?>"><?php directorist_icon( 'lab la-twitter' ); ?></a></li>
							<?php endif; ?>

							<?php if ( $linkedin ): ?>
							<li class="theme-contact-box__social--item"><a class="theme-contact-box__social--link" target="_blank" href="<?php echo esc_url( $linkedin ); ?>"><?php directorist_icon( 'lab la-linkedin' ); ?></a></li>
							<?php endif; ?>

							<?php if ( $youtube ): ?>
							<li class="theme-contact-box__social--item"><a class="theme-contact-box__social--link" target="_blank" href="<?php echo esc_url( $youtube ); ?>"><?php directorist_icon( 'lab la-youtube' ); ?></a></li>
							<?php endif; ?>

						</ul>
						<?php endif; ?>
					</div>

				</div>
			</div>

			<div class="col-md-8">
				<div class="theme-contact-box theme-contact-box--about">

					<div class="theme-contact-box__top">
						<h4 class="theme-contact-box__title"><?php esc_html_e( 'About', 'dlawyers' ); ?></h4>
					</div>

					<div class="theme-contact-box__content">
						<p class="theme-contact-box__content--inner"><?php echo esc_html( $bio ? $bio : esc_html__( 'Nothing to show!', 'dlawyers' ) ); ?></p>
					</div>

				</div>
			</div>

		</div>
	</div>
</section>

<?php do_action( 'directorist_author_listing_after_about_section' ); ?>