<?php
/**
 * @author  wpWax
 * @since   6.6
 * @version 7.4.0
 */

use \Directorist\Directorist_Listing_Author;

$author_id         = Directorist_Listing_Author::instance()->id;
$total_review      = Directorist_Listing_Author::instance()->total_review;
$all_listings      = Directorist_Listing_Author::instance()->all_listings->total;

$review_count_html  = sprintf( _nx( '<span> %s </span> Review', '<span> %s </span> Reviews', $total_review, 'author review count', 'dlawyers' ), $total_review );
$listing_count_html = sprintf( _nx( '<span> %s </span> Listing', '<span> %s </span> Listings', $all_listings, 'author review count', 'dlawyers' ), $all_listings );

$address           = get_user_meta( $author_id, 'address', true );
$user_registered   = get_the_author_meta( 'user_registered', $author_id );
$member_since_text = sprintf( wp_kses_post( __( 'Joined In %s', 'dlawyers' ) ), date( 'M Y', strtotime( $user_registered ) ) );

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<section class="author-header theme-banner-header">
	<div class="container">
		<div class="row">
			<div class="col-md-12">

				<?php do_action( 'directorist_before_author_profile_section' );?>

				<div class="theme-author-profile">
					<div class="d-flex align-items-center theme-author-profile__wrapper">
						<div class="theme-author-profile__avatar">
							<?php echo wp_kses_post( $author->avatar_html() ); ?>
						</div>
						<div class="theme-author-content">
							<h1 class="theme-author-content__title"><?php echo esc_html( $author->display_name() ); ?></h1>

							<?php if ( $address ): ?>
								<p class="theme-author-content__paragraph"><?php echo esc_html( $address ); ?></p>
							<?php endif;?>

							<p class="theme-author-content__paragraph"><?php echo esc_html( $member_since_text ); ?></p>
						</div>
					</div>

					<div class="theme-author-meta">

						<?php if ( $author->review_enabled() ): ?>

						<div class="theme-author-meta__ratings">
							<span>
								<small><?php echo wp_kses_post( $author->rating_count() ); ?></small>
								<?php directorist_icon( 'las la-star' ); ?>
							</span>
								
						</div>

						<div class="theme-author-meta__info">
							<?php echo wp_kses_post( $review_count_html ); ?>
						</div>

						<?php endif;?>

						<div class="theme-author-meta__info">
							<?php echo wp_kses_post( $listing_count_html ); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>