<?php
/**
 * @author  wpWax
 * @since   6.6
 * @version 7.3.1
 */

use \Directorist\Helper;
use \wpWax\dLawyers\Directorist_Support;
use wpWax\dLawyers\Helper as DHelper;
use \Directorist\Directorist_Listing_Author;

$all_listings 		= Directorist_Listing_Author::instance()->all_listings->total ? Directorist_Listing_Author::instance()->all_listings->total : ' ';
$listing_count_html = sprintf( _nx( '<span> %s </span> Author Listing', '<span> %s </span> Author Listings', $all_listings, 'author review count', 'dlawyers' ), $all_listings );

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<section class="author-profile-section">
	<?php if ( 0 != $all_listings) : ?>
		<div class="theme-author-listing-generic">
			<div class="container">
				<div class="row">
					<div class="col-md-12">
						<div class="theme-author-profile-listing">

							<div class="theme-author-profile-listing__title">
								<h3 class="title"><?php echo wp_kses_post( $listing_count_html ); ?></h3>
								
								<?php if ( $author->archive_type( $author ) ) : ?>
									<div class="directorist-author-listing-type">
										<?php $author->archive_type( $author ); ?>
									</div>
								<?php endif; ?>
								
							</div>

							<div class="theme-author-profile-listing__btn">
							

									<div class="directorist-dropdown directorist-dropdown-js directorist-author-listing-top__dropdown directorist-dropdown-update-js">

										<a class="directorist-dropdown__toggle directorist-dropdown__toggle-js directorist-toggle-has-icon directorist-btn directorist-btn-outline-primary" href="#" id="directorist-dropdown-menu-link"><?php esc_html_e( 'Filter by category', 'dlawyers'); ?> <span class="atbd_drop-caret"></span></a>

										<div class="directorist-dropdown__links directorist-dropdown__links-js">

											<?php
											foreach ($author->get_listing_categories() as $category) {
												$active_class = ( isset($_GET['category']) && ($category->slug == $_GET['category']) ) ? 'active' : '';
												$link = add_query_arg( 'category', $category->slug );
												printf('<a class="directorist-dropdown__links--single %s" href="%s">%s</a>', esc_attr( $active_class ), esc_url( $link ), esc_html( $category->name ) );
											}
											?>

										</div>

									</div>


								<?php DHelper::get_template_part( 'directorist/custom/view-mode-author' ); ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	<?php endif; ?>

	<?php do_action( 'directorist_author_listings_before_loop' ); ?>

	<div class="directorist-author-listing-content theme-author-listing-content">

		<div class="container">

			<div class="<?php Helper::directorist_row(); ?>">

				<?php foreach ( $listings->post_ids() as $listing_id ): ?>

					<div class="<?php Helper::directorist_column( Directorist_Support::get_listing_column() ); ?>">

						<?php $listings->loop_template( Directorist_Support::get_view_mode(), $listing_id ); ?>

					</div>

				<?php endforeach; ?>

				<?php if ( 0 == $all_listings ) : ?>
					<div class="theme-archive-notfound"><?php esc_html_e( 'No listings found.', 'dlawyers' ); ?></div>		
				<?php endif; ?>

			</div>
			
		</div>

		<?php
		if ( $author->listing_pagination_enabled() ) {
			$listings->pagination();
		}
		?>

	</div>

</section>