<?php
$listing_id = get_the_ID();

if ( ! get_directorist_option( 'enable_claim_listing', 1 ) ) {
    return; // vail if the business hour is not enabled
}

$claim_header       = get_directorist_option( 'claim_widget_title', esc_html__( 'Is this your business?', 'dlawyers' ) );
$claim_description  = get_directorist_option( 'claim_widget_description', esc_html__( 'Claim listing is the best way to manage and protect your business.', 'dlawyers' ) );
$claim_now          = get_directorist_option( 'claim_now', esc_html__( 'Claim Now!', 'dlawyers' ) );
$claimed_by_admin   = get_post_meta( $listing_id, '_claimed_by_admin', true );
$claim_fee          = get_post_meta( $listing_id, '_claim_fee', true );

if ( $claimed_by_admin || ( 'claim_approved' === $claim_fee ) ) {
    return;
}
?>

<div class="theme-listing-about-details__claim">

    <a href="#" class="theme-listing-about-details__claim--btn btn btn-primary w-100 directorist-btn-modal directorist-btn-modal-js" data-directorist_target="directorist-claim-listing-modal" ><?php echo esc_html( $claim_now ); ?></a>

    <input type="hidden" id="directorist__post-id" value="<?php echo get_the_ID(); ?>"/>

</div>

<div class="directorist-modal directorist-modal-js directorist-fade directorist-claim-listing-modal directorist-claimer">

    <div class="directorist-modal__dialog directorist-modal__dialog-md">

        <div class="directorist-modal__content">
            
            <?php if ( is_user_logged_in() ) : ?>
                
                <form id="directorist-claimer__form" class="directorist-claimer__form" role="form">

                    <div class="directorist-modal__header">
                        <h3 class="directorist-modal-title" id="directorist-claim-label"><?php esc_html_e('Claim This Listing', 'dlawyers'); ?></h3>
                        <a href="#" class="directorist-modal-close directorist-modal-close-js"><span aria-hidden="true">&times;</span></a>
                    </div>

                    <div class="directorist-modal__body">

                        <div class="directorist-form-group">
                            <label for="directorist-claimer__name" class="directorist-claimer__name"><?php esc_html_e('Full Name', 'dlawyers'); ?> <span class="directorist-claimer__star-red">*</span></label>
                            <input type="text" class="directorist-form-element" id="directorist-claimer__name" placeholder="<?php esc_attr_e('Full Name', 'dlawyers'); ?>" required>
                        </div>

                        <div class="directorist-form-group">
                            <label for="directorist-claimer__phone" class="directorist-claimer__phone"><?php esc_html_e('Phone', 'dlawyers'); ?> <span class="directorist-claimer__star-red">*</span></label>
                            <input type="tel" class="directorist-form-element" id="directorist-claimer__phone" placeholder="<?php esc_attr_e('111-111-235', 'dlawyers'); ?>" required>
                        </div>

                        <div class="directorist-form-group">
                            <label for="directorist-claimer__details" class="directorist-claimer__details"><?php esc_html_e('Verification Details', 'dlawyers'); ?> <span class="directorist-claimer__star-red">*</span></label>
                            <textarea class="directorist-form-element" id="directorist-claimer__details" rows="3" placeholder="<?php esc_attr_e('Details description about your business', 'dlawyers'); ?>..." required></textarea>
                        </div>

                        <div class="directorist-form-group">
                            <?php
                            $claim_charge_by    = get_directorist_option( 'claim_charge_by' );
                            $charged_by         = get_post_meta( $listing_id, '_claim_fee', true );
                            $charged_by         = ( $charged_by !== '' ) ? $charged_by : $claim_charge_by;
                            $has_plans          = is_pricing_plans_active();

                            if ( ! empty( $has_plans ) && ( 'pricing_plan' === $charged_by ) ) {
                                if ( class_exists( 'ATBDP_Pricing_Plans' ) ) {
                                    $args = array(
                                        'post_type'         => 'atbdp_pricing_plans',
                                        'posts_per_page'    => -1,
                                        'status'            => 'publish'
                                    );

                                    $metas = [];
                                    $metas['exclude'] = [
                                        'relation' => 'OR',
                                        array(
                                            'key'       => '_hide_from_plans',
                                            'compare'   => 'NOT EXISTS',
                                        ),
                                        array(
                                            'key'       => '_hide_from_plans',
                                            'value'     => 1,
                                            'compare'   => '!=',
                                        )
                                    ];
                                    
                                    if ( ! empty( $directory_type ) ) {
                                        $metas['directory'] = [
                                            'key'       => '_assign_to_directory',
                                            'value'     => $directory_type,
                                            'compare'   => '=',
                                        ];
                                    }

                                    $args['meta_query'] = array_merge( array( 'relation' => 'AND' ), $metas );

                                    $atbdp_query = new WP_Query( $args );

                                    if ( $atbdp_query->have_posts() ) {
                                        global $post;

                                        $plans = $atbdp_query->posts;
                                        printf( '<label for="select_plans">%s</label>', esc_html__( 'Select Plan', 'dlawyers' ) );
                                        printf( '<select id="directorist-claimer__plan">' );
                                        printf( '<option>%s</option>', esc_html__( '- Select Plan -', 'dlawyers' ) );

                                        foreach ( $plans as $key => $value ) {
                                            $active_plan = subscribed_package_or_PPL_plans( get_current_user_id(), 'completed', $value->ID );
                                            $plan_type = get_post_meta( $value->ID, 'plan_type', true );
                                            printf( '<option %s value="%s">%s %s</option>', ( !empty( $active_plan ) && ( 'package' === $plan_type ) ) ? 'class="directorist__active-plan"' : '', $value->ID, $value->post_title, !empty( $active_plan ) && ( 'package' === $plan_type ) ? '<span class="atbd_badge">' . esc_html__( '- Active', 'dlawyers' ) . '</span>' : '' );
                                        }
                                        printf( '</select>' );
                                        ?>

                                        <div id="directorist__plan-allowances" data-author_id="<?php echo get_current_user_id(); ?>"></div>

                                        <?php
                                        printf( '<a target="_blank" href="%s" class="directorist__plans">%s</a>', esc_url( ATBDP_Permalink::get_fee_plan_page_link() ), esc_html__( 'Show plan details', 'dlawyers' ) );
                                    }

                                } else {

                                    global $product;
                                    $query_args = array(
                                        'post_type' => 'product',
                                        'tax_query' => array(
                                            array(
                                                'taxonomy' => 'product_type',
                                                'field' => 'slug',
                                                'terms' => 'listing_pricing_plans',
                                            ),
                                        ),
                                        'meta_query' => array(
                                            'relation' => 'OR',
                                            array(
                                                'key' => '_hide_from_plans',
                                                'compare' => 'NOT EXISTS',
                                            ),
                                            array(
                                                'key' => '_hide_from_plans',
                                                'value' => 1,
                                                'compare' => '!=',
                                            ),
                                        ),
                                    );

                                    $atbdp_query = new WP_Query($query_args);

                                    if ( $atbdp_query->have_posts() ) {
                                        global $post;

                                        $plans = $atbdp_query->posts;
                                        printf( '<label for="select_plans">%s</label>', esc_html__( 'Select Plan', 'dlawyers') );
                                        printf( '<select id="directorist-claimer__plan">' );
                                        printf( '<option>%s</option>', esc_html__( '- Select Plan -', 'dlawyers') );

                                        foreach ( $plans as $key => $value ) {
                                            $active_plan = subscribed_package_or_PPL_plans( get_current_user_id(), 'completed', $value->ID );
                                            $plan_type = get_post_meta( $value->ID, 'plan_type', true );

                                            printf( '<option %s value="%s">%s %s</option>', ( ! empty( $active_plan ) && ( 'package' === $plan_type ) ) ? 'class="directorist__active-plan"' : '', $value->ID, $value->post_title, !empty( $active_plan ) && ( 'package' === $plan_type ) ? '<span class="atbd_badge">' . esc_html__( '- Active', 'dlawyers' ) . '</span>' : '' );
                                        }
                                        printf( '</select>' );
                                        ?>

                                        <div id="directorist__plan-allowances" data-author_id="<?php echo get_current_user_id(); ?>">

                                            <?php do_action( 'wp_ajax_dcl_plan_allowances', $listing_id ); ?>

                                        </div>
                                        
                                        <?php
                                        printf( '<a target="_blank" href="%s">%s</a>', esc_url( ATBDP_Permalink::get_fee_plan_page_link() ), esc_html__( ' Show plan details', 'dlawyers' ) );
                                    }
                                }
                            }
                            ?>

                        </div>

                        <div id="directorist-claimer__submit-notification"></div>

                        <div id="directorist-claimer__warning-notification"></div>

                    </div>

                    <div class="directorist-modal__footer">

                        <button type="submit" class=" theme-bg-primary directorist-btn directorist-btn-primary"><?php esc_html_e('Submit', 'dlawyers'); ?></button>

                        <span><?php directorist_icon( 'las la-star' ); ?><?php esc_html_e('Secure Claim Process', 'dlawyers'); ?></span>

                    </div>

                </form>

            <?php else : ?>
                
                <div class="directorist-modal__header">

                    <h3 class="directorist-modal-title" id="directorist-claim-label"><?php esc_html_e('Claim This Listing', 'dlawyers'); ?></h3>

                    <a href="#" class="directorist-modal-close directorist-modal-close-js"><span aria-hidden="true">&times;</span></a>

                </div>

                <div class="directorist-modal__body">

                    <div class="directorist-claim-listing">

                        <div class="directorist-alert-info">

                            <?php directorist_icon( 'fa fa-info-circle' ); ?>

                            <?php
                            // get the custom registration page id from the db and create a permalink
                            $reg_link_custom = ATBDP_Permalink::get_registration_page_link();
                            //if we have custom registration page, use it, else use the default registration url.
                            $reg_link = !empty($reg_link_custom) ? $reg_link_custom : wp_registration_url();

                            $login_url = '<a href="' . ATBDP_Permalink::get_login_page_link() . '">' . esc_html__('Login', 'dlawyers') . '</a>';
                            $register_url = '<a href="' . esc_url($reg_link) . '">' . esc_html__('Register', 'dlawyers') . '</a>';

                            printf( wp_kses_post( __('You need to %s or %s to claim this listing', 'dlawyers') ), $login_url, $register_url );
                            ?>
                        </div>

                    </div>
            
                </div>

            <?php endif; ?>

        </div>

    </div>

</div>