<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

use wpWax\dLawyers\Directorist_Support;

?>

<div class="theme-header-action__author-info">

	<?php
	$author_id     = get_user_meta( get_current_user_id(), 'pro_pic', true );
	$profile_image = wp_get_attachment_image_src( $author_id );
	$avatar_img = get_avatar( get_current_user_id(), 40, null, null, array( 'class' => 'rounded-circle' ) );

	if ( empty( $profile_image ) ) {
		echo wp_kses_post( $avatar_img );
		if( atbdp_is_page( 'dashboard' ) ) {
			printf( '<span> %s,<span> %s</span></span>', esc_html__( 'Hi', 'dlawyers' ) , get_the_author_meta('display_name', get_current_user_id() ) ) ;
		}

	} else {
		echo sprintf( '<img width="40" src="%s" alt="%s" class="img-fluid"/>', esc_url( $profile_image[0] ), get_the_author_meta( 'display_name', get_current_user_id() ) );
	}
	?>

	<?php echo Directorist_Support::get_dashboard_navigation(); ?>

</div>										