<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$mixed_value 	= isset( $data['value'] ) ? $data['value'] : '';
$mixed_array 	= explode( '___', $mixed_value );
$checked 		= isset( $mixed_array[0] ) ? $mixed_array[0] : '';
$free_con_value = isset( $mixed_array[1] ) ? $mixed_array[1] : '';
?>

<div class="directorist-form-group directorist-custom-field-checkbox directorist-custom-field-text">
	<div class="directorist-free-consultation-wrap directorist-flex">
		<div class="directorist-checkbox">
			<input type="checkbox" name="enable_free_consultation" id="enable_free_consultation" <?php echo ! empty( $checked ) && 'false' != $checked ? 'checked value="checked"' : ''; ?>>
			<label for="enable_free_consultation" class="directorist-checkbox__label"></label>
		</div>
		
		<label class="directorist-form-label" for="enable_free_consultation"><?php echo esc_html( $data['label'] ); ?>:<?php echo !empty( $data['required'] ) ? '<span class="directorist-form-required"> *</span>' : ''; ?></label>

	</div>
	

	<input type="text" name="<?php echo esc_attr( $data['field_key'] ); ?>" id="<?php echo esc_attr( $data['field_key'] ); ?>" class="directorist-form-element" value="<?php echo esc_attr( $free_con_value ); ?>" placeholder="<?php echo esc_attr( $data['placeholder'] ); ?>" <?php $listing_form->required( $data ); ?>>

	<?php $listing_form->field_description_template( $data ); ?>

</div>