

<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

use wpWax\dLawyers\Directorist_Support;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$data = $args['data'];
?>

<?php if ( Directorist_Support::has_field_in_search_form( $data['widget_name'], $searchform, 'advance' ) ) : ?>

	<div class="directorist-search-field">

		<label><?php echo esc_html( $data['label'] ); ?></label>

		<div class="directorist-form-group directorist-advanced-filter__advanced--element directorist-advanced-filter__advanced--radio">

			<div class="directorist-search-field">

				<div class="directorist-radio directorist-radio-circle directorist-dlawyers-radio-circle">
					<input type="radio" id="1to40" name="custom_field[<?php echo esc_attr( $data['widget_name'] ); ?>]" value="1to40">
					<label class="directorist-radio__label" for="1to40"><?php esc_html_e( '40 And Younger', 'dlawyers' ); ?></label>
				</div>
				<div class="directorist-radio directorist-radio-circle directorist-dlawyers-radio-circle">
					<input type="radio" id="41to50" name="custom_field[<?php echo esc_attr( $data['widget_name'] ); ?>]" value="41to50">
					<label class="directorist-radio__label" for="41to50"><?php esc_html_e( '41 to 50', 'dlawyers' ); ?></label>
				</div>
				<div class="directorist-radio directorist-radio-circle directorist-dlawyers-radio-circle">
					<input type="radio" id="51to60" name="custom_field[<?php echo esc_attr( $data['widget_name'] ); ?>]" value="51to60">
					<label class="directorist-radio__label" for="51to60"><?php esc_html_e( '51 to 60', 'dlawyers' ); ?></label>
				</div>
				<div class="directorist-radio directorist-radio-circle directorist-dlawyers-radio-circle">
					<input type="radio" id="61to70" name="custom_field[<?php echo esc_attr( $data['widget_name'] ); ?>]" value="61to70">
					<label class="directorist-radio__label" for="61to70"><?php esc_html_e( '61 to 70', 'dlawyers' ); ?></label>
				</div>
				<div class="directorist-radio directorist-radio-circle directorist-dlawyers-radio-circle">
					<input type="radio" id="71to150" name="custom_field[<?php echo esc_attr( $data['widget_name'] ); ?>]" value="71to150">
					<label class="directorist-radio__label" for="71to150"> <?php esc_html_e( '71 And Older', 'dlawyers' ); ?></label>
				</div>

			</div>

		</div>

	</div>

<?php else: ?>

	<div class="directorist-search-field theme-search-dropdown">

		<div class="theme-search-dropdown__label">
			<label><?php echo esc_html( $data['label'] ); ?></label>
		</div>

		<div class="theme-search-dropdown-toggle">

			<div class="directorist-form-group">

				<div class="directorist-search-field">

					<div class="directorist-radio directorist-radio-circle directorist-dlawyers-radio-circle">
						<input type="radio" id="1to40" name="custom_field[<?php echo esc_attr( $data['widget_name'] ); ?>]" value="1to40">
						<label class="directorist-radio__label" for="1to40"><?php esc_html_e( '40 And Younger', 'dlawyers' ); ?></label>
					</div>
					<div class="directorist-radio directorist-radio-circle directorist-dlawyers-radio-circle">
						<input type="radio" id="41to50" name="custom_field[<?php echo esc_attr( $data['widget_name'] ); ?>]" value="41to50">
						<label class="directorist-radio__label" for="41to50"><?php esc_html_e( '41 to 50', 'dlawyers' ); ?></label>
					</div>
					<div class="directorist-radio directorist-radio-circle directorist-dlawyers-radio-circle">
						<input type="radio" id="51to60" name="custom_field[<?php echo esc_attr( $data['widget_name'] ); ?>]" value="51to60">
						<label class="directorist-radio__label" for="51to60"><?php esc_html_e( '51 to 60', 'dlawyers' ); ?></label>
					</div>
					<div class="directorist-radio directorist-radio-circle directorist-dlawyers-radio-circle">
						<input type="radio" id="61to70" name="custom_field[<?php echo esc_attr( $data['widget_name'] ); ?>]" value="61to70">
						<label class="directorist-radio__label" for="61to70"><?php esc_html_e( '61 to 70', 'dlawyers' ); ?></label>
					</div>
					<div class="directorist-radio directorist-radio-circle directorist-dlawyers-radio-circle">
						<input type="radio" id="71to150" name="custom_field[<?php echo esc_attr( $data['widget_name'] ); ?>]" value="71to150">
						<label class="directorist-radio__label" for="71to150"> <?php esc_html_e( '71 And Older', 'dlawyers' ); ?></label>
					</div>

				</div>

			</div>

		</div>

	</div>

<?php endif;