<?php
/**
 * @author  wpWax
 * @since   6.6
 * @version 7.0.3.2
 */

use wpWax\dLawyers\Directorist_Support;

if ( ! defined( 'ABSPATH' ) ) exit;

$submission_form_fields = Directorist_Support::get_submission_form_fields( $args['searchform']->listing_type );
$gender_options 		= isset( $submission_form_fields['fields']['dlawyers_gender']['options'] ) ? $submission_form_fields['fields']['dlawyers_gender']['options'] : '';

if( ! $gender_options  ) {
	return;
}

$option_key = 'dlawyers_gender';
$label		= $submission_form_fields['fields']['dlawyers_gender']['label'];

if( empty( $gender_options ) ){
	return;
}
?>

<?php if ( Directorist_Support::has_field_in_search_form( 'dlawyers_gender', $searchform, 'advance' ) ): ?>

	<div class="directorist-search-field">

		<?php if ( !empty( $label ) ): ?>
			<label><?php echo esc_html( $label ); ?></label>
		<?php endif; ?>
		<?php
		foreach ( $gender_options as $key => $option ){
			$uniqid = $option['option_value'] . '-' .wp_rand();
			?>

			<div class="directorist-radio directorist-radio-circle directorist-dlawyers-radio-circle mb-1">
				<input type="radio" id="<?php echo esc_attr( $uniqid ); ?>" name="custom_field[<?php echo esc_attr( $option_key ); ?>]" value="<?php echo esc_attr( $option['option_value'] ); ?>">
				<label class="directorist-radio__label" for="<?php echo esc_attr( $uniqid ); ?>"><?php echo esc_html( $option['option_label'] ); ?></label>
			</div>

			<?php
		}
		?>

	</div>

<?php else: ?>

	<div class="directorist-search-field theme-search-dropdown">

		<div class="theme-search-dropdown__label">
			<label><?php echo esc_html( $label ); ?></label>
		</div>

		<div class="theme-search-dropdown-toggle">

			<?php
			foreach ( $gender_options as $key => $option ){
				$uniqid = $option['option_value'] . '-' .wp_rand();
				?>

				<div class="directorist-radio directorist-gender-circle">
					<input type="radio" id="<?php echo esc_attr( $uniqid ); ?>" name="custom_field[<?php echo esc_attr( $option_key ); ?>]" value="<?php echo esc_attr( $option['option_value'] ); ?>">
					<label class="directorist-radio__label" for="<?php echo esc_attr( $uniqid ); ?>"><?php echo esc_html( $option['option_label'] ); ?></label>
				</div>

				<?php
			}
			?>

		</div>

	</div>

<?php endif;?>