<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

use Directorist\Directorist_Listing_Search_Form;
use wpWax\dLawyers\Directorist_Support;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$searchform         = new Directorist_Listing_Search_Form( 'search_form', (int) Directorist_Support::get_directory_type() );
$search_field_types = $searchform->form_data;
$pricing_slider     = isset( $search_field_types[0]['fields']['ddoctors-pricing-slider'] ) ? true : false;

$get_max_price      = Directorist_Support::get_max_price( (int) Directorist_Support::get_directory_type() );
$min_price          = $searchform->price_value('min') ? $searchform->price_value('min') : 0;
$max_price          = $searchform->price_value('max') ? $searchform->price_value('max') : $get_max_price;
?>

<?php if ( Directorist_Support::has_field_in_search_form( 'radius_search', $searchform, 'advance' ) ): ?>

	<div class="directorist-search-field">

		<?php if ( !empty($data['label']) ): ?>
			<label><?php echo esc_html( $data['label'] ); ?></label>
		<?php endif; ?>

		<div class="directorist-form-group">
			<div class="consultation_ranger default-ad-search">
				<div class="card-content">
					<div class="form-group">
						<div class="price-range rs-primary">
							<div class="price-range__input-values d-none">
								<input type="hidden" name="price[0]" class="price-range__input-values__min" value="">
								<input type="hidden" name="price[1]" class="price-range__input-values__max" value="">
								<input type="hidden" class="pricing-range__values" data-currency-symbol="<?php echo Directorist_Support::get_currency_symbol(); ?>" data-min-price="<?php echo esc_attr( $min_price ); ?>" data-max-price="<?php echo esc_attr( $max_price ); ?>">
							</div>
							<div class="slider-range"></div>
							<p class="slider-peragraph"><span class="amount"></span></p>
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>

<?php else: ?>

	<div class="directorist-search-field theme-search-dropdown">

		<div class="theme-search-dropdown__label">

			<label><?php echo esc_html( $data['label'] ); ?></label>

		</div>

		<div class="theme-search-dropdown-toggle">

			<div class="directorist-form-group">
				<div class="consultation_ranger default-ad-search">
					<div class="card-content">
						<div class="form-group">
							<div class="price-range rs-primary">

								<div class="price-range__input-values d-none">
									<input type="hidden" name="price[0]" class="price-range__input-values__min" value="">
									<input type="hidden" name="price[1]" class="price-range__input-values__max" value="">
									<input type="hidden" class="pricing-range__values" data-currency-symbol="<?php echo Directorist_Support::get_currency_symbol(); ?>" data-min-price="<?php echo esc_attr( $min_price ); ?>" data-max-price="<?php echo esc_attr( $max_price ); ?>">
								</div>
								
								<div class="slider-range"></div>
								<p class="slider-peragraph"><span class="amount"></span></p>
							</div>
						</div>
					</div>
				</div>
			</div>

		</div>

	</div>

<?php endif;?>
