<?php
/**
 * @author  wpWax
 * @since   6.7
 * @version 7.3.1
 */

use \Directorist\Helper;
use \Directorist\Directorist_Single_Listing;

if ( ! defined( 'ABSPATH' ) ) exit;

$listing = Directorist_Single_Listing::instance();
?>

<div class="directorist-single-contents-area directorist-w-100" data-id="<?php echo esc_attr( $listing->id ?? ''); ?>">
	<div class="container">
		<div class="mt-3">
			<?php $listing->notice_template(); ?>
		</div>

		<div class="<?php Helper::directorist_row(); ?>">
		
			<div class="col-md-12">

				<?php if( $listing->current_user_is_author() || $listing->submit_link() || $listing->display_back_link() ): ?>

					<?php Helper::get_template( 'single/top-actions' ); ?>
					
				<?php endif; ?>

				<?php $listing->header_template(); ?>
			</div>

			<div class="<?php Helper::directorist_single_column(); ?>">
				<?php
				foreach ( $listing->content_data as $section ) {
					$listing->section_template( $section );
				}
				?>
			</div>

			<?php Helper::get_template( 'single-sidebar' ); ?>

		</div>
	</div>
</div>
