<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

use wpWax\dLawyers\Directorist_Support;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$widget_value = get_post_meta( get_the_ID(), '_' . $data['widget_name'], true );
$widget_label       = Directorist_Support::get_single_listing_widget_label( $data );

if ( ! $widget_value ) {
	return;
}

$mixed_array  = explode( '___', $widget_value );

if( empty( $mixed_array[0] ) || 'false' == $mixed_array[0] ) {
	return;
}

$widget_value = ! empty( $mixed_array[1] ) ? $mixed_array[1] : esc_html__( 'Available', 'dlawyers' );
?>

<div class="directorist-single-info directorist-single-info-text">

	<div class="directorist-single-info__label">
		<span class="directorist-single-info__label-icon"><?php directorist_icon( $icon );?></span>
		<span class="directorist-single-info__label--text"><?php echo esc_html( $widget_label ); ?></span>
	</div>
	
	<div class="directorist-single-info__value"><?php echo esc_html( $widget_value ); ?></div>
	
</div>