<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

use \Directorist\Helper;
use wpWax\dLawyers\Directorist_Support;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$widget_label = Directorist_Support::get_single_listing_widget_label( $args );
$id			  = get_the_ID();

if ( ! Helper::has_price_range( $id ) && ! Helper::has_price( $id ) ) {
	return;
}
?>

<div class="directorist-single-info directorist-single-info-text">

	<div class="directorist-single-info__label">
		<span class="directorist-single-info__label-icon"><?php directorist_icon( $icon );?></span>
		<span class="directorist-single-info__label--text"><?php echo esc_html( $widget_label ); ?></span>
	</div>
	
	<div class="directorist-single-info__value">

		<?php
		if ( 'range' === Helper::pricing_type( $id ) ) {
			Helper::price_range_template( $id );
		} else {
			Helper::price_template( $id );
		}
		?>

	</div>	

</div>