<?php
/**
 * @author  wpWax
 * @since   6.7
 * @version 7.5
 */

 use Directorist\Directorist_Single_Listing;
 use Directorist\Helper;
 use wpWax\dLawyers\Directorist_Support;
 use wpWax\dLawyers\Helper as DHelper;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$display_title             = isset( $display_title['options']['fields'] ) ? $display_title['options']['fields'] : $display_title;
$enable_title              = isset( $display_title['enable_title'] ) && ! empty( $display_title['enable_title'] ) ? true : false;
$enable_tagline            = isset( $display_title['enable_tagline'] ) && ! empty( $display_title['enable_tagline'] ) ? true : false;
$enable_gender             = isset( $display_title['enable_gender'] ) && ! empty( $display_title['enable_gender'] ) ? true : false;
$enable_age                = isset( $display_title['enable_age'] ) && ! empty( $display_title['enable_age'] ) ? true : false;
$enable_reviews            = isset( $display_title['enable_reviews'] ) && ! empty( $display_title['enable_reviews'] ) ? true : false;
$enable_claim_listing      = isset( $display_title['enable_claim_listing'] ) && ! empty( $display_title['enable_claim_listing'] ) ? true : false;
$enable_consultation       = isset( $display_title['enable_consultation'] ) && ! empty( $display_title['enable_consultation'] ) ? true : false;
$dlawyers_get_consultation = $enable_consultation && ! empty( $display_title['enable_consultation_text'] ) ? $display_title['enable_consultation_text'] : false;

$dlawyers_get_gender   = $enable_gender ? get_post_meta( $listing->id, '_dlawyers_gender', true ) : '';
$dlawyers_get_age      = $enable_age ? get_post_meta( $listing->id, '_dlawyers_age', true ) : '';
$dlawyers_rating_count = $listing->get_rating_count() ? ceil( $listing->get_rating_count() ) : 0;
$dlawyers_review_count_html = sprintf( _nx( '<span> %s </span> Review', '<span> %s </span> Reviews', $listing->get_review_count(), 'review count', 'dlawyers' ), $listing->get_review_count() );

$feature_image = $listing->get_slider_data()['images'][0];
?>

<div class="theme-listing-details-card">

	<div class="theme-listing-details-card__body">

		<div class="theme-listing-details-card__module">

			<div class="theme-listing-details-card__left">

				<div class="theme-listing-about-details">

					<div class="theme-listing-about-details__img">

						<img src="<?php echo esc_url( $feature_image['src'] ); ?>" alt="<?php echo esc_attr( $feature_image['alt'] ); ?>" class="plasmaSlider__bgImg plasmaSlider__cover">

						<?php if ( class_exists( 'DCL_Base' ) && $enable_claim_listing ): ?>

							<?php DHelper::get_template_part( 'directorist/custom/claim-listing-template' );?>

						<?php endif;?>

					</div>

					<div class="theme-listing-about-details__title directorist-single-wrapper">

						<?php if ( $enable_title ): ?>

							<div class="theme-listing-about-details__title--title">

								<h2><?php echo esc_html( $listing->get_title() ); ?></h2>

								<?php do_action( 'directorist_single_listing_after_title', $listing->id );?>

							</div>

						<?php endif;?>

						<div class="theme-listing-about-details__separator">

							<?php if ( $enable_tagline && $listing->get_tagline() ): ?>

								<span class="directorist-listing-details-tagline">

									<?php echo esc_html( $listing->get_tagline() ); ?>

								</span>

							<?php endif;?>

							<?php if ( $enable_gender && $dlawyers_get_gender ): ?>

								<span class="directorist-listing-details-gender">

									<?php echo esc_html( $dlawyers_get_gender ? $dlawyers_get_gender : '' ); ?>

								</span>

							<?php endif;?>

							<?php if ( $enable_age && $dlawyers_get_age ): ?>

								<span class="directorist-listing-details-age">

									<?php printf( '%s %s', esc_html__( 'Age', 'dlawyers' ), esc_html( $dlawyers_get_age ) );?>

								</span>

							<?php endif;?>

						</div>

						<?php if ( $enable_reviews && $dlawyers_rating_count ): ?>

							<div class="rating-wrappers">

								<div class="directorist-rated-stars">

									<strong class="avg-rating"><?php echo esc_html( $listing->get_rating_count() ); ?></strong>

									<?php Directorist_Support::get_rating_stars_html( $listing->get_rating_count() );?>

								</div>

								<div class="number-of-review">

									<a href="#directorist-review-block"><?php echo wp_kses_post( $dlawyers_review_count_html ); ?></a>

								</div>

							</div>

						<?php endif;?>

						<?php if ( $enable_consultation && $dlawyers_get_consultation ): ?>

							<?php printf( '<div class="directorist-listing-card-checkbox">%s %s</div>', directorist_icon( 'uil uil-check', false ), $dlawyers_get_consultation );?>

						<?php endif;?>

						<?php $listing->quick_info_template();?>

					</div>

				</div>

			</div>

			<div class="theme-listing-details-card__right">

				<?php $listing->quick_actions_template();?>

			</div>

		</div>

	</div>

</div>
