<?php
/**
 * @author  wpWax
 * @since   6.7
 * @version 6.7
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$review = array_filter( $listing->content_data, function ( $item ) {
	return isset( $item['widget_name'] ) && ( 'review' === $item['widget_name'] ) ? true : false;
} );

$more_than_two = [];

if ( empty( $review ) ) {
	$count         = count( $actions );
	if ( $count > 2 ) {
		$more_than_two = array_splice( $actions, 2 );
	}
}
?>

<div class="directorist-single-listing-action directorist-single-listing-action-quick directorist-single-listing-quick-action directorist-flex directorist-align-center">

		<?php
		foreach ( $actions as $action ) {
			$listing->field_template( $action );
		}
		?>

		<?php if ( $more_than_two ): ?>

			<div class="directorist-single-listing-action__extra">

				<div class="dropdown theme-dropdown">

					<a href="#" class="dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
						<?php directorist_icon( 'fas fa-ellipsis-h' );?>
					</a>

					<div class="dropdown-menu">

						<?php foreach ( $more_than_two as $action ) {
							$listing->field_template( $action );
						}?>

					</div>

				</div>

			</div>

		<?php endif;?>

	</div>