<?php
/**
 * @author  wpWax
 * @since   6.7
 * @version 6.7
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if ( empty( $listing->get_location_list() ) ) {
	return;
}

use Directorist\Asset_Loader\Asset_Loader;
use Directorist\Directorist_Single_Listing;
$listing = Directorist_Single_Listing::instance();

Asset_Loader::enqueue_map_scripts();

$display_direction_map = get_directorist_option( 'display_direction_map', 1 );
$manual_lat            = get_post_meta( $listing->id, '_manual_lat', true );
$manual_lng            = get_post_meta( $listing->id, '_manual_lng', true );
$info_content          = '';

if ( ! empty( $display_direction_map ) ) {
	$icon = directorist_icon( 'las la-location-arrow', false );
	$info_content .= "<a class='get-direction' href='http://www.google.com/maps?daddr={$manual_lat},{$manual_lng}' target='_blank'> 
	{$icon}" . esc_html__( 'Get Direction', 'dlawyers' ) . "</a>";
}
?>

<div class="directorist-card directorist-card-rates-section <?php echo esc_attr( $class ); ?>" <?php $listing->section_id( $id );?>>

	<div class="directorist-card__header">
		<h4 class="directorist-card__header__title"><?php directorist_icon( $icon );?><?php echo esc_html( $label ); ?></h4>
		<?php echo wp_kses_post( $info_content ); ?>
	</div>

	<div class="directorist-card__body directorist-details-info-wrap">
		<div class="directorist-single-map" data-map="<?php echo esc_attr( $listing->map_data() ); ?>"></div>
	</div>

</div>