<?php
/**
 * @author  wpWax
 * @since   6.6
 * @version 7.0.5.2
 */

use \Directorist\Directorist_Single_Listing;

if ( ! defined( 'ABSPATH' ) ) exit;

$listing = Directorist_Single_Listing::instance();
?>

<div class="directorist-flex directorist-align-center directorist-justify-content-between">

	<?php if ( $listing->current_user_is_author() ) : ?>

		<div>

			<?php if ( $listing->submit_link() ) : ?>

				<a href="<?php echo esc_url( $listing->submit_link() ); ?>" class="directorist-btn directorist-btn-sm directorist-btn-success directorist-signle-listing-top__btn-continue"><?php esc_html_e( 'Continue', 'dlawyers' ); ?></a>

			<?php endif; ?>

			<a href="<?php echo esc_url( $listing->edit_link() ) ?>" class="directorist-btn directorist-btn-sm directorist-btn-outline-light directorist-signle-listing-top__btn-edit">
				<?php directorist_icon( 'las la-edit' ); ?>
				<?php esc_html_e( 'Edit', 'dlawyers' ); ?>
			</a>

		</div>

	<?php endif; ?>

</div>